<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" indent="yes"/>
<xsl:template match="/OMA">
    <html>
      <head>
        <link href="/oma/css/common.css" rel="stylesheet" type="text/css" />
        <link href="/oma/css/button.css" rel="stylesheet" type="text/css" />
        <script language="javascript" src="/oma/js/prototype.js" type="text/javascript"></script>
        <script language="javascript" src="/oma/js/Clarity.js" type="text/javascript"></script>
        <script language="javascript">
	var g_bModal = false;
		function unlockPage()
		{
			var ctc = document.getElementById("ct");
			if( ctc != null)
			{
				parent.ct.clearLock ();
			}
		}
	
	<xsl:if test="Caller != '' ">
		
			function loadOrigPage()
			{
				document.location.href = '<xsl:value-of select="translate(Caller, ';', '&amp;amp;' )"/>' ;
			}
	
	</xsl:if>
	</script>
</head>
<body onload="javascript:unlockPage()">
  <center>
  <div class="table_container">
    <div class="container">
      <div class="c_container_top_right">
        <div class="c_container_top_left">
          <div class="c_container_gradient">
            <div class="alert_container_title">
              <xsl:value-of select="$strAlert"/>
            </div>
          </div>
        </div>
      </div>
      <div class="c_container_right">
        <div class="c_container_left">
          <div class="alert_container_content">
            <table>
              <tr>
                <td class="critical"> </td>
                <td class="alert_info">
                  <div class="crital_message">
                    <xsl:value-of select="$strTheActionPerformed"/>
                    <xsl:value-of select="$strColon"/>
                    <xsl:text> </xsl:text>
                  </div>
                  <xsl:call-template name="failure-reason" />
                  <xsl:value-of select="$str"/>
                </td>
              </tr>
            </table>
          </div>
        </div>
      </div>
      <div class="c_container_bottom_right">
        <div class="c_container_bottom_left">
          <div class="c_container_bottom"> </div>
        </div>
      </div>
    </div>
  </div>
  <xsl:choose>
	<xsl:when test="Failure/errID = '1201' "></xsl:when>
	<xsl:otherwise>
	 <div class="page_container">
			 <table width="100" border="0" cellpadding="0" cellspacing="0">
				<tr>
				   <td align="center" valign="middle">
					  <xsl:choose>
					    <xsl:when test="Caller !=''">
					      <a class="page_button" href="javascript:loadOrigPage();">
						      <span>
						        <xsl:value-of select="$strBack"/>
						      </span>
					      </a>
					    </xsl:when>
					    <xsl:otherwise>
					      <a class="page_button" href="javascript:history.back();">
						      <span>
						        <xsl:value-of select="$strBack"/>
						      </span>
					      </a>
					    </xsl:otherwise>
					  </xsl:choose>
					</td>
				</tr>
			</table>
		</div>
	 </xsl:otherwise>
  </xsl:choose>
   </center>
</body>
</html>
</xsl:template>

<xsl:template name="failure-reason">
		<xsl:choose>
			<xsl:when test="Failure/errID = '1'">
				<xsl:value-of select="$strWS_LASTERR_COULDNT_CONNECT"/>
			</xsl:when>	
			<xsl:when test="Failure/errID = '4'">
				<xsl:value-of select="$strWS_LASTERR_URL_MALFORMAT"/>
			</xsl:when>	
			<xsl:when test="Failure/errID = '6'">
				<xsl:value-of select="$strWS_LASTERR_COULDNT_RESOLVE_HOST"/>
			</xsl:when>	
			<xsl:when test="Failure/errID = '7'">
				<xsl:value-of select="$strWS_LASTERR_COULDNT_CONNECT"/>
			</xsl:when>	
			<xsl:when test="Failure/errID = '11'">
				<xsl:value-of select="$strWS_LASTERR_OUT_OF_MEMORY"/>
			</xsl:when>	
			<xsl:when test="Failure/errID = 12">
				<xsl:value-of select="$strWS_LASTERR_OPERATION_TIMEOUTED"/>
			</xsl:when>	
			<xsl:when test="Failure/errID = '16' or Failure/errID = '17' or Failure/errID = '20' or Failure/errID = '21' ">
				<xsl:value-of select="$strWS_LASTERR_SSL_CONNECT_ERROR"/>
			</xsl:when>	
			<xsl:when test="Failure/errID = '26'">
				<xsl:value-of select="$strWS_LASTERR_LOGIN_DENIED"/>
			</xsl:when>
			<xsl:when test="Failure/errID = '27'">
				<xsl:value-of select="$strWS_LASTERR_BAD_CRL_FILE"/>
			</xsl:when>
			<xsl:when test="Failure/errID = '1201'">
				<xsl:value-of select="$strWS_LASTERR_LCK_DWN_MODE"/>
			</xsl:when>
			<xsl:when test="Failure/errID = '500'">
				<xsl:value-of select="$strWS_LASTERR_COULDNT_CONNECT"/>
			</xsl:when>
			<xsl:when test="Failure/errID = '503'">
				<xsl:value-of select="$strWS_LASTERR_COULDNT_CONNECT"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strInternalError"/>
			</xsl:otherwise>
		</xsl:choose>
</xsl:template>
<xsl:template match="*"/>
</xsl:stylesheet>
