<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >
  <xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" indent="yes"/>
  <xsl:variable name="brand">
			<xsl:choose>
			<xsl:when test="/OMA/Brand='0'">dell</xsl:when>			
			<xsl:otherwise>debrand</xsl:otherwise>
			</xsl:choose>
	</xsl:variable>
  <xsl:template match="/OMA">
		<HTML>
			<head>
                          <script language="javascript">
                            if (window != top) {
                            // Load page in the top frame.
                            top.location.href = window.location.href
                            }
							<xsl:choose>
						      <xsl:when test="DWSERROR='true'">
							    var strMNVersion = "<xsl:value-of select="MNVERSION"/>";
								var strDWSVersion = "<xsl:value-of select="DWSVERSION"/>" ;
								alert(<xsl:value-of select="$strDWSError"/>);							
							</xsl:when>
						    <xsl:when test="MNERROR='true'">
							  var strMNVersion = "<xsl:value-of select="MNVERSION"/>";
							  var strMNSupportVersion = "<xsl:value-of select="SUPPORTEDVERSION"/>";	
							   alert(<xsl:value-of select="$strMNError"/>);		
							</xsl:when>
						  </xsl:choose>
                          </script>
			  <script src="/oma/js/favicon.js" type="text/javascript"></script>
			  <script language="javascript">				
				changeFavicon('/oma/images/<xsl:value-of select="$brand"/>/favicon.ico'); 
			  </script>
			<title>
			<xsl:choose>
				<!-- OEM -->
				<xsl:when test="OEM/OEMTitleCompanyName = ''">
					<xsl:choose>
						<xsl:when test="OEM/ProdName = ''">
							<xsl:value-of select="OEM/OEMTitleCoreProductName" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="OEM/ProdName" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<!-- none-OEM -->
				<xsl:otherwise>
					<xsl:value-of select="OEM/OEMTitleCompanyName" /><xsl:text> </xsl:text><xsl:value-of select="OEM/OEMTitleCoreProductName" /><xsl:text> </xsl:text><xsl:value-of select="OEM/ProdName" />
				</xsl:otherwise>
			</xsl:choose>
			</title>
			<frameset border="0" frameborder="no" framespacing="0">
			  <xsl:choose>
			    <xsl:when test="MANAGEDWS='true'">	
				    <frame src="./Login?omacmd=getlogin&amp;page=Login&amp;managedws=true"></frame>
			    </xsl:when>
			    <xsl:when test="MANAGEDWS='false'">	
				    <frame name="managedws">
						<xsl:attribute name="src">
							<xsl:choose>
							<xsl:when test="mnip">./Login?omacmd=getlogin&amp;page=Login&amp;managedws=false&amp;mnip=<xsl:value-of select="/OMA/mnip"/></xsl:when>
						<xsl:otherwise>./Login?omacmd=getlogin&amp;page=Login&amp;managedws=false</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
            </frame>
			    </xsl:when>
			    <xsl:otherwise>
				    <frame src="./Login?omacmd=getlogin&amp;page=Login"></frame>
			    </xsl:otherwise>		
			  </xsl:choose>
			</frameset>
		</head>
		</HTML>
	</xsl:template>
</xsl:stylesheet>
