<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<HTML>
			<HEAD>
				<TITLE/>
				 <link href="/oma/css/masthead.css" rel="stylesheet" type="text/css" />
				<script src="/oma/js/prototype.js" type="text/javascript"></script> 
				<script src="/oma/js/scriptaculous.js" type="text/javascript"></script>					 
				<script src="/oma/js/Clarity.js" type="text/javascript"></script>
				<script src="/oma/js/gnavbar.js" type="text/javascript"></script>
			</HEAD>
			
			<script language="javascript">
				function init() {
					<xsl:if test="VID">
					var vid ="";
						<xsl:choose>
							<xsl:when test=	"(VID = '' )">
								vid="1234";
							</xsl:when>
							<xsl:otherwise>
								vid = '<xsl:value-of select="VID"/>';
							</xsl:otherwise>
						</xsl:choose>
					document.getElementById("vid").value = vid;	
					</xsl:if>
					loadFrames(vid);
					document.getElementById("openmanage_brand_title1").src= "/oma/images/"+parent.brandName+"/omsa_title.png";
				}
				function loadFrames(vidval){
					if(parent.body)
						parent.body.location='./OMSAStart?load=body&amp;vid='+vidval;
				}				
				function updateVID(vvid)
				{
					document.getElementById("vid").value = vvid;
				}
				
				function appendVID(url)
				{
				    
				    var vvid = document.getElementById("vid").value;
					
				    if((index=url.indexOf("javascript")) == -1){

					if((index=url.indexOf('#')) != -1){
						url = url.substring(0,index);
					}
					if( (url.indexOf("&amp;vid=") == -1) &amp;&amp; (url.indexOf("?vid=") == -1)){
					
					if(url.indexOf('?') != -1){
						url += "&amp;vid=" + vvid;
					}else{
						url += "?vid=" + vvid;
					}
				      }//vid
				    }//javascript
					return url;
				
				  }				
				function getVID()
				{
					var vvid = document.getElementById("vid").value;
					return vvid;
				}
				
			</script>
			
			<BODY onload="javascript:init()">
				<input type="hidden" name="vid" id="vid" value="1234" />
				<div class="masthead_outer_right">
				<div class="masthead_right_middle">
				<img name="openmanage_brand_title1" id="openmanage_brand_title1" class="masthead_title_toppadding"/>					  
				  
				<div class="masthead_links">

<!--									<xsl:apply-templates select="OEM" /> -->
									<xsl:choose>
													<xsl:when test="/OMA/Preference != 'true' or /OMA/About = 'true' or /OMA/Help = 'true' or /OMA/RestartReminder = 'true'"></xsl:when>
													<xsl:otherwise>														
														<xsl:choose>
															<xsl:when test="/OMA/Login = 'true'"></xsl:when>
															<xsl:otherwise>
																<xsl:if test="PrevProgram">
																		<a  id="Back" name="Back"><xsl:attribute name="href">javascript:returnProgram ('<xsl:value-of select="PrevProgram"/>')</xsl:attribute>&#160;<xsl:value-of select="$strHome"/>&#160;</a>
																	<xsl:call-template name="spacer" />
																</xsl:if>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:otherwise>
												</xsl:choose>
												
												<xsl:choose>
													<xsl:when test="/OMA/Preference = 'true' or /OMA/About = 'true' or /OMA/Help = 'true' or /OMA/RestartReminder = 'true'"></xsl:when>
													<xsl:otherwise>														
														<xsl:choose>
															<xsl:when test="/OMA/Login = 'true'"></xsl:when>
															<xsl:otherwise>
															 <xsl:if test="/OMA/UserRights = '7'">
																	<a  id="Preferences" name="Preferences" href="javascript:openPreference ()">&#160;<xsl:value-of select="$strPreferences"/>&#160;</a>
																<xsl:call-template name="spacer" />
															 </xsl:if>	
															</xsl:otherwise>
														</xsl:choose>
													</xsl:otherwise>
												</xsl:choose>
												
												<xsl:choose>
													<xsl:when test="/OMA/ProductNum = '1'  or /OMA/ProductNum = '0' or  /OMA/Preference = 'true'  or /OMA/Task = 'true' or /OMA/About = 'true' or /OMA/Help = 'true' or /OMA/RestartReminder = 'true'"></xsl:when>
													<xsl:when test="/OMA/ApplicationList = 'noApp'"></xsl:when>
													<xsl:otherwise>
														<xsl:choose>
															<xsl:when test="/OMA/Login = 'true'"></xsl:when>
															<xsl:otherwise>
																	<a  id="Applications" name="Applications" href="javascript:openTaskWindow ()">&#160;<xsl:value-of select="$strApplications"/>&#160;</a>
																<xsl:call-template name="spacer" />
															</xsl:otherwise>
														</xsl:choose>
													</xsl:otherwise>
												</xsl:choose>
												
												
												<xsl:choose>
													<xsl:when test="/OMA/Help = 'true'"></xsl:when>
													<xsl:when test="/OMA/About = 'true'"></xsl:when>
													<xsl:otherwise>
														<xsl:if test="OEM/WWWSupport != ''">
															<xsl:apply-templates select="OEM//WWWSupport" />
															<xsl:call-template name="spacer" />
														</xsl:if>
													</xsl:otherwise>
												</xsl:choose>
												<!--
												<xsl:choose>
													<xsl:when test="/OMA/Help = 'true'"></xsl:when>
													<xsl:when test="/OMA/About = 'true'"></xsl:when>
													<xsl:otherwise>
															<xsl:choose>
																<xsl:when test="(/OMA/Login = 'true') and not(/OMA/Login/@webserverstop)">
																	<a  id="Help" name="Help" href="javascript:help ('./UOMSAHelp' , 'null')">&#160;<xsl:value-of select="$strHelp"/>&#160;</a>
																</xsl:when>
																<xsl:otherwise>
																<xsl:if test="not(/OMA/Login/@webserverstop)">
																		<a  id="Help" name="Help"><xsl:attribute name="href">javascript:help ('./OMSAHelp?nbflag=true' , '<xsl:value-of select="/OMA/WindowReference"/>')</xsl:attribute>&#160;<xsl:value-of select="$strHelp1"/>&#160;</a>
																	</xsl:if>
																</xsl:otherwise>
															</xsl:choose>
														<xsl:if test="not(/OMA/Login/@webserverstop)">
															<xsl:call-template name="spacer" />
														</xsl:if>
													</xsl:otherwise>
												</xsl:choose>
												-->
												<xsl:choose>
													<xsl:when test="/OMA/About = 'true'" />
													<xsl:otherwise>
															<xsl:choose>
																	<xsl:when test="(/OMA/Login = 'true') and not(/OMA/Login/@webserverstop) and not(/OMA/Login/@noscripts)">
																	<a  id="About" name="About" href="javascript:about ('./UOMSAAbout' ,  'notlogin')">
																		&#160;<xsl:value-of select="$strAbout"/>&#160;
																	</a>
																</xsl:when>
																<xsl:otherwise>
																	<xsl:if test="not(/OMA/Login/@webserverstop) and not(/OMA/Login/@noscripts)">
																	<a  id="About" name="About"><xsl:attribute name="href">javascript:about ('./OMSAAbout?nbflag=true'  ,  '<xsl:value-of 	select="/OMA/WindowReference"/>')</xsl:attribute>&#160;<xsl:value-of select="$strAbout1"/>&#160;</a>
																	</xsl:if>																
																	</xsl:otherwise>
															</xsl:choose>
														<xsl:if test="not(/OMA/Login/@noscripts)">
															<xsl:call-template name="spacer" />
														</xsl:if>
													</xsl:otherwise>
												</xsl:choose>
												<xsl:choose>
													<xsl:when test="/OMA/Help = 'true' or /OMA/About = 'true' and not(/OMA/Login/@noscripts)">
														<xsl:if test="not(/OMA/Login/@noscripts)">
															<a  id="Close" name="Close" href="javascript:closePopUpWindow ()">&#160;<xsl:value-of select="$strClose"/>&#160;</a>
														</xsl:if>	
													</xsl:when>
													
													<xsl:when test="/OMA/Login = 'true'"></xsl:when>
													<xsl:when test="/OMA/RestartReminder = 'true'"></xsl:when>
												
													<xsl:otherwise>
															<a  id="Logout" name="Logout" href="javascript:logout ()">&#160;<xsl:value-of select="$strLogOut"/>&#160;</a>
													</xsl:otherwise>
												</xsl:choose>
        </div>
        <img src="/oma/images/masthead_right.png" alt="" class="masthead_right" />
        </div>
		</div>
		</BODY>
	</HTML>
	</xsl:template>
	<xsl:template match="OEM">
			<a id="Prodname" name="Prodname">
			<xsl:choose>
				<!-- OEM -->
				<xsl:when test="OEMTitleCompanyName = ''">
					<xsl:choose>
						<xsl:when test="ProdName = ''">
							<xsl:value-of select="OEMTitleCoreProductName" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="ProdName"><xsl:with-param name="prodname"><xsl:value-of select="ProdName" /></xsl:with-param></xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<!-- none-OEM -->
				<xsl:otherwise>
					<xsl:value-of select="OEMTitleCompanyName" />&#160;<xsl:value-of select="OEMTitleCoreProductName" />&#160;<xsl:call-template name="ProdName"><xsl:with-param name="prodname"><xsl:value-of select="ProdName" /></xsl:with-param></xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
			</a>
	</xsl:template>
	
	<xsl:template name="ProdName">
		<xsl:param name="prodname"/>
		<xsl:choose>
			<xsl:when test="$prodname = 'Preferences'"><xsl:value-of select="$strPreferences1"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$prodname"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="spacer">|</xsl:template>
	<xsl:template match="WWWSupport">
			<xsl:variable name="href" select="."/>
			<xsl:variable name="supportpage">
				<xsl:choose>
					<xsl:when test="contains($href , 'http:')"><xsl:value-of select="."/></xsl:when>
					<xsl:when test="contains($href , 'https:')"><xsl:value-of select="."/></xsl:when>
					<xsl:when test="contains($href , '/SecureSupportPageServlet')"><xsl:value-of select="."/>?nbflag=true</xsl:when>
					<xsl:otherwise>http://<xsl:value-of select="."/></xsl:otherwise>
				</xsl:choose>
			</xsl:variable>	
			<a  id="Support" name="Support">
					<xsl:attribute name="href">javascript:support ('<xsl:value-of select="$supportpage"/>' , '<xsl:value-of select="/OMA/WindowReference"/>')</xsl:attribute>&#160;	<xsl:value-of select="$strSupport"/>&#160;
			</a>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
