<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:template match="/OMA">
<xsl:variable name="ShowSNMPConfig">
		<xsl:choose>
			<xsl:when test="/OMA/MgmtSftwPropsObj/snmpCapabilities/SNMP='true' or  /OMA/MgmtSftwPropsObj/snmpCapabilities/SNMPSet='true' ">true</xsl:when>
			<xsl:otherwise>false</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<ComponentTree>	
	<xsl:if test="/OMA/SHOWINSTRUMENTATION='TRUE'"> <!-- show server administrator tree only when instrumentation is present -->           	
		<Component	name="omsa" help="">
			<xsl:attribute name="display"><xsl:value-of select="$strServerAdministrator"/></xsl:attribute>
			<SNBMenuItem name="Preference">
					<xsl:attribute name="display"><xsl:value-of select="$strPreferences"/></xsl:attribute>
					<LSNBMenuItem name="access" href="./DataArea?plugin=com.dell.oma.webplugins.AccessconfgWebPlugin" help="access">
						<xsl:attribute name="display"><xsl:value-of select="$strNodeConfiguration"/></xsl:attribute>
					</LSNBMenuItem>
					<!--xsl:if test="$ShowSNMPConfig='true'">
					<LSNBMenuItem name="snmp" href="./DataArea?plugin=com.dell.hip.webplugins.SNMPconfgWebPlugin" app="hip" help="snmp">
						<xsl:attribute name="display"><xsl:value-of select="$strSNMPConfiguration"/></xsl:attribute>
					</LSNBMenuItem>
					</xsl:if--> <!-- Commented out this feature as it was decided to remove. Confirmation from IPS Matt.-->
				</SNBMenuItem>
		</Component>	
	</xsl:if> <!-- show server administrator tree only when instrumentation is present -->		
	</ComponentTree>
	
</xsl:template>

<xsl:template match="*"/>
</xsl:stylesheet>
