<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >

  <xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" indent="yes"/>
  <xsl:variable name="brand">
			<xsl:choose>
			<xsl:when test="/OMA/Brand='0'">dell</xsl:when>			
			<xsl:otherwise>debrand</xsl:otherwise>
			</xsl:choose>
	</xsl:variable>
  <xsl:template match="/OMA">
    <html>
      <head>
        <xsl:choose>
		  <xsl:when test="$brand = 'dell'">
			<title>OpenManage<xsl:text disable-output-escaping="yes">&amp;trade;</xsl:text> Server Administrator</title>
		  </xsl:when>		  
		  <xsl:otherwise>
			<title>Server Administrator</title>
		  </xsl:otherwise>
	</xsl:choose>
        <link href="/oma/css/loginmaster.css" rel="stylesheet" type="text/css" />
        <style type="text/css"></style>
        <script language="javascript" src="/oma/js/prototype.js" type="text/javascript"></script>
        <script language="javascript" src="/oma/js/gnavbar.js" type="text/javascript"></script>
        <script language="javascript" src="/oma/js/Clarity.js" type="text/javascript"></script>
	<script src="/oma/js/favicon.js" type="text/javascript"></script>
	<script language="javascript">	
		changeFavicon('/oma/images/<xsl:value-of select="$brand"/>/favicon.ico'); 
	</script>
      </head>

      <script language="javascript">
        function init() {
        var div_CloseBrowser = document.getElementById("clbr");
        <xsl:if test="RestartWebServer/@login='true'">
          document.getElementById("login").noWrap = true;
        </xsl:if>
        document.getElementById("clbr").noWrap = true;
        window.opener=top;
        //window.opener is still null we cannot close the window so lets hide "Close Browser" button
        if ( window.opener == null )
        {
        div_CloseBrowser.style.display = "none";
        }
        }
      </script>
      
      <body onload="javascript:init();">
        <div class="login">
          <div class="login_header_brand">	
	  <xsl:attribute name="style">background-image:url('/oma/images/<xsl:value-of select="$brand"/>/login_table_header.png')</xsl:attribute>
	  <xsl:choose>
		  <xsl:when test="$brand = 'dell'">
		   <img alt="OpenManage" title="OpenManage" >
		   <xsl:attribute name="src">/oma/images/<xsl:value-of select="$brand"/>/om_title.png</xsl:attribute>	
		   </img>
		  </xsl:when>
		  <xsl:otherwise>
		   <img>
		   <xsl:attribute name="src">/oma/images/<xsl:value-of select="$brand"/>/om_title.png</xsl:attribute>	
		   </img>
		  </xsl:otherwise>
	     </xsl:choose>  
          </div>
          <div class="login_left">
            <div class="login_right">
              <div class="logout_content">
                <div class="hr">
                </div>
                <div class="logout">
                  <xsl:if test="not(StopWebServer)">
                    <div class="logout_title" >
                      <!-- WARNING: Three-part order-dependent message goes here. -->
                      <!-- Japanese wants the product name first; all other languages want it last. -->
                      <xsl:value-of select="$strThankYouFor_Part1"/>
                      <!-- Part2 of the three-part message is not used. -->
                      <xsl:call-template name="ProdName">
                        <xsl:with-param name="prodname">
                          <xsl:value-of select="ProdName"/>
                        </xsl:with-param>
                      </xsl:call-template>
                      <xsl:value-of select="$strThankYouFor_Part3"/>
                    </div>
                  </xsl:if>
                  <div>
                    <xsl:attribute name="id">
                      <xsl:choose>
                        <xsl:when test="StopWebServer='true'">logout_text</xsl:when>
                        <xsl:otherwise>logout_message</xsl:otherwise>
                      </xsl:choose>
                    </xsl:attribute>
                    <xsl:choose>
                      <xsl:when test="RestartWebServer='true' and RestartWebServer/@login = 'true'">
                        <xsl:value-of select="$strTheWebServer"/>
                      </xsl:when>

                      <xsl:when test="RestartWebServer='true' and RestartWebServer/@login != 'true'">
                        <xsl:value-of select="$strRestartWebServer"/>
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="$strRelaunchBrowserBefore"/>
                      </xsl:when>

                      <xsl:when test="StopWebServer='true'">
                        <xsl:value-of select="$strStopWebServer"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <!-- WARNING: Three-part order-dependent message goes here. -->
                        <!-- Japanese wants the product name first; all other languages want it last. -->
                        <xsl:value-of select="$strYouHaveSuccessfully_Part1"/>
                        <!-- Part2 of the three-part message is not used. -->
                        <xsl:call-template name="ProdName">
                          <xsl:with-param name="prodname">
                            <xsl:value-of select="ProdName"/>
                          </xsl:with-param>
                        </xsl:call-template>
						 <xsl:value-of select="$strYouHaveSuccessfully_Part3"/>
                        <xsl:value-of select="$strPeriod"/>
                        <xsl:text> </xsl:text>
                        <xsl:value-of select="$strYouHaveSuccessfully_Security"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </div>

                </div>
                <div class="hr">
                </div>
                <div>
                  <div class="button_clear" id="login_buttons">
                    <a class="blackpage_button_emphasized" id="clbr" href="javascript:window.open('', '_self', '');window.close();">
                      <span>
                        <xsl:value-of select="$strClose160Browser"/>
                      </span>
                    </a>
                    <xsl:if test="RestartWebServer/@login='true'">
                      <a id="login" class="blackpage_button">
                        <xsl:choose>
                          <xsl:when test="MANAGEDWS">
                            <xsl:attribute name="href"><xsl:value-of select="Scheme"/>://<xsl:value-of select="RestartWebServer/@ipaddress"/>:<xsl:value-of select="RestartWebServer/@port"/><xsl:value-of select="RestartWebServer/@appcontext"/>/OMSALogin?msgStatus=null&amp;manageDWS=<xsl:value-of select="MANAGEDWS" /></xsl:attribute>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:attribute name="href"><xsl:value-of select="Scheme"/>://<xsl:value-of select="RestartWebServer/@ipaddress"/>:<xsl:value-of select="RestartWebServer/@port"/><xsl:value-of select="RestartWebServer/@appcontext"/>/OMSALogin?msgStatus=null</xsl:attribute>
                          </xsl:otherwise>
                        </xsl:choose>
                        <span>
                          <xsl:value-of select="$strLog160in"/>
                        </span>
                      </a>
                    </xsl:if>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="login_footer">
          </div>
          <div class="title_links">
             <xsl:choose>
		  <xsl:when test="$brand = 'debrand'">
			<a href="#" onclick="javascript:popUp.openWindow('./SupportPageServlet','support');">
			<xsl:value-of select="$strSupport"/>
			</a>
		  </xsl:when>
		  <xsl:when test="$brand = 'dell'">
			<a href="#" onclick="javascript:popUp.openWindow('http://support.dell.com/','support');">
			<xsl:value-of select="$strSupport"/>
			</a>
		  </xsl:when>
		  <xsl:otherwise>
			<a href="#" onclick="javascript:popUp.openWindow('http://support.dell.com/','support');">
			<xsl:value-of select="$strSupport"/>
			</a>
		  </xsl:otherwise>
	  </xsl:choose> 
            <xsl:if test="not(StopWebServer)">
              |<a href="#" id="About" name="About" onclick="javascript:popUp.openWindow('/UOMSAAbout',  'notlogin');">
                <xsl:value-of select="$strAbout"/>
              </a>
            </xsl:if>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>
        <xsl:template name="ProdName">
          <xsl:param name="prodname"/>
          <xsl:choose>
            <xsl:when test="$prodname = 'Preferences'">
              <xsl:value-of select="$strPreferences"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$prodname"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:template>

  <xsl:template match="*"/>
</xsl:stylesheet>
