<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

<xsl:template match="/MenuList">
	<html>
	<head>
	<title></title>
	<link rel="stylesheet" type="text/css" href="/oma/docs/oma.css" />
	<xsl:if test="@skin != ''">
		<link rel="stylesheet" type="text/css">
			<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if>scheme.css</xsl:attribute>
		</link>
		<xsl:if test="@language != ''">
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/scheme.css</xsl:attribute>
			</link>
			<xsl:if test="@country != ''">
				<link rel="stylesheet" type="text/css">
					<xsl:attribute name="href">/oma/skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if><xsl:value-of select="@language"/>/<xsl:value-of select="@country"/>/scheme.css</xsl:attribute>
				</link>
			</xsl:if>
		</xsl:if>
	</xsl:if>
	<script language="javascript">
	var g_nLastItem = 1;
	var g_nMenuItem = 0;
	var g_vMenuItemName = new Array();
	var g_sDefaultItem = '<xsl:value-of select="@lsnb" />';
	var g_nDefaultItem= 1;
	var g_sDefaultTarget = "";
	var g_sDefaultHelp = "";
	var g_sDefaultApp = "";

	function init () {
		if (g_sDefaultTarget == "")
			g_sDefaultTarget = "/oma/loading.html";
		if (g_nMenuItem > 0)
			select  (g_nDefaultItem, g_sDefaultTarget, g_sDefaultHelp, g_sDefaultApp);
		// For each item on the list, if required, increase the size of the table element until it is displayed in a single row.
		for (i = 0; i &lt; g_nMenuItem; i++) {
			var anchor = document.getElementById("link_" + (i + 1));
			var td = document.getElementById("data_" + (i + 1));
			var nFirstWidth = anchor.offsetHeight;
			while (anchor.offsetHeight > 16) {
				td.width++;
				// Verify that the resize of the TD element is actually working.  If it isn't supported by the browser, exit the loop.
				if  (nFirstWidth == anchor.offsetHeight) break;
			}
		}
	}
	function select (nItem, sTarget, sHelp, sApp) {
		if (_performSelect (nItem) == true) {
			var sTemp = sTarget;
			if (sTemp.indexOf ("?") != -1)
				sTemp += "&amp;";
			else
				sTemp += "?";
			sTemp = sTemp + "help=" + sHelp + "&amp;app=" + sApp + "&amp;ct=" + parent.ct.g_sLastLink + "&amp;snb=" + parent.snb.g_vMenuItemName[parent.snb.g_nLastMenuItem - 1] + "&amp;lsnb=" + g_vMenuItemName[nItem - 1];
			parent.da.location.href = sTemp;
		}
	}
	function _select (sSelectItem) {
		for (i = 0; i &lt;  g_vMenuItemName.length; i++) {
			if (g_vMenuItemName[i] == sSelectItem) {
				_performSelect (i + 1);
			}
		}
	}
	function _performSelect (nItem) {
		if (parent.ct.g_bModal == false) {
			document.getElementById ("link_" + g_nLastItem).className = "lsnb-item";
			document.getElementById ("link_" + nItem).className = "lsnb-item lsnb-selection";
			g_nLastItem= nItem;
			return true;
		}
		return false;
	}
	</script>
	</head>
	<body class="lsnb" onLoad="javascript:init()">
		<table height="30" cellpadding="0" cellspacing="0" border="0">
		<tr>
			<td width="18" valign="top">
				<img border="0" width="18" height="30">
					<xsl:attribute name="src">/oma/<xsl:if test="@skin != ''">skins/<xsl:value-of select="@skin"/>/<xsl:if test="@scheme != ''">schemes/<xsl:value-of select="@scheme"/>/</xsl:if></xsl:if>images/snbcurve.gif</xsl:attribute>
				</img>
			</td>
			<xsl:apply-templates />
		</tr>
		</table>
	</body>
	</html>
</xsl:template>

<xsl:template match="*">
	<script language="javascript">
	g_vMenuItemName[g_nMenuItem++] = '<xsl:value-of select="name()" />';
	if (g_sDefaultTarget == "") {
		g_sDefaultTarget = '<xsl:value-of select="@href"/>';
		g_sDefaultHelp = '<xsl:value-of select="@help"/>';
		g_sDefaultApp = '<xsl:value-of select="@app"/>';
	}
	if ('<xsl:value-of select="@default"/>' == 'true' || '<xsl:value-of select="name()"/>' == g_sDefaultItem) {
		g_nDefaultItem = g_nMenuItem;
		g_sDefaultTarget = '<xsl:value-of select="@href"/>';
		g_sDefaultHelp = '<xsl:value-of select="@help"/>';
		g_sDefaultApp = '<xsl:value-of select="@app"/>';
	}
	</script>
	<td align="center" valign="middle">
		<table cellpadding="0" cellspacing="0" border="0">
		<tr>
			<td width="13" height="18" align="right">
				<script language="javascript">
					document.write ('&lt;img id="img1_' + g_nMenuItem + '" src="/oma/images/blank.gif" width="10" height="18" border="0">');
				</script >
			</td>
			<script language="javascript">
				document.write ('&lt;td id="data_' + g_nMenuItem+ '" width="80" height="18" align="center" valign="middle">');
			</script>
				<script language="javascript">
					document.write ('&lt;a id="link_' + g_nMenuItem+ '" name="link_' + g_nMenuItem+ '" href="#" onclick="javascript:select(' + g_nMenuItem + ', \'<xsl:value-of select="@href" />\', \'<xsl:value-of select="@help" />\', \'<xsl:value-of select="@app" />\')" alt="xxx" class="lsnb-item">');
				</script >
				<xsl:choose>
					<xsl:when test="@display">
						<xsl:choose>
							<xsl:when test="@display='#'"></xsl:when>
							<xsl:otherwise><xsl:value-of select="@display" /></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="name()" /></xsl:otherwise>
				</xsl:choose>
				<script language="javascript">document.write ('&lt;/a>');</script >
			<script language="javascript">document.write ('&lt;/td>');</script >
			<td width="13" height="18" align="left">
				<script language="javascript">document.write ('&lt;img id="img2_' + g_nMenuItem + '" src="/oma/images/blank.gif" width="10" height="18" border="0">');</script>
			</td>
		</tr>
		</table>
	</td>
<!--
	<td align="center" valign="middle">
		<script language="javascript">
			document.write ('&lt;a id="link_' + g_nMenuItem+ '" name="link_' + g_nMenuItem+ '" href="javascript:select (' + g_nMenuItem + ', \'<xsl:value-of select="@href" />\')" class="lsnb-item">');
		</script >
		<xsl:choose>
			<xsl:when test="@display"><xsl:value-of select="@display" /></xsl:when>
			<xsl:when test="@name"><xsl:value-of select="@name" /></xsl:when>
			<xsl:otherwise><xsl:value-of select="name()" /></xsl:otherwise>
		</xsl:choose>
		<script language="javascript">document.write ('&lt;/a>');</script >
	</td>
-->
</xsl:template>

</xsl:stylesheet>
