<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="OEM">
		<HTML>
			<HEAD>
				<TITLE></TITLE>
				<link href="/oma/docs/oma.css" type="text/css" rel="stylesheet"/>
				<script language="javascript" src="/oma/js/gnavbar.js" />
			</HEAD>			
			<BODY class="gnavbar">
			<table cellpadding="0" cellspacing="0" width="100%" height="59" border="0">
				<tr>
					<td width="10"><img src="/oma/images/blank.gif" alt="" width="1" height="1" /></td>
					<td align="left" height="59" valign="middle">
						<a href="#">
						<img src="" width="350" height="42" border="0">
								<xsl:attribute name="src">/oem/<xsl:value-of select="Name"/>/images/productname.gif</xsl:attribute>
							</img>
						</a>
					</td>
					<td align="right" height="59" valign="middle">
						<table cellspacing="0" cellpadding="0" border="0">
							<tr>
								<xsl:choose>
									<xsl:when test="/OMA/Preference = 'true' or /OMA/About = 'true' or /OMA/Help = 'true'"></xsl:when>
									<xsl:otherwise>									
										<xsl:choose>
											<xsl:when test="/OMA/Login = 'true'"></xsl:when>
											<xsl:otherwise>												
												<td width="80" align="right" valign="middle">
													<a href="#" id="Preferences" name="Preferences" onclick="javascript:openPreference ()" class="global-nav-bar-item">&#160;<xsl:value-of select="$strPreferences"/>&#160;</a>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								
								<xsl:choose>
									<xsl:when test="/OMA/Task = 'true' or /OMA/About = 'true' or /OMA/Help = 'true'"></xsl:when>
									<xsl:when test="/OMA/ApplicationList = 'noApp'"></xsl:when>
									<xsl:otherwise>									
										<xsl:choose>
											<xsl:when test="/OMA/Login = 'true'"></xsl:when>
											<xsl:otherwise>
												<td width="80" align="center" valign="middle">
													<a href="#" id="Application" name="Application" onclick="javascript:openTaskWindow ()" class="global-nav-bar-item">&#160;<xsl:value-of select="$strApplications"/>&#160;</a>
												</td>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
								
							<xsl:choose>
								<xsl:when test="/OMA/About = 'true' or /OMA/Help = 'true'" />
								<xsl:otherwise>
									<xsl:if test="WWWSupport != ''">
										<td width="80" align="center" valign="middle">
											<a  class="global-nav-bar-item" id="Support" name="Support" target="supportpage">
												<xsl:attribute name="href">javascript:visit ('<xsl:value-of select="WWWSupport" />')</xsl:attribute>	
												<xsl:value-of select="$strSupport"/>
											</a>
										</td>
									</xsl:if>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="/OMA/Help = 'true'"></xsl:when>
								<xsl:when test="/OMA/About = 'true'"></xsl:when>
								<xsl:otherwise>
									<td width="80" align="center" valign="middle">
										<xsl:choose>
											<xsl:when test="/OMA/Login = 'true'">
												<a href="#" id="Help" name="Help" onclick="javascript:help ('./UOMSAHelp')" class="global-nav-bar-item"><xsl:value-of select="$strHelp"/></a>
											</xsl:when>
											<xsl:otherwise>
												<a href="#" id="Help" name="Help" onclick="javascript:help ('./OMSAHelp?nbflag=true')" class="global-nav-bar-item"><xsl:value-of select="$strHelp1"/></a>
											</xsl:otherwise>
										</xsl:choose>
									</td>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="/OMA/About = 'true'" />
								<xsl:when test="/OMA/Login = 'true'">
									<td width="80" align="center" valign="middle">
										<a href="#" id="About" name="About" onclick="javascript:about ('./UOMSAAbout')" class="global-nav-bar-item"><xsl:value-of select="$strAbout"/></a>
									</td>
								</xsl:when>
								<xsl:otherwise>
									<td width="80" align="center" valign="middle">
										<a href="#" id="About" name="About" onclick="javascript:about ('./OMSAAbout?nbflag=true')" class="global-nav-bar-item"><xsl:value-of select="$strAbout1"/></a>
									</td>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="/OMA/Help = 'true' or /OMA/About = 'true'">
									<td width="80" align="center" valign="middle">
										<a href="#" id="Close" name="Close" onclick="javascript:closePopUpWindow ()" class="global-nav-bar-item"><xsl:value-of select="$strClose"/></a>
									</td>
								</xsl:when>
								<xsl:when test="/OMA/Login = 'true'"></xsl:when>
								<xsl:otherwise>
									<td width="80" align="center" valign="middle">
										<a href="#" id="Logout" name="Logout" onclick="javascript:logout ()" class="global-nav-bar-item"><xsl:value-of select="$strLogOut"/></a>
									</td>
								</xsl:otherwise>
							</xsl:choose>
						</tr>
						</table>
					</td>
					<td style="width135px" align="center" valign="middle">
						<a target="top" href="#" id="Home" name="Home">
							<xsl:attribute name="onclick">javascript:visit('<xsl:value-of select="WWWHome"/>')</xsl:attribute>
							<img style="width: 135px; height: 57px" border="0">
								<xsl:attribute name="src">/oem/<xsl:value-of select="Name"/>/images/logo.gif</xsl:attribute>
							</img>
						</a>
					</td>
					<td width="10"><img src="/oma/images/blank.gif" alt="" width="1" height="1" /></td>
				</tr>
				</table>
				<table cellpadding="0" cellspacing="0" width="100%" height="5" border="0">
				<tr>
				    <td id="separator" height="5" class="global-nav-bar-separator"><img src="/oma/images/blank.gif" height="1" width="1" border="0"/></td>
				</tr>
				</table>
			</BODY>
		</HTML>
	</xsl:template>
	<xsl:template match="*"/>
</xsl:stylesheet>
