<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="xml" omit-xml-declaration="yes"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA/About">
		<Summary>
	<Section name="Software">
		<xsl:attribute name="display"><xsl:value-of select="$strSoftwareProfile"/></xsl:attribute>
		<ListData name="SysMgmtSoftwareCtr">
			<xsl:attribute name="display"><xsl:value-of select="$strSystemManagement"/></xsl:attribute>
			<Data name="ProductName">
				<xsl:attribute name="display"><xsl:value-of select="$strName"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ProductName"><xsl:attribute name="value"><xsl:value-of select="ProductName"/></xsl:attribute></xsl:when>
					<xsl:otherwise><xsl:attribute name="value"><xsl:value-of select="$strInformationNotAvailable"/></xsl:attribute></xsl:otherwise>
				</xsl:choose>
			</Data>
			<Data name="ProductVersion">
				<xsl:attribute name="display"><xsl:value-of select="$strVersion"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="ProductVersion"><xsl:attribute name="value"><xsl:value-of select="ProductVersion"/></xsl:attribute></xsl:when>
					<xsl:otherwise><xsl:attribute name="value"><xsl:value-of select="$strInformationNotAvailable1"/></xsl:attribute></xsl:otherwise>
				</xsl:choose>
			</Data>
			<Data name="ProductDescription">
				<xsl:attribute name="display"><xsl:value-of select="$strDescription"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strSystemsManagementSoftware"/></xsl:attribute>
			</Data>
			<xsl:for-each select="Component">
				<xsl:sort select="Name"/>
				<xsl:if test="count(preceding-sibling::*) > 0">
					<xsl:choose>
						<xsl:when test="ID = 'OLD' or ID = 'old' or ID = 'odf' or ID = 'OLDCOMMON'">
							<!--IGNORE, OLD is removed from OMSA, so hide OLD components details.  -->
						</xsl:when>
						<xsl:when test="Name">
							<Data>
								<xsl:attribute name="name">Contains_<xsl:value-of select="count(preceding-sibling::*)" /></xsl:attribute>
								<xsl:choose>
									<xsl:when test="position() = '1'">
										<xsl:attribute name="display"><xsl:value-of select="$strContains"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="display"></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:attribute name="value">
									<xsl:choose>
										<xsl:when test="ID = 'osia'">
											<xsl:value-of select="../OEMTitleCompanyName" /><xsl:text> </xsl:text><xsl:value-of select="../OEMTitleCoreProductName" /><xsl:text> </xsl:text><xsl:value-of select="Name"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="Name" />
										</xsl:otherwise>
									</xsl:choose>
									<xsl:text> </xsl:text><xsl:value-of select="Version" />
								</xsl:attribute>
							</Data>
						</xsl:when>
						<xsl:when test="ID = 'osia'">
							<Data>
								<xsl:attribute name="name">Contains_<xsl:value-of select="count(preceding-sibling::*)" /></xsl:attribute>
								<xsl:choose>
									<xsl:when test="position() = '1'">
										<xsl:attribute name="display"><xsl:value-of select="$strContains"/></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="display"></xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:attribute name="value">
								<xsl:choose>
									<xsl:when test="(../OEMTitleCompanyName)!=''">
										<xsl:value-of select="../OEMTitleCompanyName" /><xsl:text> </xsl:text><xsl:value-of select="../OEMTitleCoreProductName" />
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="../OEMTitleCoreProductName" />
									</xsl:otherwise>
								</xsl:choose>
								<xsl:text> </xsl:text><xsl:value-of select="../OEMTitleVersion" />
								</xsl:attribute>
							</Data>
						</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:for-each>
		</ListData>
	</Section>
		
		</Summary>
	</xsl:template>

	<xsl:template match="/OMA/SMStatus">
	</xsl:template>

</xsl:stylesheet>
