<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/OMA">
		<DataArea>
			<PageTitle>PageTitle</PageTitle>
			<Header>Header</Header>
			<SubHeader/>
			<ListData>
				<Data name="EchoString"><xsl:attribute name="display"><xsl:value-of select="$strEchoString"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="EchoString"/></xsl:attribute>
				</Data>
				<Data name="CompanyName"><xsl:attribute name="display"><xsl:value-of select="$strCompanyName"/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="About/CompanyName">
							<xsl:attribute name="value"><xsl:value-of select="About/CompanyName"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise><xsl:attribute name="value"><xsl:value-of select="$strInformationNotAvailable"/></xsl:attribute></xsl:otherwise>
					</xsl:choose>
				</Data>
				<Data name="LegalCopyright"><xsl:attribute name="display"><xsl:value-of select="$strLegalCopyright"/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="About/LegalCopyright">
							<xsl:attribute name="value"><xsl:value-of select="About/LegalCopyright"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise><xsl:attribute name="value"><xsl:value-of select="$strInformationNotAvailable1"/></xsl:attribute></xsl:otherwise>
					</xsl:choose>
				</Data>
				<Data name="ProductName"><xsl:attribute name="display"><xsl:value-of select="$strProductName"/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="About/ProductName">
							<xsl:attribute name="value"><xsl:value-of select="About/ProductName"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise><xsl:attribute name="value"><xsl:value-of select="$strInformationNotAvailable2"/></xsl:attribute></xsl:otherwise>
					</xsl:choose>
				</Data>
				<Data name="ProductVersion"><xsl:attribute name="display"><xsl:value-of select="$strProductVersion"/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="About/ProductVersion">
							<xsl:attribute name="value"><xsl:value-of select="About/ProductVersion"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise><xsl:attribute name="value"><xsl:value-of select="$strInformationNotAvailable3"/></xsl:attribute></xsl:otherwise>
					</xsl:choose>
				</Data>
				<Data name="ProductLanguage"><xsl:attribute name="display"><xsl:value-of select="$strProductLanguage"/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="ProductLanguage">
							<xsl:attribute name="value"><xsl:value-of select="ProductLanguage"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise><xsl:attribute name="value"><xsl:value-of select="$strInformationNotAvailable4"/></xsl:attribute></xsl:otherwise>
					</xsl:choose>
				</Data>
				<xsl:apply-templates select="ProductLaunchPointList"/>
			</ListData>
		</DataArea>
	</xsl:template>

	<xsl:template match="ProductLaunchPointList">
		<xsl:for-each select="ProductLaunchPoint">
			<Data name="LaunchPoint">
				<xsl:attribute name="display"><xsl:value-of select="$strProductLaunchPoint"/><xsl:value-of select="@index"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
			</Data>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="*"/>

</xsl:stylesheet>
