<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <xsl:template match="/OMA">
    <Reminder>
      <xsl:attribute name="submitdisplay">
        <xsl:choose>
          <xsl:when test="Reminder/@mode='svr'">
            <xsl:value-of select="$strRebootSystem"/>
          </xsl:when>
          <xsl:when test="Reminder/@mode='svc'">
            <xsl:value-of select="$strRestartWebserver"/>
          </xsl:when>
        </xsl:choose>
      </xsl:attribute>
      <xsl:attribute name="submit">
        <xsl:choose>
          <xsl:when test="Reminder/@mode='svr'">./SubmitForm?plugin=com.dell.hip.webplugins.shtdwnWebPlugin&amp;os=8&amp;action1=1</xsl:when>
          <xsl:when test="Reminder/@mode='svc'">./SubmitForm?plugin=com.dell.oma.webplugins.RstServiceWebPlugin</xsl:when>
        </xsl:choose>
      </xsl:attribute>
      <xsl:if test="Reminder/@mode='svr' or Reminder/@mode='svc'">
            <xsl:attribute name="LogOutDisplay">
              <xsl:value-of select="$strLogOut"/>
            </xsl:attribute>
            <xsl:attribute name="LogOuthref">
              <xsl:choose>
                <xsl:when test="Reminder/@mode='svr'">./LogoutServlet?page=Logout&amp;out=true&amp;rstmode=server&amp;CurrentProgram=<xsl:value-of select="Reminder/@currentprog"/></xsl:when>
                <xsl:when test="Reminder/@mode='svc'">./LogoutServlet?page=Logout&amp;out=true&amp;rstmode=service&amp;CurrentProgram=<xsl:value-of select="Reminder/@currentprog"/></xsl:when>
              </xsl:choose>
            </xsl:attribute>
      </xsl:if>
      <PageTitle>
        <xsl:attribute name="display">
          <xsl:value-of select="$strReminderForRestart"/>
        </xsl:attribute>
      </PageTitle>
      <PromptText>
        <xsl:choose>
          <xsl:when test="Reminder/@mode='svr'">
            <xsl:value-of select="$strTheServerNeeds"/>
          </xsl:when>
          <xsl:when test="Reminder/@mode='svc'">
            <xsl:value-of select="$strTheServicedaemonNeeds"/>
          </xsl:when>
        </xsl:choose>
      </PromptText>
      <HiddenTable>
        <Data name="DatypeTag" type="hidden">
          <xsl:choose>
            <xsl:when test="ShutDownDA = 'dceda' ">
              <xsl:attribute name="returnvalue">dceda</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="returnvalue">hipda</xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
        </Data>
      </HiddenTable>
       <Brand>
       	<xsl:choose>
		<xsl:when test="/OMA/Brand='0'">dell</xsl:when>			
		<xsl:otherwise>debrand</xsl:otherwise>
	</xsl:choose>	
      </Brand>
    </Reminder>
  </xsl:template>
  <xsl:template match="*"/>
</xsl:stylesheet>
