<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:output method="xml" />
<xsl:strip-space elements="*"/>
<xsl:template match="/OMA">
	<xsl:choose>
		<xsl:when test="Messages">
			<DataArea email="false" printable="false">		
				<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.oma.webplugins.SetMsgWebPlugin</xsl:attribute>
				<xsl:attribute name="submitdisplay"><xsl:value-of select="$strNext"/></xsl:attribute>
				<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strWarningMessage"/></xsl:attribute>
				</PageTitle>
				<xsl:for-each select="Messages/Message">
					<xsl:call-template name="message">
						<xsl:with-param name="msg"><xsl:value-of select="."/></xsl:with-param>
						<xsl:with-param name="name"><xsl:value-of select="@name"/></xsl:with-param>
					</xsl:call-template>
				</xsl:for-each>
			</DataArea>
		</xsl:when>
		<xsl:otherwise>
			<DataArea>
				<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strHealth"/></xsl:attribute>
				</PageTitle>
				<CustomButton>
					<Data name="Refresh">
						<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					</Data>
				</CustomButton>
				<HealthData>
				<PromptText><xsl:value-of select="$strClickTheComponent"/></PromptText>				
					<xsl:choose>
						<xsl:when test="SortHealthComp='true'">
							<xsl:for-each select="Health/*">
								<xsl:sort select="@display" order="ascending"/>
								<xsl:call-template  name="Component"/>
							</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>
							<xsl:for-each select="Health/*">
								<xsl:sort select="@display" order="ascending"/>
								<xsl:call-template  name="Component"/>
							</xsl:for-each>
						</xsl:otherwise>
					</xsl:choose>
				</HealthData>
			</DataArea>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="Component">
	<xsl:if test="(@status != '0')">
	<Data>
		<xsl:attribute name="name"><xsl:value-of select="@name" /></xsl:attribute>
		<xsl:attribute name="display"><xsl:value-of select="@display" /></xsl:attribute>
		<xsl:attribute name="status"><xsl:value-of select="@status" /></xsl:attribute>
		<xsl:choose>
			<xsl:when test="@cl">
				<xsl:attribute name="href">#</xsl:attribute>
				<xsl:attribute name="onclick">javascript:parent.ct.select('<xsl:value-of select="@cl" />', '<xsl:value-of select="@snb" />', '<xsl:value-of select="@lsnb" />');</xsl:attribute>
			</xsl:when>
			<xsl:when test="@href"><xsl:attribute name="href"><xsl:value-of select="@href" /></xsl:attribute></xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="href">#</xsl:attribute>
				<xsl:attribute name="onclick">javascript:parent.ct.select('<xsl:value-of select="@name" />', '', '');</xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</Data>
	</xsl:if>
</xsl:template>

<xsl:template name="message">
	<xsl:param name="msg"/>
	<xsl:param name="name"/>
	<ListData>
		<Data>
			<xsl:attribute name="name"><xsl:value-of select="$msg"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$msg"/></xsl:attribute>
		</Data>
	</ListData>
	<ListData>
		<Data>
			<xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strDoNotDisplay"/></xsl:attribute>
			<xsl:attribute name="type">checkbox</xsl:attribute>
			<xsl:attribute name="returnvalue">false</xsl:attribute>
		</Data>
	</ListData>
</xsl:template>
<xsl:template match="*">
</xsl:template>

</xsl:stylesheet>
