<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="no"/>
	<xsl:strip-space elements="*"/>
	
	<xsl:template name="NewLine">
		<xsl:text>
</xsl:text>
	</xsl:template>
	
	<xsl:template name="CLISubCommand">
		<xsl:param name="command"/>
			<xsl:value-of select="$command"/>
			<xsl:call-template name="Spaces">
				<xsl:with-param name="num"><xsl:value-of select="(17) - string-length($command)"/></xsl:with-param>
			</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="Spaces">
		<xsl:param name="num"/>
		<xsl:choose>
			<xsl:when test="$num = '16'">
				<xsl:text>                </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '15'">
				<xsl:text>               </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '14'">
				<xsl:text>              </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '13'">
				<xsl:text>             </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '12'">
				<xsl:text>            </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '11'">
				<xsl:text>           </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '10'">
				<xsl:text>          </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '9'">
				<xsl:text>         </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '8'">
				<xsl:text>        </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '7'">
				<xsl:text>       </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '6'">
				<xsl:text>      </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '5'">
				<xsl:text>     </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '4'">
				<xsl:text>    </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '3'">
				<xsl:text>   </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '2'">
				<xsl:text>  </xsl:text>
			</xsl:when>
			<xsl:when test="$num = '1'">
				<xsl:text> </xsl:text>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="ComCLIMsgID">
		<xsl:param name="id"/>
		<xsl:param name="shownvpairs"/>
		<xsl:param name="nametxt"/>
		<xsl:param name="paramtxt"/>
		<xsl:param name="parsetxt"/>
		<xsl:param name="parsetxt2"/>
		<xsl:choose>
			
			
			
			<xsl:when test="$id = '1000'">
				<!--XLATETHIS-->Command Successful.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1001'">
				<!--XLATETHIS-->Error! Signed number expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1002'">
				<!--XLATETHIS-->Error! unsigned number expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1003'">
				<!--XLATETHIS-->Error! true or false expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1004'">
				<!--XLATETHIS-->Error! alphanumeric or symbol expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1005'">
				<!--XLATETHIS-->Error! Required parameter missing: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1006'">
				<!--XLATETHIS-->Error! At least one optional parameter must be specified.<!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1007'">
				<!--XLATETHIS-->Error! Command incomplete <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1008'">
				<!--XLATETHIS-->Error! Hardware not found: <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1009'">
				<!--XLATETHIS-->Error! cannot load data accessor: <!--XLATETHIS-->
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1010'">
				<!--XLATETHIS-->Error! Index too large. Maximum index for this command is: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1011'">
				<!--XLATETHIS-->Error! Hardware subsystem reports command failed.  <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1012'">
				<!--XLATETHIS-->Error! Unrecognized parameter value: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1013'">
				<!--XLATETHIS-->Error! Text too long. Maximum number of characters is: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1014'">
				<!--XLATETHIS-->Error! Value incorrect for parameter: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1015'">
				<!--XLATETHIS-->Error! Number expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1016'">
				<!--XLATETHIS-->Error! Date in form mmddyy expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>		
			<xsl:when test="$id = '1017'">
				<!--XLATETHIS-->Error! Percent (0-100) expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>	
			<xsl:when test="$id = '1018'">
				<!--XLATETHIS-->Error! Number with up to 1 digit after decimal point expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '1019'">
				<!--XLATETHIS-->Error! Number with up to 2 digits after decimal point  expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>			
			<xsl:when test="$id = '1020'">
				<!--XLATETHIS-->Error! Number with up to 3 digits after decimal point  expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>	
			<xsl:when test="$id = '1021'">
				<!--XLATETHIS-->Error! Month is invalid: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1022'">
				<!--XLATETHIS-->Error! Day is invalid: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1023'">
				<!--XLATETHIS-->Error! Not a leap year: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1024'">
				<!--XLATETHIS-->Error! Alphanumeric expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>	
			<xsl:when test="$id = '1025'">
				<!--XLATETHIS-->Error! Unrecognized parameter: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1026'">
				<!--XLATETHIS-->Error! Cannot make date with this mmddyy on 32 bit operating system: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1027'">
				<!--XLATETHIS-->Error! Invalid IP Address, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				</xsl:when>
			<xsl:when test="$id = '1028'">
				<!--XLATETHIS-->Error! Required parameter missing: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/><xsl:text>=</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
				</xsl:when>
			<xsl:when test="$id = '1037'">
				<!--XLATETHIS-->Error! Whole numbers separated by colon(s) expected. Read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1038'">
				<!--XLATETHIS-->Error! Whole numbers separated by colon range error. Max is: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
					
			<xsl:when test="$id = '1039'">
				<!--XLATETHIS-->Error! Multiple values not unique:  <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1040'">
				<!--XLATETHIS-->Error! Illegal combination of parameters. <!--XLATETHIS-->
			</xsl:when>
			
			<xsl:when test="$id = '1041'">
				<xsl:text>Error! Value of: (</xsl:text>
				<xsl:value-of select="$paramtxt"/>
				<xsl:text>) must be between: (</xsl:text>
				<xsl:value-of select="$parsetxt"/>
				<xsl:text>) and (</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
				<xsl:text>)</xsl:text>
			</xsl:when>	
						
			<xsl:when test="$id = '1042'">
				<xsl:text>Error! Value of: (</xsl:text>
				<xsl:value-of select="$paramtxt"/>
				<xsl:text>) must be between: (</xsl:text>
				<xsl:value-of select="$parsetxt"/>
				<xsl:text>) and (</xsl:text>
				<xsl:value-of select="$parsetxt2"/>
				<xsl:text>)</xsl:text>
			</xsl:when>	
			
			<xsl:when test="$id = '1043'">
				<!--XLATETHIS-->Error! Invalid IP Subnet, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>	
						
			<xsl:when test="$id = '1044'">
				<!--XLATETHIS-->Error! IP Subnet set bits must be contiguous, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>	
			
			<xsl:when test="$id = '1046'">
				<!--XLATETHIS-->Error! Whole numbers separated by two colon(s) expected. Read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1047'">
			    	<!--XLATETHIS-->Error!<!--XLATETHIS-->
				<xsl:if test='contains($parsetxt, "amdef1")'><!--XLATESTART--> Whole numbers<!--XLATESTOP--></xsl:if>
				<xsl:if test='substring-after($parsetxt, "amdef1+")'><!--XLATESTART--> or<!--XLATESTOP--></xsl:if>
				<xsl:if test='contains($parsetxt, "amdef2")'><!--XLATESTART--> whole numbers separated by 1 colon<!--XLATESTOP--></xsl:if>
				<xsl:if test='substring-after($parsetxt, "amdef2+")'><!--XLATESTART--> or<!--XLATESTOP--></xsl:if>
				<xsl:if test='contains($parsetxt, "amdef3")'><!--XLATESTART--> whole numbers separated by 2 colons<!--XLATESTOP--></xsl:if>
			    	<!--XLATETHIS--> expected.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = '1049'">
				<!--XLATETHIS-->Error! Whole numbers separated by same number of colon(s) expected.<!--XLATETHIS-->
			</xsl:when>
			<xsl:when test="$id = '1053'">
				<!--XLATETHIS-->Error! Unsigned number too large. Maximum value is: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
			</xsl:when>
			<xsl:when test="$id = '1101'">
				<!--XLATETHIS-->Error! Signed number or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1102'">
				<!--XLATETHIS-->Error! unsigned number or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1103'">
				<!--XLATETHIS-->Error! true or false or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1104'">
				<!--XLATETHIS-->Error! alphanumeric or symbol or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
			<xsl:when test="$id = '1105'">
				<!--XLATETHIS-->Error! positive number or "default" expected, read: <!--XLATETHIS-->
				<xsl:value-of select="$parsetxt"/>
				<xsl:call-template name="NewLine"/>
				<xsl:call-template name="NewLine"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
