<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml" indent="no"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="/OMA">
		<xsl:apply-templates select="ChassisList/Chassis/ChassisInfo/BaseBoardList"/>
	</xsl:template>
	<xsl:template match="ChassisList/Chassis/ChassisInfo/BaseBoardList">
	     <BBInfo>
			<xsl:for-each select="BaseBoard">
			     <xsl:choose>
		            	<xsl:when test="BaseBoardType='11'">
		                	<pmmoid>
							<xsl:value-of select="@oid"/>
						</pmmoid>
				   	</xsl:when>
		            	<xsl:when test="BaseBoardType='12'">
		                	<iomoid>
							<xsl:value-of select="@oid"/>
						</iomoid>
				   	</xsl:when>
				</xsl:choose>
			</xsl:for-each>
			<xsl:for-each select="BaseBoard[BaseBoardType='2'] ">
			     <xsl:choose>
	      			<xsl:when test="position() = 1">
	                	     <dsm0oid>
							<xsl:value-of select="@oid"/>
						</dsm0oid>
					</xsl:when>
	      			<xsl:when test="position() = 2">
	                	     <dsm1oid>
							<xsl:value-of select="@oid"/>
						</dsm1oid>
					</xsl:when>
	      			<xsl:when test="position() = 3">
	                	     <dsm2oid>
							<xsl:value-of select="@oid"/>
						</dsm2oid>
					</xsl:when>
				  </xsl:choose>
			</xsl:for-each>
		</BBInfo>
	</xsl:template>
	<xsl:template match="*"/>

</xsl:stylesheet>
