<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<xsl:strip-space elements="*"/>
<xsl:output method="xml"/>
<xsl:template match="/OMA">
	<DataArea>
		<xsl:attribute name="backpagedisplay"><xsl:value-of select="$strSlots"/></xsl:attribute>
		<xsl:attribute name="backpagetarget">./DataArea?plugin=com.dell.hip.webplugins.SlotsWebPlugin&amp;poid=2&amp;help=Slots</xsl:attribute>
		<PageTitle>
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterInformation"/></xsl:attribute>
		</PageTitle>
		<CustomButton>
			<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.SlotDeviceWebPlugin&amp;help=Adapter&amp;poid=<xsl:value-of select="Slot/@oid"/>&amp;id=<xsl:value-of select="Slot/@slotid"/></xsl:attribute>
			</Data>
		</CustomButton>
		<ListData type="custom">
			<xsl:choose>
				<xsl:when test="SMStatus[1] = '0' or SMStatus[2] = '0'">
					
					<xsl:apply-templates select="SlotDevice"/>
				</xsl:when>
				<xsl:otherwise>
					<Header>
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strError1"/></xsl:attribute>
						</Data>
					</Header>
					
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strSlotInformationNot"/></xsl:attribute>
							
						</Data>
					
				</xsl:otherwise>
			</xsl:choose>
		</ListData>
	</DataArea>
</xsl:template>

<xsl:template match="SlotDevice">

		<Data name="DeviceManufacturer"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterManufacturer"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strAdapterManufacturer1"/></xsl:attribute>
		
			<xsl:attribute name="value"><xsl:value-of select="Manufacturer"/></xsl:attribute>
		</Data>
	
		<Data name="DeviceDesc"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterDescription"/></xsl:attribute>
			
			<xsl:choose>
				<xsl:when test="DeviceDesc = 'ERA'"><xsl:attribute name="value"><xsl:value-of select="$strEmbeddedRemoteAccess"/></xsl:attribute></xsl:when>
				<xsl:otherwise><xsl:attribute name="value"><xsl:value-of select="DeviceDesc"/></xsl:attribute></xsl:otherwise>
			</xsl:choose>
		</Data>
	
		<Data name="DeviceDataBusWidth"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterDataBus"/></xsl:attribute>
			
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="DataBusWidth = '0'"><xsl:value-of select="$strNotObtainedRefer"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="DataBusWidth"/> <xsl:value-of select="$strBits"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	
		<Data name="DeviceSpeed"  editable="false" type="ustring">
			<xsl:attribute name="display"><xsl:value-of select="$strAdapterSpeed"/></xsl:attribute>
			
			<xsl:attribute name="value">
				<xsl:choose>
					<xsl:when test="Speed='0'"><xsl:value-of select="$strNotObtainedRefer"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="Speed"/><xsl:text> </xsl:text><xsl:value-of select="Speed/@unit"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
		</Data>
	
	<!-- Below condition check is to report the size of storage card if present on AMEA. Type='1' indicates AMEA Card -->

	<xsl:if test="MaserDeviceInfo/Type='1' and MaserDeviceInfo/IsStoragePresent='1'">
	
		<Data name="Storage">
			<xsl:attribute name="display"><xsl:value-of select="$strInstalledSDSize"/></xsl:attribute>
			
			<xsl:attribute name="value"><xsl:value-of select="MaserDeviceInfo/Size"/><xsl:value-of select="$strMB"/></xsl:attribute>
		</Data>
	
	</xsl:if>

</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>
