<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
 	<xsl:strip-space elements="*"/>
	<xsl:output method="xml"/>

	<xsl:template match="OMA">
	
		<xsl:choose>
			<xsl:when test="SDCardObj/SMStatus != '0'">
				<DataArea printable="false">
					<PageTitle>
					<xsl:attribute name="display"><xsl:value-of select="$strRemovableFlashMedia"/></xsl:attribute>
					</PageTitle>
					<TableData>
						<Header>
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strError"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strError"/></xsl:attribute>
							</Data>
						</Header>
						<Row>
							<Data><xsl:attribute name="display"><xsl:value-of select="$str"/></xsl:attribute>
								<xsl:attribute name="value">
									<xsl:call-template name="smstatus">
										<xsl:with-param name="status"><xsl:value-of select="SMStatus"/></xsl:with-param>
									</xsl:call-template>
								</xsl:attribute>
							</Data>
						</Row>
					</TableData>
				</DataArea>
			</xsl:when>
			<xsl:otherwise>
				<DataArea>
				  
					<PageTitle>
						<xsl:attribute name="display"><xsl:value-of select="$strRemovableFlashMedia"/></xsl:attribute>
						<xsl:choose>
							<xsl:when test="count(/OMA/SDCardObj/Redundancy[subType='52'])>0">
							         <xsl:for-each select="/OMA/SDCardObj/Redundancy">
												<xsl:if test="subType=52">
												 		<xsl:attribute name="status"><xsl:value-of select="objstatus"/></xsl:attribute>
												 </xsl:if>
								     </xsl:for-each>
							</xsl:when>
						<xsl:otherwise>
						<xsl:if test="count(/OMA/SDCardObj/SDCard[Type='3']) > 0">
						<xsl:attribute name="status"><xsl:value-of select="/OMA/SDCardObj/computedobjstatus"/></xsl:attribute>
						</xsl:if>
						</xsl:otherwise>
						</xsl:choose>
					</PageTitle>
					<CustomButton>
						<Data name="Refresh">
							<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
							<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.SDCardWebPlugin&amp;help=sdcard</xsl:attribute>
						</Data>
					</CustomButton>
					<xsl:call-template name="ChassisSDCard"/>
	                    	</DataArea>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="ChassisSDCard">
		
		<xsl:apply-templates select="SDCardObj"/>
	</xsl:template>

	<xsl:template match="SDCardObj">


			<xsl:if test="/OMA/SDCardObj/Redundancy[subType='52']">

	<TableData name="reduntable">
		
			<xsl:apply-templates select="Redundancy[subType='52']"/>
		
	</TableData>
	</xsl:if>

			<xsl:if test="/OMA/SDCardObj/SDCard[Type='3']">
				
			<TableData columnspacing="true" name="individualsdcard">
				<xsl:attribute name="display"><xsl:value-of select="$strInternalSDStatus"/></xsl:attribute>
				
			
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strInternalSDStatus"/></xsl:attribute>
			</SubHeader>
			<Header>
				<Data align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strStatus"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStatus"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strConnectorName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strConnectorName"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
				</Data>
				<Data align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strStorageSize"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStorageSize"/></xsl:attribute>
				</Data>
			</Header>
				<xsl:apply-templates select="SDCard[Type=3]"/>
			</TableData>
			</xsl:if>
		

			<xsl:if test="/OMA/SDCardObj/SDCard[Type='4'] ">
			<TableData columnspacing="true" name="vflash">
				<xsl:attribute name="display"><xsl:value-of select="$strvflash"/></xsl:attribute>
				
			
			<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strvflashdetails"/></xsl:attribute>
			</SubHeader>
			<Header>
							
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strConnectorName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strConnectorName"/></xsl:attribute>
				</Data>		
						<xsl:if test="SDCard/SDCardCertifiedByDell">
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strType"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strType"/></xsl:attribute>
							</Data>	
						</xsl:if>							
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strState"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strState"/></xsl:attribute>
				</Data>				
						<xsl:if test="SDCard/SDCardFreeSizeMB">
							<Data align="center">
								<xsl:attribute name="display"><xsl:value-of select="$strAvailableSize"/></xsl:attribute>
								<xsl:attribute name="value"><xsl:value-of select="$strAvailableSize"/></xsl:attribute>
							</Data>
						</xsl:if>									
				<Data align="center">
					<xsl:attribute name="display"><xsl:value-of select="$strStorageSize"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strStorageSize"/></xsl:attribute>
				</Data>
			</Header>
				<xsl:apply-templates select="SDCard[Type='4']"/>
			</TableData>
			</xsl:if>		
			
                       </xsl:template>
	
	<xsl:template match="SDCard[Type='3']">
	
		<Row>					   
				<Data type="status" align="center">
					<xsl:attribute name="value"><xsl:value-of select="objstatus"/></xsl:attribute>
				</Data>			
			 <Data type="connectorname" align="left">
				<xsl:attribute name="value"><xsl:value-of select="SDCardLocation"/></xsl:attribute>
			</Data>
           <xsl:choose>
		    <xsl:when test="SDCardPresent='true'">
			<Data align="left">
				<ValueList>
					<xsl:call-template name="StateValue">
						<xsl:with-param name="sdStateNode" select="SDCardState"/>
					</xsl:call-template>
				</ValueList>
			</Data>
				 
			<Data type="storagesize" align="center">
				<xsl:attribute name="value"><xsl:call-template name="StorageSize"><xsl:with-param name="Size"><xsl:value-of select="SDCardSizeMB"/></xsl:with-param></xsl:call-template></xsl:attribute>

			</Data>
			</xsl:when>
	      	<xsl:otherwise>
			<Data type="state">
				<xsl:attribute name="value"><xsl:value-of select="$strNotPresent"/></xsl:attribute>
             </Data>
			  <Data type="storagesize" align="center">
				<xsl:attribute name="value"><xsl:text>[</xsl:text><xsl:value-of select="$strNotAvailable"/><xsl:text>]</xsl:text></xsl:attribute>
			</Data>
			 </xsl:otherwise>
			</xsl:choose>
			
			
	  	</Row>
	</xsl:template>

	<xsl:template match="SDCard[Type='4']">
		<Row>
			
			
			 <Data type="connectorname">
				<xsl:attribute name="value"><xsl:value-of select="SDCardLocation"/></xsl:attribute>
			</Data>
           <xsl:choose>
		    <xsl:when test="SDCardPresent='true'">
					<xsl:if test="SDCardCertifiedByDell">				
						<Data type="cardtype">
							<xsl:attribute name="value"><xsl:call-template name="CardType"><xsl:with-param name="type"><xsl:value-of select="SDCardCertifiedByDell"/></xsl:with-param></xsl:call-template></xsl:attribute>
						</Data>
					</xsl:if>				    
			<Data type="state">
				 <xsl:attribute name="value"><xsl:value-of select="$strPresent"/></xsl:attribute>         
			 </Data>
					<xsl:if test="SDCardFreeSizeMB">						
						<Data type="availablesize" align="center">
							<xsl:attribute name="value"><xsl:call-template name="AvailableSize"><xsl:with-param name="freesize"><xsl:value-of select="SDCardFreeSizeMB"/></xsl:with-param></xsl:call-template></xsl:attribute>
						</Data>
					</xsl:if>			 
		  <Data type="storagesize" align="center">
				<xsl:attribute name="value"><xsl:call-template name="StorageSize"><xsl:with-param name="Size"><xsl:value-of select="SDCardSizeMB"/></xsl:with-param></xsl:call-template></xsl:attribute>

			</Data>
		  </xsl:when>
	      <xsl:otherwise>		
				<xsl:if test="SDCardCertifiedByDell">					
					<Data type="cardtype">
						<xsl:attribute name="value"><xsl:text>[</xsl:text><xsl:value-of select="$strNotAvailable"/><xsl:text>]</xsl:text>	</xsl:attribute>
					</Data>	
				</xsl:if>	      
		  <Data type="state">
				<xsl:attribute name="value"><xsl:value-of select="$strNotPresent"/></xsl:attribute>
             </Data>	
					<xsl:if test="SDCardFreeSizeMB">						
						<Data type="availablesize" align="center">
							<xsl:attribute name="value"><xsl:text>[</xsl:text><xsl:value-of select="$strNotAvailable"/><xsl:text>]</xsl:text>	</xsl:attribute>
					</Data>
					</xsl:if>            
			  <Data type="storagesize" align="center">
				<xsl:attribute name="value"><xsl:text>[</xsl:text><xsl:value-of select="$strNotAvailable"/><xsl:text>]</xsl:text></xsl:attribute>
			</Data>
            </xsl:otherwise>
			</xsl:choose>
			</Row>
		
	</xsl:template>
	
		<xsl:template name="CardType">
		<xsl:param name="type"/>
		<xsl:choose>
			<xsl:when test="$type='0'">
				<xsl:value-of select="$strSDCard"/>
			</xsl:when>
			<xsl:when test="$type='1'">
				<xsl:value-of select="$strvFlashSDCard"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="AvailableSize">
		<xsl:param name="freesize"/>
		<xsl:choose>
			<xsl:when test="$freesize&gt;'-1'">
				
				<xsl:value-of select="$freesize"/>
				<xsl:value-of select="$strMB"/>
			
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$strUnknown"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

<xsl:template name="StorageSize">
		<xsl:param name="Size"/>
			<xsl:choose>
				<xsl:when test="($Size >= '1024')">
				<xsl:value-of select="round($Size div 1024)"/>
					<xsl:value-of select="$strGB"/>			
				</xsl:when>
				<xsl:otherwise>
				<xsl:value-of select="$Size"/>
				<xsl:value-of select="$strMB"/>
				</xsl:otherwise>
			</xsl:choose>
			
			
	</xsl:template>


	  <xsl:template match="/OMA/SDCardObj/Redundancy[subType='52']">
	  		<xsl:attribute name="display"><xsl:value-of select="$strInternalSDRedundancy"/></xsl:attribute>
	  		     
				<SubHeader>
	  					<xsl:attribute name="display"><xsl:value-of select="$strInternalSDRedundancy"/></xsl:attribute>
						<xsl:attribute name="status"><xsl:value-of select="objstatus"/></xsl:attribute>
					
	  			</SubHeader>
			
	  		<Header>
	  			<Data>
	  				<xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
	  				<xsl:attribute name="value"><xsl:value-of select="$strAttribute"/></xsl:attribute>
	  			</Data>
	  			<Data>
	  				<xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
	  				<xsl:attribute name="value"><xsl:value-of select="$strValue"/></xsl:attribute>
	  			</Data>
		</Header>
 <Row>
			<Data>
				<xsl:attribute name="value"><xsl:value-of select="$strRedundancyStatus"/></xsl:attribute>
			</Data>
			<Data>
				<xsl:call-template name="RedStatus">
					<xsl:with-param name="status">
						<xsl:value-of select="redStatus"/>
					</xsl:with-param>
				</xsl:call-template>
			</Data>
		</Row>
</xsl:template>

	<xsl:template name="StateValue">
		<xsl:param name="sdStateNode"/>
		<xsl:if test="$sdStateNode/SDCardFailed='true'">
			<value><xsl:value-of select="$strStateFailureDetected"/></value>
		</xsl:if>
		<xsl:if test="$sdStateNode/SDCardOffLine='true'">
			<value><xsl:value-of select="$strStateOffline"/></value>
		</xsl:if>
		<xsl:if test="$sdStateNode/SDCardActive='true'">
			<value><xsl:value-of select="$strStateActive"/></value>
		</xsl:if>
		<xsl:if test="$sdStateNode/SDCardWriteProtect='true'">
			<value><xsl:value-of select="$strStateWriteProtect"/></value>
		</xsl:if>
		<xsl:if test="$sdStateNode/SDCardBoot='true'">
			<value><xsl:value-of select="$strStateBoot"/></value>
		</xsl:if>
		<xsl:if test="$sdStateNode/SDCardStandBy='true'">
			<value><xsl:value-of select="$strStandby"/></value>
		</xsl:if>
		<xsl:if test="not($sdStateNode/SDCardFailed='true' or $sdStateNode/SDCardOffLine='true' or $sdStateNode/SDCardActive='true' or $sdStateNode/SDCardWriteProtect='true' or $sdStateNode/SDCardBoot='true' or $sdStateNode/SDCardStandBy='true')">
			<value><xsl:value-of select="$strNotAvailable"/></value>
		</xsl:if>
	</xsl:template>

	<xsl:template name="RedStatus">
		<xsl:param name="status"/>
		<xsl:choose>
			<xsl:when test="$status = 1">
				<xsl:attribute name="value"><xsl:value-of select="$strNoValue"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 2">
				<xsl:attribute name="value"><xsl:value-of select="$strNotApplicable"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 3">
				<xsl:attribute name="value"><xsl:value-of select="$strOffline"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 4">
				<xsl:attribute name="value"><xsl:value-of select="$strFull"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 5">
				<xsl:attribute name="value"><xsl:value-of select="$strDegraded"/></xsl:attribute>
			</xsl:when>
			<xsl:when test="$status = 6">
				<xsl:attribute name="value"><xsl:value-of select="$strLost"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="$strOther"/></xsl:attribute>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="smstatus">
		<xsl:param name="status"/>
		<xsl:param name="mssg"/>
		<xsl:choose>
			<xsl:when test="$status = '-1'"><xsl:value-of select="$strCommandUnsuccessful"/></xsl:when>
			<xsl:when test="$status = '0'"><xsl:value-of select="$strCommandSuccessful"/></xsl:when>
			<xsl:otherwise>SMStatus: <xsl:value-of select="$status"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
