<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:strip-space elements="*"/>
	<xsl:output method="xml" indent="no"/>
	<xsl:template match="OMA">
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
	
	<xsl:choose>
        <xsl:when test="SMStatus = '0'">
	        <DataArea>				
 		        <PageTitle><xsl:attribute name="display"><xsl:value-of select="$strFRUInfomation"/></xsl:attribute></PageTitle>	
		        <CustomButton>
			        <Data name="Refresh">
				        <xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				        <xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.FRUWebPlugin&amp;help=FRU</xsl:attribute>
			        </Data>
		        </CustomButton>
		        <TableData columnspacing="true">
			        <Header>
				        <Data>
					        <xsl:attribute name="display"><xsl:value-of select="$strDevice"/></xsl:attribute>
					        <xsl:attribute name="value"><xsl:value-of select="$strDevice"/></xsl:attribute>
				        </Data>
				        <Data>
					        <xsl:attribute name="display"><xsl:value-of select="$strSerialNo"/></xsl:attribute>
					        <xsl:attribute name="value"><xsl:value-of select="$strSerialNo"/></xsl:attribute>
				        </Data>
				        <Data>
					        <xsl:attribute name="display"><xsl:value-of select="$strPartNo"/></xsl:attribute>
					        <xsl:attribute name="value"><xsl:value-of select="$strPartNo"/></xsl:attribute>
				        </Data>
				        <Data>
					        <xsl:attribute name="display"><xsl:value-of select="$strRevision"/></xsl:attribute>
					        <xsl:attribute name="value"><xsl:value-of select="$strRevision"/></xsl:attribute>
				        </Data>
				        <Data>
					        <xsl:attribute name="display"><xsl:value-of select="$strManufacturer"/></xsl:attribute>
					        <xsl:attribute name="value"><xsl:value-of select="$strManufacturer"/></xsl:attribute>
				        </Data>
				        <Data>
					        <xsl:attribute name="display"><xsl:value-of select="$strManufactureDate"/></xsl:attribute>
					        <xsl:attribute name="value"><xsl:value-of select="$strManufactureDate"/></xsl:attribute>
				        </Data>
			        </Header>		
			        <xsl:apply-templates select="/OMA/FRUIPMIObj">
				        <xsl:sort data-type="number" select="@instance" order="ascending"/>
			        </xsl:apply-templates>
			        <xsl:apply-templates select="/OMA/FRUSMBIOSObj">
				        <xsl:sort data-type="number" select="@instance" order="ascending"/>
			        </xsl:apply-templates>
		        </TableData>
	        </DataArea>
	    </xsl:when>
	    <xsl:otherwise>
	        <DataArea>				
 		        <PageTitle><xsl:attribute name="display"><xsl:value-of select="$strFRUInfomation"/></xsl:attribute></PageTitle>	
		        <CustomButton>
			        <Data name="Refresh">
				        <xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
				        <xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.FRUWebPlugin&amp;help=FRU</xsl:attribute>
			        </Data>
		        </CustomButton>
		        <TableData columnspacing="true">
		            <Header>
				        <Data>
					        <xsl:attribute name="display"><xsl:value-of select="$strInformation"/></xsl:attribute>
					        <xsl:attribute name="value"><xsl:value-of select="$strInformation"/></xsl:attribute>
				        </Data>
                    </Header>
			        <Row>
				        <Data>
					        <xsl:attribute name="display"><xsl:value-of select="$strErrorNoInfo"/></xsl:attribute>
					        <xsl:attribute name="value"><xsl:value-of select="$strErrorNoInfo"/></xsl:attribute>
				        </Data>
			        </Row>		
		        </TableData>
	        </DataArea>
	    </xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="/OMA/FRUIPMIObj">
	<Row>	
		<xsl:choose>
			<xsl:when test="DevName !=''">
				<xsl:element name="Data">
					<xsl:attribute name="display"><xsl:value-of select="DevName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="DevName"/></xsl:attribute>
				</xsl:element>	
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="Data">
					<xsl:attribute name="display"><xsl:value-of select="$strUnknown"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strUnknown"/></xsl:attribute>
				</xsl:element>	
			</xsl:otherwise>
		</xsl:choose>
		
				<xsl:variable name="ipmions" select="@ons"/>
				<xsl:for-each select="/OMA/FRUBoardInfoObj">
					<xsl:variable name="count1" select="position()"/>
  					<xsl:variable name="ons" select="/OMA/FRUBoardInfoObj[$count1]/@ons"/>
					<xsl:variable name="ons1" select="substring-after($ons,$ipmions)"/>

					<xsl:if test="$ons1!=''">
						<xsl:choose>
							<xsl:when test="BoardSerNum !=''">
								<xsl:element name="Data">
									<xsl:attribute name="display"><xsl:value-of select="BoardSerNum"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="BoardSerNum"/></xsl:attribute>
								</xsl:element>	
							</xsl:when>
							<xsl:otherwise>
								<xsl:element name="Data">
									<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								</xsl:element>	
							</xsl:otherwise>
						</xsl:choose>
						
						<xsl:choose>
							<xsl:when test="BoardPartNum !=''">
								<xsl:element name="Data">
									<xsl:attribute name="display"><xsl:value-of select="BoardPartNum"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="BoardPartNum"/></xsl:attribute>
								</xsl:element>	
							</xsl:when>
							<xsl:otherwise>
								<xsl:element name="Data">
									<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								</xsl:element>	
							</xsl:otherwise>
						</xsl:choose>

						<xsl:choose>
							<xsl:when test="RevisionLevel !=''">
								<xsl:element name="Data">
									<xsl:attribute name="display"><xsl:value-of select="RevisionLevel"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="RevisionLevel"/></xsl:attribute>
								</xsl:element>	
							</xsl:when>
							<xsl:otherwise>
								<xsl:element name="Data">
									<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								</xsl:element>	
							</xsl:otherwise>
						</xsl:choose>

						<xsl:choose>
							<xsl:when test="BoardManuf !=''">
								<xsl:element name="Data">
									<xsl:attribute name="display"><xsl:value-of select="BoardManuf"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="BoardManuf"/></xsl:attribute>
								</xsl:element>	
							</xsl:when>
							<xsl:otherwise>
								<xsl:element name="Data">
									<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								</xsl:element>	
							</xsl:otherwise>
						</xsl:choose>
						
						<xsl:choose>
							<xsl:when test="ManufDateTimeStr !=''">
								<xsl:element name="Data">
									<xsl:attribute name="display"><xsl:value-of select="ManufDateTimeStr"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="ManufDateTimeStr"/></xsl:attribute>
								</xsl:element>	
							</xsl:when>
							<xsl:otherwise>
								<xsl:element name="Data">
									<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
								</xsl:element>	
							</xsl:otherwise>
						</xsl:choose>		
					</xsl:if>
				</xsl:for-each>
	</Row>
</xsl:template>

<xsl:template match="/OMA/FRUSMBIOSObj">
	<Row>
		<xsl:choose>
			<xsl:when test="DevName !=''">
				<xsl:element name="Data">
					<xsl:attribute name="display"><xsl:value-of select="DevName"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="DevName"/></xsl:attribute>
				</xsl:element>	
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="Data">
					<xsl:attribute name="display"><xsl:value-of select="$strUnknown"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strUnknown"/></xsl:attribute>
				</xsl:element>	
			</xsl:otherwise>
		</xsl:choose>

		<xsl:choose>
			<xsl:when test="SerialNumber !=''">
				<xsl:element name="Data">
					<xsl:attribute name="display"><xsl:value-of select="SerialNumber"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="SerialNumber"/></xsl:attribute>
				</xsl:element>	
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="Data">
					<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
				</xsl:element>	
			</xsl:otherwise>
		</xsl:choose>

		<xsl:choose>
			<xsl:when test="PartNumber !=''">
				<xsl:element name="Data">
					<xsl:attribute name="display"><xsl:value-of select="PartNumber"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="PartNumber"/></xsl:attribute>
				</xsl:element>	
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="Data">
					<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
				</xsl:element>	
			</xsl:otherwise>
		</xsl:choose>
		
		<xsl:choose>
			<xsl:when test="RevisionLevel !=''">
				<xsl:element name="Data">
					<xsl:attribute name="display"><xsl:value-of select="RevisionLevel"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="RevisionLevel"/></xsl:attribute>
				</xsl:element>	
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="Data">
					<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
				</xsl:element>	
			</xsl:otherwise>
		</xsl:choose>
		
		<xsl:choose>
			<xsl:when test="Manufacturer !=''">
				<xsl:element name="Data">
					<xsl:attribute name="display"><xsl:value-of select="Manufacturer"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="Manufacturer"/></xsl:attribute>
				</xsl:element>	
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="Data">
					<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
				</xsl:element>	
			</xsl:otherwise>
		</xsl:choose>

		<xsl:choose>
			<xsl:when test="ManufDateTimeStr !=''">
				<xsl:element name="Data">
					<xsl:attribute name="display"><xsl:value-of select="ManufDateTimeStr"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="ManufDateTimeStr"/></xsl:attribute>
				</xsl:element>	
			</xsl:when>
			<xsl:otherwise>
				<xsl:element name="Data">
					<xsl:attribute name="display"><xsl:value-of select="$strNA"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$strNA"/></xsl:attribute>
				</xsl:element>	
			</xsl:otherwise>
		</xsl:choose>
	</Row>
</xsl:template>
</xsl:stylesheet>