<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml" indent="no"/>
	<xsl:strip-space elements="*"/>
  <xsl:variable name="IsCLICmdNew">
    <xsl:choose>
      <xsl:when test="/OMA/OMACMDNEW='0'">false</xsl:when>
      <xsl:otherwise>true</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
	<xsl:template match="/OMA">
		<DataArea>
			<xsl:apply-templates select="ChassisInfo"/>
		</DataArea>
	</xsl:template>
	
	
	<xsl:template match="ChassisInfo">
		<xsl:choose>
	         <xsl:when test="(ChassisProps2/IdentifySupport != 'true' ) and ( ChassisProps2/HdLedSupport != 'true') and 	(ChassisProps2/FaultLEDControl = '0')">
				<PageTitle>
					<xsl:attribute name="display"><xsl:value-of select="$strErrorNoLeds"/></xsl:attribute>
				</PageTitle>
			</xsl:when>
			<xsl:otherwise>
				<PageTitle>
          <xsl:choose>
           <xsl:when test="$IsCLICmdNew='true'">
             <xsl:attribute name="display"><xsl:value-of select="$strMainSystem"/></xsl:attribute>
           </xsl:when>
           <xsl:otherwise>
             <xsl:attribute name="display"><xsl:value-of select="/OMA/Chassis/@display"/></xsl:attribute>
           </xsl:otherwise>
         </xsl:choose>
        </PageTitle>
				<ListData>
					<xsl:if test="ChassisProps2/IdentifySupport">
						<xsl:if test="ChassisProps2 /IdentifySupport = 'true'">
							<Data>
                <xsl:choose>
                  <xsl:when test="$IsCLICmdNew='true'">
                    <xsl:attribute name="display"><xsl:value-of select="$strFlashServerModuleIdentify"/>		</xsl:attribute>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:attribute name="display"><xsl:value-of select="$strFlashChassisIdentify"/>		</xsl:attribute>    
                  </xsl:otherwise>
                </xsl:choose>
								
								<xsl:attribute name="value">
									<xsl:choose>
							              <xsl:when test="ChassisProps2/ ChassIdentifyState = '0'"><xsl:value-of select="$strOff"/>
							              </xsl:when>
							              <xsl:when test="ChassisProps2/ ChassIdentifyState = '1'"><xsl:value-of select="$strFlashing"/>
							              </xsl:when>
							              <xsl:otherwise><xsl:value-of select="$strUndefined"/>
							              </xsl:otherwise>
						               </xsl:choose>
				 				</xsl:attribute>
							</Data>
              <Data>
                <xsl:choose>
                  <xsl:when test="$IsCLICmdNew='true'">
                      <xsl:attribute name="display"><xsl:value-of select="$strFlashServerModuleIdentify1"/>			</xsl:attribute>
                  </xsl:when>
                  <xsl:otherwise>
                   <xsl:attribute name="display"><xsl:value-of select="$strFlashChassisIdentify1"/>			</xsl:attribute>
                  </xsl:otherwise>
                </xsl:choose>
                  <xsl:attribute name="value"><xsl:value-of select="ChassisProps2 /ChassIdentifyTimeout " /></xsl:attribute>
							  </Data>
            </xsl:if>
					</xsl:if>
					<xsl:if test="ChassisProps2/HdLedSupport = 'true'">
						<Data>
							<xsl:attribute name="display"><xsl:value-of select="$strClearHardDrive"/></xsl:attribute>
							<xsl:attribute name="value"><xsl:value-of select="$strSupported"/></xsl:attribute>
						</Data>
					</xsl:if>
					<xsl:if test="ChassisProps2/FaultLEDControl">
						<xsl:if test="ChassisProps2/FaultLEDControl != '0'">
							<Data>
								<xsl:attribute name="display"><xsl:value-of select="$strFlashFaultLed"/>	</xsl:attribute>
								<xsl:attribute name="value">
							 		<xsl:call-template name="FaultLEDSeverity">
										<xsl:with-param name="Severity">
				  						<xsl:value-of select="ChassisProps2 /FaultLEDControl" /> 
				  						</xsl:with-param>
									</xsl:call-template>
				 				</xsl:attribute>
							</Data>
						</xsl:if>
					</xsl:if>
			</ListData>
		</xsl:otherwise>
      	</xsl:choose>
	</xsl:template>
	
	<xsl:template name="FaultLEDSeverity">
		<xsl:param name="Severity"/>
		<xsl:choose>
			<xsl:when test="$Severity = '8'"><xsl:value-of select="$strWarning"/>
			</xsl:when>
			<xsl:when test="$Severity = '16'"><xsl:value-of select="$strCritical"/>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="$strUndefined1"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
