<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="xml" indent="no"/>
	<xsl:template match="OMA">
		<xsl:choose>
			<xsl:when test="SMStatus = '0'">
				<xsl:apply-templates select="ESMLog"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="failure"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="failure">
		<DataArea>
			<xsl:attribute name="status"><xsl:value-of select="/OMA/ObjStatus"/></xsl:attribute>
			<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strErrorNoEmbedded"/></xsl:attribute></PageTitle>
		</DataArea>
	</xsl:template>
	<xsl:template match="ESMLog">
		<DataArea>
			<script language="javascript">
				function clearLog()
				{
					document.dataarea.action=top.gnv.appendVID('./SubmitForm?plugin=com.dell.hip.webplugins.ClearESMLogWebPlugin');
					//[pp 01/08/04 - DFCT102605 Prompt user to confirm before deleting log
					if(confirm('<xsl:value-of select="$strAreYouSure"/>'))
						document.dataarea.submit();
				}
				function saveLog()
				{
					document.dataarea.action=top.gnv.appendVID('./SubmitForm?plugin=com.dell.oma.webplugins.SaveLogWebPlugin');
					
					// DFCT93265, Clicking on the "Save As" button second time and performing either save or cancel, resulted an Abend on all flavous of Netware.
                                	// The following single line has been added for fixing the problem.
				
					document.getElementById("pageCode").value = "";
					
					document.getElementById("pageCode").value = document.getElementsByTagName("HTML")[0].innerHTML;
					document.dataarea.submit();
				}
			</script>		
			<Header>Header</Header>
			<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strEmbeddedSystemManagement"/></xsl:attribute>
				<xsl:attribute name="status"><xsl:value-of select="/OMA/ObjStatus"/></xsl:attribute>
			</PageTitle>
			
			<CustomButton>
				<xsl:if test="(/OMA/OMAUserRights = '7')">		
					<Data name="Clear">
						<xsl:attribute name="display"><xsl:value-of select="$strClearLog"/></xsl:attribute>
						<xsl:attribute name="href">javascript:clearLog()</xsl:attribute>
						<xsl:attribute name="formSubmit">true</xsl:attribute>
					</Data>
				</xsl:if>
				<xsl:if test="(/OMA/OMAUserRights = '7') or (/OMA/OMAUserRights = '3')">
					<Data name="Save"><xsl:attribute name="display"><xsl:value-of select="$strSaveAs"/></xsl:attribute>
						<xsl:attribute name="href">javascript:saveLog()</xsl:attribute>
						<xsl:attribute name="formSubmit">true</xsl:attribute>
					</Data>
				</xsl:if>
				<Data name="Refresh">
					<xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.ESMLogWebPlugin&amp;help=HardwareLog&amp;sortkey=date&amp;order=ascending</xsl:attribute>
				</Data>
			</CustomButton>
			<TableData columnspacing="true" sortable="true">
				<Header>
					<Data name="Severity" align="center">
						<xsl:attribute name="display"><xsl:value-of select="$strSeverity"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strSeverity1"/></xsl:attribute>
						<xsl:attribute name="link">true</xsl:attribute>
						<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.ESMLogSevWebPlugin</xsl:attribute>
					</Data>
					<Data name="Time">
						<xsl:attribute name="display"><xsl:value-of select="$strDateAmpTime"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strDateAmpTime1"/></xsl:attribute>
						<xsl:attribute name="link">true</xsl:attribute>
						<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.ESMLogWebPlugin</xsl:attribute>
					</Data>					
					<Data name="Event">
						<xsl:attribute name="display"><xsl:value-of select="$strDescription"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$strDescription1"/></xsl:attribute>
						<xsl:attribute name="link">true</xsl:attribute>
						<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.ESMLogDescWebPlugin</xsl:attribute>
					</Data>
				</Header>
				<xsl:apply-templates select="LogEntry">
					<xsl:sort select="TimeStampRaw" data-type="number" order="ascending"/>
				</xsl:apply-templates>
			</TableData>
		</DataArea>
	</xsl:template>
	
	<xsl:template match="LogEntry">
		<Row>
			<Data name="severity" type="status" align="center" >
				<xsl:attribute name="value"><xsl:value-of select="Status"/></xsl:attribute>
			</Data>
			<Data name="time" type="ustring" width="200">
				<xsl:attribute name="value"><xsl:value-of select="TimeStamp"/></xsl:attribute>
				<xsl:attribute name="display"><xsl:value-of select="TimeStampRaw"/></xsl:attribute>
			</Data>		
			<Data name="description" type="ustring">
				<xsl:attribute name="value"><xsl:value-of select="Description"/></xsl:attribute>
			</Data>
		</Row>
	</xsl:template>
	
</xsl:stylesheet>
