<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- including globals for CLI. GUI automatically loads globals.xsl -->
	<xsl:include href="../en/globals.xsl"/>
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>
	<xsl:variable name="IsIMCPresent">
	    <xsl:choose>
	      <xsl:when test="/OMA/EMPObj/type &gt; '7'">true</xsl:when>
	      <xsl:otherwise>false</xsl:otherwise>
	    </xsl:choose>
  	</xsl:variable>

  	
	<xsl:template match="OMA">
		<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		<DataArea validate="true" onLoad="true" ipbox="true">
			<xsl:if test="$usrights='7' ">
					<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetBmcNicWebPlugin</xsl:attribute>
			</xsl:if>
			<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strLANConfiguration"/></xsl:attribute></PageTitle>
		

			<xsl:if test="EMPObj/defaultRestoreStatus = '0'">
				<xsl:if test="EMPObj/defaultRestoreSupport = '1'">
				<xsl:choose>
					<xsl:when test = "/OMA/@cli = 'true'">
						<PromptText><xsl:value-of select ="$gstrResetToDefaultCli"/></PromptText>
					</xsl:when>
					<xsl:otherwise>
							<PromptText><xsl:value-of select="$gstrResetToDefault"/></PromptText>
					</xsl:otherwise>
				</xsl:choose>	
			</xsl:if>
		</xsl:if>
			
			<xsl:if test="EMPLANConfigObj/IPMIMessagingAccessMode = '2'">
			<xsl:choose>
				  <xsl:when test="EMPNICConfigObj/teamingModeCapabilities/NIC1TeamedNIC2='true'">
					<AlertMessage status="3"> <xsl:attribute name="display"><xsl:value-of select="$strWarning9G"/></xsl:attribute></AlertMessage>
				  </xsl:when>
				  <xsl:otherwise>
					<AlertMessage status="3"> <xsl:attribute name="display"><xsl:value-of select="$strWarning"/></xsl:attribute></AlertMessage>
				  </xsl:otherwise>
			</xsl:choose>
			</xsl:if>
			<xsl:if test="EMPLANConfigObj/IPAddrSourceMsg/StaticOnly = 'true'">
				<AlertMessage status="3"> <xsl:attribute name="display"><xsl:value-of select="$strWarningGlacier"/></xsl:attribute></AlertMessage>
			</xsl:if>

			<CustomButton>
				<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
					<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.BMCNICWebPlugin&amp;help=RemoteAccessLan</xsl:attribute>
				</Data>
			</CustomButton>

			<ListData name="tabNICConfiguration" type="custom">
        <xsl:attribute name="display"><xsl:value-of select="$strNICConfiguration"/></xsl:attribute>
				<Header>
          <Data>
					<xsl:attribute name="display"><xsl:value-of select="$strNICConfiguration"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$strNICConfiguration"/></xsl:attribute>
            </Data>
				</Header>
		
				<xsl:apply-templates select="EMPRACObj"/>
				<xsl:apply-templates select="EMPNICConfigObj"/>
				<xsl:apply-templates select="EMPLANConfigObj">
					<xsl:with-param name="bIsIPTable">false</xsl:with-param>
				</xsl:apply-templates>
		            <xsl:apply-templates select="EMPChSecKeyListObj"/>
			</ListData>

	<!-- Displaying of VLAN ID , VLANENABLE, Priority String -->
	<xsl:if test="EMPLANConfigObj/VLANID != '-1'" >
	<ListData name="tabVLANTag" type="custom">
    <xsl:attribute name="display"><xsl:value-of select="$strVLANTag"/></xsl:attribute>
		<Header>
      <Data>
				<xsl:attribute name="display"><xsl:value-of select="$strVLANTag"/></xsl:attribute>
        <xsl:attribute name="value"><xsl:value-of select="$strVLANTag"/></xsl:attribute>
      </Data>
		</Header>
	

			<Data width="250" name="VLANEnable" type="checkbox" editable="true" align="left" event="onClick" handler="javascript:EnableVLANSettings()">
        <xsl:attribute name="display">
          <xsl:value-of select="$strEnableVLANID"/>
        </xsl:attribute>
     
				<xsl:if test="EMPLANConfigObj/VLANIDEnable='1'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>

		
				<Data name="VLANIDString" type="editbox" editable="true">
				<xsl:attribute name="display"><xsl:value-of select="$strVLANID"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="EMPLANConfigObj /VLANID"/></xsl:attribute>
			</Data>

	
		<Data name="PriorityString" type="editbox" editable="true">
				<xsl:attribute name="display"><xsl:value-of select="$strPriority"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="EMPLANConfigObj/VLANPriority"/></xsl:attribute>
			</Data>


	</ListData>
	</xsl:if>


	<!-- Displaying of IPv4 Parameters for Configuration -->
      <xsl:if test="EMPObj/ipv4State='255' or EMPObj/ipv4State='1'">
        <ListData name="IPv4Address" type="custom">

	  <xsl:attribute name="display">
            <xsl:value-of select="$strIPv4Address"/>
          </xsl:attribute>

          <Header>
            <Data>
            <xsl:attribute name="display"><xsl:value-of select="$strIPv4Address"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$strIPv4Address"/></xsl:attribute>
              </Data>
          </Header>

     

          <xsl:apply-templates select="EMPLANConfigObj">
            <xsl:with-param name="bIsIPTable">true</xsl:with-param>
          </xsl:apply-templates>
        </ListData>
      </xsl:if>


	<!-- Displaying of IPv6 fields for configuration -->

	<xsl:if test="EMPV6LANConfigObj/ipv6State='1'" >
	<ListData type="custom"  name="IPv6Address">
		<xsl:attribute name="display">
			<xsl:value-of select="$strIPv6Address"/>
		</xsl:attribute>
	
		<Header>
      <Data>
			<xsl:attribute name="display"><xsl:value-of select="$strIPv6Address"/></xsl:attribute>
      <xsl:attribute name="value"><xsl:value-of select="$strIPv6Address"/></xsl:attribute>
       </Data>
		</Header>		
	    <xsl:apply-templates select="EMPV6LANConfigObj"/>
	</ListData>
	</xsl:if>


      <!-- Start changes for the enable or disable the IMC gui
      <xsl:if test="$IsIMCPresent='true'" >
        <TableData  columnspacing="true" name="tabIMCTag">
          <xsl:attribute name="display"><xsl:value-of select="$strIMCTag"/></xsl:attribute>
          <SubHeader>
            <xsl:attribute name="display"><xsl:value-of select="$strIMCTag"/></xsl:attribute>
          </SubHeader>
          <Header>
            <Data width="40%">
              <xsl:attribute name="display"><xsl:value-of select="$strAttribute"/></xsl:attribute>
              <xsl:attribute name="value"><xsl:value-of select="$strAttribute"/></xsl:attribute>
            </Data>
            <Data width="60%">
              <xsl:attribute name="display"><xsl:value-of select="$strValue"/></xsl:attribute>
              <xsl:attribute name="value"><xsl:value-of select="$strValue"/></xsl:attribute>
            </Data>
          </Header>

          <Row>
            <Data type="ustring" editable="false">
              <xsl:attribute name="value">
                <xsl:value-of select="$strEnableIMCGUI"/>
              </xsl:attribute>
            </Data>
            <Data name="EnableIMCGUI" type="checkbox" editable="true" align="left" >
              <xsl:if test="EMPObj/uiStatus=''">
                <xsl:attribute name="state">1</xsl:attribute>
              </xsl:if>
            </Data>
          </Row>
        </TableData>
      </xsl:if>
 end changes for the enable or disable the IMC gui -->



	    <!--TableData  columnspacing="true" name="tabUserConfiguration"><xsl:attribute name="display"><xsl:value-of select="$strUserAuthenticationType"/></xsl:attribute>
		<SubHeader>
				<xsl:attribute name="display"><xsl:value-of select="$strUserAuthenticationType"/></xsl:attribute>
		</SubHeader>
		<Header>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strAuthTypes"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAuthTypes"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strAdministrator"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strAdministrator"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strOperator"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strOperator"/></xsl:attribute>
			</Data>
			<Data name="" editable="" type="">
				<xsl:attribute name="display"><xsl:value-of select="$strUser"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strUser"/></xsl:attribute>
			</Data>
		</Header>
			<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$strStraightPassword"/></xsl:attribute>
			</Data>
			<Data name="AdmAuthText" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableAdmin/Text='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="OpAuthText" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableOperator/Text='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="UserAuthText" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableUser/Text='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
		</Row>

			<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$strMD2"/></xsl:attribute>
			</Data>
			<Data name="AdmAuthMD2" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableAdmin/MD2='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="OpAuthMD2" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableOperator/MD2='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="UserAuthMD2" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableUser/MD2='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
		</Row>
		<Row>
			<Data type="ustring" editable="false" width="250">
				<xsl:attribute name="value"><xsl:value-of select="$strMD5"/></xsl:attribute>
			</Data>
			<Data name="AdmAuthMD5" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableAdmin/MD5='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>
			<Data name="OpAuthMD5" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableOperator/MD5='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>

			<Data name="UserAuthMD5" type="checkbox" editable="true" align="left" >
				<xsl:if test="EMPLANConfigObj/authenTypeEnableUser/MD5='true'">
					<xsl:attribute name="state">1</xsl:attribute>
				</xsl:if>
			</Data>

		</Row>
	</TableData-->



	<script language="javascript" src="/oma/js/IPSup.js"/>
	<script language="javascript">
	var usrights = "<xsl:value-of select="/OMA/OMAUserRights"/>";
	var vlansupport = "<xsl:value-of select="/OMA/EMPLANConfigObj/VLANID"/>";
        var IsIPv4Enabled = "<xsl:value-of select="/OMA/EMPObj/ipv4State"/>";
        var IsIPv6Enabled = "<xsl:value-of select="/OMA/EMPV6LANConfigObj/ipv6State"/>";
	
        
	function initializationRoutine()
	{

          
	  EnableNicDHCPSettings();

	   EnableVLANSettings();
         EnableSettingsAccordingtoUserRights();
         setFailoverNicBack();
      
      }

      

        function EnableSettingsAccordingtoUserRights()
        {
        if (usrights != 7 )
        {
	        document.getElementById("EnableNIC").disabled  =true;
	        if(('1' == IsIPv4Enabled) || ('255' == IsIPv4Enabled))
		{
			document.getElementById("ipAddressSource").disabled =true;
			document.getElementById("IPAddressBox1").disabled  =true;
			document.getElementById("SubnetAddrBox1").disabled  =true;
			document.getElementById("GatewayAddrBox1").disabled  =true;
		}
		if('1' == IsIPv6Enabled)
		{
			document.getElementById("ipv6AddressSource").disabled =true;
			document.getElementById("IPAddressIPv6").disabled  =true;
			document.getElementById("EditBox1").disabled  =true;
			document.getElementById("GatewayAddrIPv6").disabled  =true;
			document.getElementById("DNS6AddressSource").disabled =true;
			document.getElementById("IPAddressPDNS").disabled  =true;
			document.getElementById("IPAddressBoxADNS").disabled  =true;
		}
		if (document.dataarea.enableRACnic != null)
			document.dataarea.enableRACnic.disabled = true;

		if (document.dataarea.NicSelection != null)
			document.dataarea.NicSelection.disabled = true;
		
		if (document.dataarea.primaryNic != null)
			document.dataarea.primaryNic.disabled = true;
			
		if (document.dataarea.failoverNic != null)
			document.dataarea.failoverNic.disabled = true;

		if (document.dataarea.VLANEnable != null)
			document.dataarea.VLANEnable.disabled = true;

		if (document.dataarea.VLANIDString != null)
			document.dataarea.VLANIDString.disabled = true;

		if (document.dataarea.PriorityString != null)
			document.dataarea.PriorityString.disabled = true;

			document.getElementById("MaxAuth").disabled  =true;
		}
        }

        function tonum(obj){
	        return parseInt(obj, 10);
        }
        function Error_Codes(number)
        {
		var error="";
		switch(number)
		{
			case ERROR_NOTPERMITTED : error="<xsl:value-of select="$gstrerrnotpermitted"/>"; break; 
			case ERROR_INVALID_ADDRESS : error="<xsl:value-of select="$gstrerrinvalid"/>";break;
			default : error="<xsl:value-of select="$gstrerrdefault"/>";break;
		  }//end switch

		  return error;
		}//end function

	function IsObjDisabled(objstr)
	 {
	   var tempstr = eval("document.dataarea." + objstr);
	   if (tempstr.disabled == true)
	       return true;
	   else 
		   return false;
	}

        function validate()
        {        
	var field = document.createElement("input");
	field.setAttribute("type","hidden");
	field.setAttribute("id","DNSVal");
	field.setAttribute("value", "true");
	field.setAttribute("name","DNSVal");
	document.getElementById("dataarea").appendChild(field);

	var EnableVLANfield = document.createElement("input");
	EnableVLANfield.setAttribute("type","hidden");
	EnableVLANfield.setAttribute("id","VLAN");
	EnableVLANfield.setAttribute("value", vlansupport);
	EnableVLANfield.setAttribute("name","VLAN");
	document.getElementById("dataarea").appendChild(EnableVLANfield);

	if (IsIPv6Enabled != '0' &amp;&amp; IsIPv6Enabled != '' ){
		if (document.getElementById("DNS6AddressSource").disabled=="true")
			document.getElementById("DNSVal").value=1;
		else
			document.getElementById("DNSVal").value=document.getElementById("DNS6AddressSource").value;
	}

        var invalidIP = false,invalidIPv6=false;
        var errorFound = false;
        var errorMsg = "";
        var validHexChar = "1234567890abcdefABCDEF";
        var encryptionKeyValue;
        var charIndex;
        if (document.dataarea.EncryptionKey != null)
        {
	        encryptionKeyValue = document.dataarea.EncryptionKey.value;
		if (encryptionKeyValue == "")
	        {
		        if (errorMsg != "") errorMsg += "\n";
		        errorMsg += "<xsl:value-of select="$ErrorBlankEncryptionKey"/>";
		        errorFound = true;
	        }
		else if ((encryptionKeyValue.length % 2) == 1)
	        {
		        if (errorMsg != "")
		        {
			        errorMsg += "\n";
			}
		        errorMsg += "<xsl:value-of select="$ErrorOddEncryptionKey"/>";
		        errorFound = true;
	        }
		else
	        {
			for (charIndex = 0; charIndex &lt; encryptionKeyValue.length; charIndex++)
			{
			        if (validHexChar.indexOf(encryptionKeyValue.charAt(charIndex))== -1)
			        {
					if (errorMsg != "")
				        {
					        errorMsg += "\n";
					  }
					errorMsg += "<xsl:value-of select="$ErrorInvalidEncryptionKey"/>";
					errorFound = true;
					break;
				}
		        }
		 }
		if (errorFound == true)
		{
			alert (errorMsg);
			return false;
		}
	}
        if (vlansupport != -1)
        {
		var chkval = document.getElementById("VLANEnable").checked;
		var priority = document.getElementById("PriorityString").value;
		var lastval = "<xsl:value-of select="/OMA/EMPLANConfigObj/VLANPriority"/>";

		var minval = 0;
		var maxval = 7;

		var vlanid = document.getElementById("VLANIDString").value;
		var lastvalid = "<xsl:value-of select="EMPLANConfigObj/VLANID"/>";
		var minvalid = 1;
		var maxvalid = 4094;

		if(chkval==true){
			if(priority.indexOf(".") != -1)
			{
				alert("<xsl:value-of select="$strErrorPriority"/>");
				document.getElementById("PriorityString").value = lastval;
				document.getElementById("PriorityString").focus();
				return false;
			}
			if (document.getElementById("PriorityString").value== "" ){
				alert("<xsl:value-of select="$strPleaseSpecifyPriority"/>");
				document.getElementById("PriorityString").value = lastval;
				document.getElementById("PriorityString").focus();
				return false;
			}
		else{
			if(isNaN(priority) == true){
				alert("<xsl:value-of select="$strPriorityNumber"/>");
				document.getElementById("PriorityString").value = lastval;
				document.getElementById("PriorityString").focus();
				return false;
			}
			else if(!((tonum(priority) &gt;= minval)&amp;&amp;(tonum(priority) &lt;= maxval))){
				alert(<xsl:value-of select="$strPriorityRange"/>);
				document.getElementById("PriorityString").value = lastval;
				document.getElementById("PriorityString").focus();
				return false;
			}

		}

		if(vlanid .indexOf(".") != -1)
		{
			alert("<xsl:value-of select="$strErrorVlanID"/>");
			document.getElementById("VLANIDString").value = lastvalid;
			document.getElementById("VLANIDString").focus();
			return false;
		}
		if (document.getElementById("VLANIDString").value== "" ){
			alert("<xsl:value-of select="$strPleaseSpecifyVlanID"/>");
			document.getElementById("VLANIDString").value = lastvalid;
			document.getElementById("VLANIDString").focus();
			return false;
		}
		else{
			if(isNaN(vlanid) == true){
			alert("<xsl:value-of select="$strVlanIDNumber"/>");
			document.getElementById("VLANIDString").value = lastvalid;
			document.getElementById("VLANIDString").focus();
			return false;
		}
		else if(!((tonum(vlanid) &gt;= minvalid)&amp;&amp;(tonum(vlanid) &lt;= maxvalid))){
			alert(<xsl:value-of select="$strVlanIDRange"/>);
			document.getElementById("VLANIDString").value = lastvalid;
			document.getElementById("VLANIDString").focus();
			return false;
		}
	  }
	}
}


        if(('1' == IsIPv4Enabled) || ('255' == IsIPv4Enabled))
        {
        var tmpIPAddressBox1 = document.getElementById("IPAddressBox1").value;
        document.getElementById("IPAddressBox1").value = trim(tmpIPAddressBox1);
        var IPAddressBox1 = document.getElementById("IPAddressBox1").value;

        var tmpSubnetAddrBox1 = document.getElementById("SubnetAddrBox1").value;
        document.getElementById("SubnetAddrBox1").value = trim(tmpSubnetAddrBox1);
        var SubnetAddrBox1 = document.getElementById("SubnetAddrBox1").value;

        var tmpGatewayAddrBox1 = document.getElementById("GatewayAddrBox1").value;
        document.getElementById("GatewayAddrBox1").value = trim(tmpGatewayAddrBox1);
        var GatewayAddrBox1 = document.getElementById("GatewayAddrBox1").value;

        if(Valid_IPV4("IPAddressBox1",0,223) != true)
        {
		errorMsg += <xsl:value-of select="$strInvalidStaticIP"/>;
		invalidIP = true;
        }
        if(Valid_IPV4_Subnet("SubnetAddrBox1",0,255) != true)
        {
		errorMsg += <xsl:value-of select="$strInvalidStaticSubnet"/>;
		invalidIP = true;
        }

        if(Valid_IPV4("GatewayAddrBox1",0,223) != true)
        {
		errorMsg += <xsl:value-of select="$strInvalidStaticGateway"/>;
		invalidIP = true;
        }
      }// end of  if('1' ==IsIPv4Enabled)


        if('1' ==IsIPv6Enabled)
        {
        var tmpIPAddressIPv6 = document.getElementById("IPAddressIPv6").value;
        document.getElementById("IPAddressIPv6").value = trim(tmpIPAddressIPv6);
        var IPAddressIPv6 = document.getElementById("IPAddressIPv6").value;

        var tmpGatewayAddrIPv6 = document.getElementById("GatewayAddrIPv6").value;
        document.getElementById("GatewayAddrIPv6").value = trim(tmpGatewayAddrIPv6);
        var GatewayAddrIPv6 = document.getElementById("GatewayAddrIPv6").value;

        var tmpIPAddressPDNS = document.getElementById("IPAddressPDNS").value;
        document.getElementById("IPAddressPDNS").value = trim(tmpIPAddressPDNS);
        var IPAddressPDNS = document.getElementById("IPAddressPDNS").value;

        var tmpIPAddressBoxADNS = document.getElementById("IPAddressBoxADNS").value;
        document.getElementById("IPAddressBoxADNS").value = trim(tmpIPAddressBoxADNS);
        var IPAddressBoxADNS = document.getElementById("IPAddressBoxADNS").value;

        if(IsObjDisabled("IPAddressIPv6")==false)
        {
		var error=Valid_IPv6(IPAddressIPv6,LEVEL_IPADDRESS);
		if(error!=true)
		{
			errorMsg +="\n"+"<xsl:value-of select="$strIPv6Address"/>";
			errorMsg+=": "+Error_Codes(error);
			invalidIP=true;
		}   
		if(IsObjDisabled("EditBox1")==false)
		{	
			var lastprefixlen = "<xsl:value-of select="EMPV6LANConfigObj/IIDPrefixLength"/>";
			var prefixlen = document.getElementById("EditBox1").value;
			var minprefixlen = 1;
			var maxprefixlen = 128;

			if(!((tonum(prefixlen) &gt;= minprefixlen) &amp;&amp; (tonum(prefixlen) &lt;= maxprefixlen)))
			{
				var tmp = <xsl:value-of select="$strPrefixLenRange"/>;
				errorMsg +="\n"+tmp;
				invalidIP=true;
				document.getElementById("EditBox1").value =lastprefixlen;
				document.getElementById("EditBox1").focus();
			}
			} // End of IsObjDisabled

			var error=Valid_IPv6(GatewayAddrIPv6 ,LEVEL_GENERAL);
			if(error!=true)
		        {
				errorMsg +="\n"+"<xsl:value-of select="$strDefaultGatewayAddress"/>";
				errorMsg+=": "+Error_Codes(error);
				invalidIP=true;
			}
		}
	      if(IsObjDisabled("IPAddressPDNS")==false)
	      {
			if(IPAddressPDNS!="") 
			{ 
				var error=Valid_IPv6(IPAddressPDNS,LEVEL_GENERAL);
				if(error!=true)
				      {
					      errorMsg +="\n"+"<xsl:value-of select="$strPreferredDNSSServer"/>";
					      errorMsg+=": "+Error_Codes(error);
					      invalidIP=true;
				      }
			}
	      }
	      if(IsObjDisabled("IPAddressBoxADNS")==false)
	      {
	          if(IPAddressBoxADNS!="")
	          {
			var error=Valid_IPv6(IPAddressBoxADNS,LEVEL_GENERAL);
			if(error!=true)
			{
				errorMsg +="\n"+"<xsl:value-of select="$strAlternateDNSSServer"/>";
			        errorMsg+=": "+Error_Codes(error);
			        invalidIP=true;
		        }
			}
		}
        }//end of   if('1' ==IsIPv6Enabled)

        if (invalidIP == true)
        {
		alert(errorMsg);
		return false;
        }
        else
        {
	        return true;
        }
}//end validate function

        function trimIPAddress(ipboxname , length)
        {
        for (i =1 ; i &lt;= length ; i++) {
			var ipbox = ipboxname + i;
			try
			{
				var ipboxval = document.getElementById(ipbox).value;
				document.getElementById(ipbox).value = trim(ipboxval);
			}
			catch(e){};
		}
	}

	function ltrim ( s )
	{
		return s.replace( /^\s*/, "" )
	}

	function rtrim ( s )
	{
		return s.replace( /\s*$/, "" );
	}

	//Combine the rtrim() and ltrim() functions to make the trim() function, which just wraps both calls together:

	function trim ( s )
	{
		return rtrim(ltrim(s));
	}

	function EnableNicSettings()
	{
		document.getElementById("ipAddressSource").disabled =(!(document.getElementById("EnableNIC").checked));
		document.getElementById("IPAddressBox1").disabled  =(!(document.getElementById("EnableNIC").checked));
		document.getElementById("SubnetAddrBox1").disabled  =(!(document.getElementById("EnableNIC").checked));

		try {
		document.getElementById("VLANEnable").disabled  =(!(document.getElementById("EnableNIC").checked));
		}
		catch(e){};
		document.getElementById("MaxAuth").disabled  =(!(document.getElementById("EnableNIC").checked));
		<!--
		document.getElementById("AdmAuthMD2").disabled  =(!(document.getElementById("EnableNIC").checked));
		document.getElementById("AdmAuthMD5").disabled  =(!(document.getElementById("EnableNIC").checked));
		document.getElementById("OpAuthMD2").disabled  =(!(document.getElementById("EnableNIC").checked));
		document.getElementById("OpAuthMD5").disabled  =(!(document.getElementById("EnableNIC").checked));
		document.getElementById("UserAuthMD2").disabled  =(!(document.getElementById("EnableNIC").checked));
		document.getElementById("UserAuthMD5").disabled  =(!(document.getElementById("EnableNIC").checked));
		-->
		EnableNicDHCPSettings();
		try {
			EnableVLAN()
			//EnableVLANSettings();	
		}
		catch(e){};
		}


        function EnableVLAN()
        {
		document.getElementById("VLANIDString").disabled  =(!(document.getElementById("VLANEnable").checked) || !(document.getElementById("EnableNIC").checked));
		document.getElementById("PriorityString").disabled  =(!(document.getElementById("VLANEnable").checked) || !(document.getElementById("EnableNIC").checked));
        }

        function EnableNicDHCPSettings()
        {		
	        if(('1' == IsIPv4Enabled) || ('255' == IsIPv4Enabled))
	        {
			var bIsDHCP = !(document.getElementById("ipAddressSource").value == "1");			 
			document.getElementById("IPAddressBox1").disabled  = bIsDHCP;
			document.getElementById("SubnetAddrBox1").disabled  = bIsDHCP;
			document.getElementById("GatewayAddrBox1").disabled  = bIsDHCP;
		}
		if('1' ==IsIPv6Enabled)
		{
			var bIsAuto = !(document.getElementById("ipv6AddressSource").value == "1");
			var bIsDNSAuto = !(document.getElementById("DNS6AddressSource").value == "1");
			document.getElementById("IPAddressIPv6").disabled  = bIsAuto;
			document.getElementById("EditBox1").disabled  = bIsAuto;
			document.getElementById("GatewayAddrIPv6").disabled  = bIsAuto;

			if (!bIsAuto)
			{
				DisableDNSSource();
				bIsDNSAuto=false;
			}
			document.getElementById("IPAddressPDNS").disabled  = bIsDNSAuto;
			document.getElementById("IPAddressBoxADNS").disabled  = bIsDNSAuto;
		}// end of if('1' ==IsIPv4Enabled)

        }// end of function

        function DisableDNSSource()
        {
		document.getElementById("DNS6AddressSource").selectedIndex=0;
		document.getElementById("DNS6AddressSource").disabled=true;
        }

        function EnableIPV6Settings()
        {
		var bIsAuto = !(document.getElementById("ipv6AddressSource").value == "1");

		document.getElementById("IPAddressIPv6").disabled  = bIsAuto;
		document.getElementById("GatewayAddrIPv6").disabled  = bIsAuto;
		document.getElementById("EditBox1").disabled  = bIsAuto;
		if(true == bIsAuto)
		{
			document.getElementById("DNS6AddressSource").disabled=false;
		}
		else
		{
			DisableDNSSource();
			document.getElementById("IPAddressPDNS").disabled  = false;
			document.getElementById("IPAddressBoxADNS").disabled  = false;
		}
	}

        function EnableDNSV6Settings()
        {
		var bIsDNSAuto = !(document.getElementById("DNS6AddressSource").value == "1");
		document.getElementById("IPAddressPDNS").disabled  =bIsDNSAuto;
		document.getElementById("IPAddressBoxADNS").disabled  =bIsDNSAuto;
        }

	function EnableVLANSettings()
        {
		 if (vlansupport != -1)
		 {
			if(document.dataarea.VLANEnable != null)
			{
				if (document.getElementById("VLANEnable").checked)
				{
					document.dataarea.VLANIDString.disabled = false;			
					document.dataarea.PriorityString.disabled = false;
				}
				else
				{
					document.dataarea.VLANIDString.disabled = true;			
					document.dataarea.PriorityString.disabled = true;
					
				}
			}
		}
	  }

        function Compare_Strings(str1, str2)
        {
		ret_val = true;
		if(str1.length != str2.length)
		return false;

	        for (var i = 0; i &lt;= str1.length; i++)
		{
			curChar1 = str1.charCodeAt(i);
			curChar2 = str2.charCodeAt(i);
		if ( curChar1 == curChar2)
			{
				continue;
			}
		else
			{
			ret_val = false;
			break;
			}
		}
		return ret_val;
	}

	function Valid_Number(value, exact, min, max)
	{
		var nASCII_0 = 48;
		var nASCII_9 = 57;

		if (exact != -1 &amp;&amp; value != exact)
			return false;
		else if (exact != -1 &amp;&amp; value == exact)
			return true;

		if (value == null || value == "")
			return false;
		var str = new String(value);
		for (var i = 0; i &lt; str.length; i++)
		{
			if (str.charCodeAt(i) &lt; nASCII_0 || str.charCodeAt(i) &gt; nASCII_9)
			return false;
		}

		if (Math.floor(str) &lt; Math.floor(min) || Math.floor(str) &gt; Math.floor(max))
			return false;
		else
			return true;
	}

	function Valid_IPV4(objstr,min,max)
	{
	var nASCII_0 = 48;
	var nASCII_9 = 57;
	var nASCII_dot = 46;
	var curNumber = "";
	var iCount = 0;
	var jCount = 0;
	var limitedMask = 255;
	var str = document.getElementById(objstr).value;
	var tempstr = eval("document.dataarea." + objstr);
	if (tempstr.disabled == true)
		return true;
	if(str.length == 0 || str == "")
		return false;

	if (Compare_Strings(str, '0.0.0.0'))
		return false;

	if (Compare_Strings(str, '255.255.255.255'))
		return false;

	for (var i = 0; i &lt; str.length; i++)
	{
	curChar = str.charCodeAt(i);
	curNum = str.charAt(i);
	if (curChar == nASCII_dot)
	{
		iCount++;
		jCount = 0;
		if (iCount == 1)
		{
			if (curNumber &lt; 1 || curNumber == 127)
				return false;
			ret_code = Valid_Number(curNumber,-1,min,max);
		}
		else
			ret_code = Valid_Number(curNumber,-1,min,limitedMask);

		if (ret_code != 1)
			return false;
		curNumber = "";
		continue;
		}
		else if (curChar &gt;= nASCII_0 &amp;&amp; curChar &lt;= nASCII_9 &amp;&amp; jCount &lt;= 3)
		{
			jCount++;
			curNumber += curNum;
		}
		else
		{
			return false;
		}
	}

	ret_code = Valid_Number(curNumber,-1,min,limitedMask);
	if (ret_code != 1)
		return false;
	if (iCount != 3)
		return false;
return true;
}
	function Valid_SubnetOctet(value)
	{
		if ((value == 0) || (value == 128) || (value == 192)
		       || (value == 224) || (value == 240) || (value==248) || (value ==252)
			|| (value == 254))
			   	  return true;
		else
			return false;
	}

	function Valid_IPV4_Subnet(objstr,min,max)
	{
	    var nASCII_0 = 48;
	    var nASCII_9 = 57;
	    var nASCII_dot = 46;
	    var curNumber = "";
	    var iCount = 0;
	    var jCount = 0;
	    var limitedMask = 255;
	    var octet0 = 0;
	    var octet1 = 0;
	    var octet2 = 0;
	    var octet3 = 0;
	    var str = document.getElementById(objstr).value;

	    var tempstr = eval("document.dataarea." + objstr);
	    if (tempstr.disabled == true)
		return true;

	    if(str.length == 0 || str == "")
		return false;

	    if (Compare_Strings(str, '0.0.0.0'))
		return false;

	    if (Compare_Strings(str, '255.255.255.255'))
	       return false;

	    for (var i = 0; i &lt; str.length; i++)
	    {
		curChar = str.charCodeAt(i);
		curNum = str.charAt(i);
		if (curChar == nASCII_dot)
		{

		    iCount++;
		    jCount = 0;

		    ret_code = Valid_Number(curNumber,-1,min,limitedMask);
		    if (ret_code != 1)
			return false;

		    if (iCount == 1)
			octet0 = curNumber;
		    else if (iCount == 2)
			octet1 = curNumber;
		    else if (iCount == 3)
			octet2 = curNumber;
		    else
			return false;

		    curNumber = "";
		    continue;
		}
	      else if (curChar &gt;= nASCII_0 &amp;&amp;  curChar &lt;= nASCII_9 &amp;&amp; jCount &lt;=3)
	      {
		    jCount++;
		    curNumber += curNum;
	      }
	      else
	      {
		    return false;
	      }
	}
	  octet3 = curNumber;
	  ret_code = Valid_Number(curNumber,-1,min,limitedMask);
	  if (ret_code != 1)
		return false;

	  if (iCount != 3)
		return false;

	if( octet0 == 255 &amp;&amp; octet1 == 255 &amp;&amp; octet2 == 255 )
	  {
	    if(Valid_SubnetOctet(octet3) == true)
		{
			return true;
		}

	  }
	  else if( octet0 == 255 &amp;&amp; octet1 == 255 )
	  {
	    if( Valid_SubnetOctet(octet2 ) &amp;&amp;  octet3 == 0 )
		{
			return true;
		}
	  }
	else if( octet0 == 255 )
	  {
	    if( Valid_SubnetOctet(octet1 ) &amp;&amp;  octet2 == 0 &amp;&amp;  octet3 == 0)
		{
			return true;
		}
	  }
	else if( Valid_SubnetOctet(octet0 ) &amp;&amp;  octet1 == 0 &amp;&amp;   octet2 == 0 &amp;&amp;	octet3 == 0 )
	  {
		return true;
	  }
	  return false;
	}
	
	
	function changeFailoverOptions(){
			
		document.dataarea.failoverNic.selectedIndex =0;
		if(document.dataarea.primaryNic.value==1){		
			document.dataarea.failoverNic.disabled=true;
		}else{	
			document.dataarea.failoverNic.disabled=false;
			var len = document.dataarea.failoverNicBack.options.length;
			document.dataarea.failoverNic.options.length=0;			
			for(var i=0; i &lt; len; i++){
				if(document.dataarea.failoverNicBack.options[i].value != document.dataarea.primaryNic.value)
				{					
					var option;  
					option = document.createElement("option");  
					option.innerHTML =document.dataarea.failoverNicBack.options[i].text;  
					option.setAttribute("value", document.dataarea.failoverNicBack.options[i].value);
					document.dataarea.failoverNic.appendChild(option);						
				}					
			}
		}	
	}
	
	function setFailoverNicBack(){
	
		if(document.dataarea.failoverNic != null){
			var len = document.dataarea.failoverNic.options.length;
			var failoverNicBack = document.createElement("select");
			document.getElementById("dataarea").appendChild(failoverNicBack);
	
			failoverNicBack.setAttribute("name", "failoverNicBack");   
			failoverNicBack.setAttribute("id", "failoverNicBack");		
			
			for(var i=0;i &lt; len;i++){
	
				var option;  
				option = document.createElement("option");  
				option.innerHTML =document.dataarea.failoverNic.options[i].text;  
				option.setAttribute("value", document.dataarea.failoverNic.options[i].value);
				failoverNicBack.appendChild(option);
			}
			document.getElementById("failoverNicBack").style.visibility="hidden";
			
			//remove the primary NIC option selected from the list of options of Failover NIC
			var len = document.dataarea.failoverNicBack.options.length;			
			for(var i=0; i &lt; len; i++){
				 if(document.dataarea.failoverNicBack.options[i].value == document.dataarea.primaryNic.value)
				 	document.dataarea.failoverNic.remove(i);
			}
			if(document.dataarea.primaryNic.value == 1)
				document.dataarea.failoverNic.disabled=true;
		}				
	}
	
	
	</script>
	</DataArea>
</xsl:template>

<xsl:template match="EMPNICConfigObj">
	 <xsl:choose>
	 <xsl:when test="separatePrimaryFailover='1'">
	 <Data width="200" name="primaryNic" type="select" editable="true" event="onChange" handler="javascript:changeFailoverOptions()">
		<xsl:attribute name="display"><xsl:value-of select="$strPrimaryNic"/></xsl:attribute>
	 		<xsl:if test="primaryCapabilities/NIC1Only='true'">
	 	 		<Choice returnvalue="2">
	 	 			<xsl:attribute name="value"><xsl:value-of select="$primaryFailoverNicSelection1"/></xsl:attribute>
	 	 			<xsl:if test="primarySettings='2'">
	 	 				<xsl:attribute name="default">true</xsl:attribute>
	 	 			</xsl:if>
	 	 		</Choice>
	 	 	</xsl:if>
	 	 	<xsl:if test="primaryCapabilities/NIC2Only='true'">
	 	 		<Choice returnvalue="3">
	 	 			<xsl:attribute name="value"><xsl:value-of select="$primaryFailoverNicSelection2"/></xsl:attribute>
	 	 			<xsl:if test="primarySettings='3'">
						<xsl:attribute name="default">true</xsl:attribute>
	 	 			</xsl:if>
	 	 		</Choice>
	 	 	</xsl:if>
	 	 	<xsl:if test="primaryCapabilities/NIC3Only='true'">
				<Choice returnvalue="4">
				 	 <xsl:attribute name="value"><xsl:value-of select="$primaryFailoverNicSelection3"/></xsl:attribute>
				 	 <xsl:if test="primarySettings='4'">
						<xsl:attribute name="default">true</xsl:attribute>
				 	 </xsl:if>
				 </Choice>
	 	 	</xsl:if>
	 	 	<xsl:if test="primaryCapabilities/NIC4Only='true'">
				<Choice returnvalue="5">
					<xsl:attribute name="value"><xsl:value-of select="$primaryFailoverNicSelection4"/></xsl:attribute>
					<xsl:if test="primarySettings='5'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
	 	 	</xsl:if>	 	 			
	 	 	<xsl:if test="primaryCapabilities/Dedicated='true'">
				<Choice returnvalue="1">
				 	 <xsl:attribute name="value"><xsl:value-of select="$primaryFailoverNicSelection5"/></xsl:attribute>
					 <xsl:if test="primarySettings='1'">
					 	<xsl:attribute name="default">true</xsl:attribute>
				 	 </xsl:if>
				 </Choice>
	 		</xsl:if> 	 
	    </Data>
	    <Data width="200" name="failoverNic" type="select" editable="true">
	    	<xsl:attribute name="display"><xsl:value-of select="$strFailoverNic"/></xsl:attribute>
	    			<Choice returnvalue="0">
					<xsl:attribute name="value"><xsl:value-of select="$strNone"/></xsl:attribute>
					<xsl:if test="failoverSettings='0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
	    	 	 <xsl:if test="failoverCapabilities/NIC1Only='true'">
	    	 	 	<Choice returnvalue="2">
	    	 	 		<xsl:attribute name="value"><xsl:value-of select="$primaryFailoverNicSelection1"/></xsl:attribute>
	    	 	 		<xsl:if test="failoverSettings='2'">
	    	 	 			<xsl:attribute name="default">true</xsl:attribute>
	    	 	 		</xsl:if>
	    	 	 	</Choice>
	    	 	 </xsl:if>
	    	 	 <xsl:if test="failoverCapabilities/NIC2Only='true'">
	    	 	 	<Choice returnvalue="3">
	    	 	 		<xsl:attribute name="value"><xsl:value-of select="$primaryFailoverNicSelection2"/></xsl:attribute>
	    	 	 		<xsl:if test="failoverSettings='3'">
	    					<xsl:attribute name="default">true</xsl:attribute>
	    	 	 		</xsl:if>
	    	 	 	</Choice>
	    	 	 </xsl:if>
	    	 	 <xsl:if test="failoverCapabilities/NIC3Only='true'">
				<Choice returnvalue="4">
					<xsl:attribute name="value"><xsl:value-of select="$primaryFailoverNicSelection3"/></xsl:attribute>
					<xsl:if test="failoverSettings='4'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
	    	 	 </xsl:if>
	    	 	 <xsl:if test="failoverCapabilities/NIC4Only='true'">
				<Choice returnvalue="5">
					<xsl:attribute name="value"><xsl:value-of select="$primaryFailoverNicSelection4"/></xsl:attribute>
					<xsl:if test="failoverSettings='5'">
						<xsl:attribute name="default">true</xsl:attribute>
	 	 			</xsl:if>
				</Choice>
	    	 	 </xsl:if>
	    	 	 <xsl:if test="failoverCapabilities/NICRecieveOnAll='true'">
				<Choice returnvalue="6">
					<xsl:attribute name="value"><xsl:value-of select="$primaryFailoverNicSelection6"/></xsl:attribute>
					<xsl:if test="failoverSettings='6'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</xsl:if>
	 </Data>
	    
	 </xsl:when>
	 <xsl:otherwise>
	 <Data width="200" name="NicSelection" type="select" editable="true">
	 		    <xsl:attribute name="display"><xsl:value-of select="$strNicSelection"/></xsl:attribute>
	 	   		<xsl:if test="teamingModeCapabilities/NIC1Only='true'">
	 			<Choice returnvalue="1">
	 				<xsl:attribute name="value"><xsl:value-of select="$strNicSelection1"/></xsl:attribute>
	 				<xsl:if test="teamingModeSettings/NIC1Only='true'">
	 					<xsl:attribute name="default">true</xsl:attribute>
	 				</xsl:if>
	 			</Choice>
	 		    </xsl:if>
	 		<xsl:if test="teamingModeCapabilities/NIC1TeamedNIC2='true'">
	 			<Choice returnvalue="3">
	 				<xsl:attribute name="value"><xsl:value-of select="$strNicSelection3"/></xsl:attribute>
	 				<xsl:if test="teamingModeSettings/NIC1TeamedNIC2='true'">
	 					<xsl:attribute name="default">true</xsl:attribute>
	 				</xsl:if>
	 			</Choice>
	 			</xsl:if>
	 		<xsl:if test="teamingModeCapabilities/Dedicated='true'">
	 			<Choice returnvalue="4">
	 				<xsl:attribute name="value"><xsl:value-of select="$strNicSelection4"/></xsl:attribute>
	 				<xsl:if test="teamingModeSettings/Dedicated='true'">
	 					<xsl:attribute name="default">true</xsl:attribute>
	 				    </xsl:if>
	 			</Choice>
	 			</xsl:if>
	 
	 			<xsl:if test="teamingModeCapabilities/NICRecieveOnAll='true'">
	 			<Choice returnvalue="5">
	 				<xsl:attribute name="value"><xsl:value-of select="$strNicSelection5"/></xsl:attribute>
	 				<xsl:if test="teamingModeSettings/NICRecieveOnAll='true'">
	 					<xsl:attribute name="default">true</xsl:attribute>
	 				</xsl:if>
	 			</Choice>
	 		</xsl:if>
	 
	    </Data>
	 </xsl:otherwise>
	 </xsl:choose>

</xsl:template>

<xsl:template match="EMPLANConfigObj">
<xsl:param name="bIsIPTable">false</xsl:param>
	<xsl:if test="$bIsIPTable!='true'">
	
	    <Data>
		<xsl:attribute name="display"><xsl:value-of select="$strMACAddress"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="MACAddress"/></xsl:attribute>
	    </Data>

		<Data name="EnableNIC" type="checkbox" editable="true" align="left">
				<xsl:attribute name="display"><xsl:value-of select="$strEnableLAN"/></xsl:attribute>						
         <xsl:if test="IPMIMessagingAccessMode ='2'">
          <xsl:attribute name="state">1</xsl:attribute>
          </xsl:if>
			</Data>

	</xsl:if>
	<xsl:if test="$bIsIPTable='true'">
    <Data name="ipAddressSource" type="select" editable="true" event="onChange" handler="javascript:EnableNicDHCPSettings()">
				<xsl:attribute name="display"><xsl:value-of select="$strIPAddressSource"/></xsl:attribute>		
				<xsl:if test="IPAddrSourceSupport/Unspecified='true'">
				<Choice returnvalue="0">
				 <xsl:attribute name="value"><xsl:value-of select="$strNone"/></xsl:attribute>
					<xsl:if test="IPAddrSource=0">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				</xsl:if>
				<xsl:if test="IPAddrSourceSupport/Static='true'">
				<Choice returnvalue="1">				
					<xsl:attribute name="value"><xsl:value-of select="$strStaticAddress"/></xsl:attribute>
					<xsl:if test="IPAddrSource!=2">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				</xsl:if>
				<xsl:if test="IPAddrSourceSupport/DHCP='true'">
				<Choice returnvalue="2">				
					<xsl:attribute name="value"><xsl:value-of select="$strAddressobtainedby"/></xsl:attribute>
					<xsl:if test="IPAddrSource=2">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				</xsl:if>
				<xsl:if test="IPAddrSourceSupport/BIOS='true'">
				<Choice returnvalue="3">			
					<xsl:attribute name="value"><xsl:value-of select="$strBIOS"/></xsl:attribute>
					<xsl:if test="IPAddrSource=3">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				</xsl:if>
			</Data>


  
      <xsl:call-template name="ShowIPV4AddrBox">
        <xsl:with-param name="Address">
          <xsl:value-of select="IPAddress"/>
        </xsl:with-param>
        <xsl:with-param name="IPCtrlName">IPAddressBox1</xsl:with-param>
        <xsl:with-param name="DisplayStr">
          <xsl:value-of select="$strStaticIPAddress"/>
        </xsl:with-param>
      </xsl:call-template>
     
      <xsl:call-template name="ShowIPV4AddrBox">
        <xsl:with-param name="Address">
          <xsl:value-of select="SubnetMask"/>
        </xsl:with-param>
        <xsl:with-param name="IPCtrlName">SubnetAddrBox1</xsl:with-param>
        <xsl:with-param name="DisplayStr">
          <xsl:value-of select="$strStaticSubnetMask"/>
        </xsl:with-param>
      </xsl:call-template>
   
      <xsl:call-template name="ShowIPV4AddrBox">
        <xsl:with-param name="Address">
          <xsl:value-of select="DefaultGateway"/>
        </xsl:with-param>
        <xsl:with-param name="IPCtrlName">GatewayAddrBox1</xsl:with-param>
        <xsl:with-param name="DisplayStr">
          <xsl:value-of select="$strStaticGatewayAddress"/>
        </xsl:with-param>
      </xsl:call-template>
     
  </xsl:if>
  <!--Row>
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strCommunityString"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strCommunityString"/></xsl:attribute>
			</Data>
			<Data name="CommunityString" type="editbox" editable="true">
					<xsl:attribute name="maxlength">18</xsl:attribute>
					<xsl:attribute name="display"><xsl:value-of select="CommunityString"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="CommunityString"/></xsl:attribute>
			</Data>
		</Row-->
		<xsl:if test="$bIsIPTable!='true'">
				
			<Data name="MaxAuth" type="select" editable="true" width="200">
				<xsl:attribute name="display"><xsl:value-of select="$strMaximumUserPrivileges"/></xsl:attribute>
		
				<Choice returnvalue="4">
					<xsl:attribute name="value"><xsl:value-of select="$strAdministrator"/></xsl:attribute>
					<xsl:if test="channelAccessLevel=4">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="3">
					<xsl:attribute name="value"><xsl:value-of select="$strOperator"/></xsl:attribute>
					<xsl:if test="channelAccessLevel=3">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>

				<Choice returnvalue="2">
					<xsl:attribute name="value"><xsl:value-of select="$strUser"/></xsl:attribute>
					<xsl:if test="channelAccessLevel=2">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>

	</xsl:if>
</xsl:template>

<xsl:template match="EMPV6LANConfigObj">
  <Data name="ipv6AddressSource" type="select" editable="true" event="onChange" handler="javascript:EnableIPV6Settings()">
			<xsl:attribute name="display"><xsl:value-of select="$strIPAddressSource"/></xsl:attribute>
			
		
				<Choice returnvalue="1">
					
 					<xsl:attribute name="value"><xsl:value-of select="$strStaticAddress"/></xsl:attribute>
					<xsl:if test="ipv6AddrConfiguration='0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
				<Choice returnvalue="2">
				
 					<xsl:attribute name="value"><xsl:value-of select="$strAutoAddress"/></xsl:attribute>
					<xsl:if test="ipv6AddrConfiguration='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
	
	
		<xsl:call-template name="ShowIPV6AddrBox">
			<xsl:with-param name="Address"><xsl:value-of select="GLAddress"/></xsl:with-param>
			<xsl:with-param name="IPCtrlName">IPAddressIPv6</xsl:with-param>
			<xsl:with-param name="DisplayStr"><xsl:value-of select="$strStaticIPAddress"/></xsl:with-param>
		</xsl:call-template>
	

		<xsl:call-template name="ShowIPAddrBox">
			<xsl:with-param name="Address">
				<xsl:value-of select="IIDPrefixLength"/>
			</xsl:with-param>
			<xsl:with-param name="IPCtrlName">EditBox1</xsl:with-param>
			<xsl:with-param name="DisplayStr"><xsl:value-of select="$strPrefixLength"/></xsl:with-param>
			<xsl:with-param name="Size">1</xsl:with-param>
		</xsl:call-template>
	
		<xsl:call-template name="ShowIPV6AddrBox">
			<xsl:with-param name="Address">
				<xsl:value-of select="GatewayAddress"/>
			</xsl:with-param>
			<xsl:with-param name="IPCtrlName">GatewayAddrIPv6</xsl:with-param>
			<xsl:with-param name="DisplayStr"><xsl:value-of select="$strDefaultGatewayAddress"/></xsl:with-param>
		</xsl:call-template>


  <Data name="DNS6AddressSource" type="select" editable="true" event="onChange" handler="javascript:EnableDNSV6Settings()">
			<xsl:attribute name="display"><xsl:value-of select="$strDNSAddressSource"/></xsl:attribute>
			<Choice returnvalue="1">
				
					<xsl:attribute name="value"><xsl:value-of select="$strStaticAddress"/></xsl:attribute>
					<xsl:if test="ipv6DNSConfiguration='0'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			 <Choice returnvalue="2">
				
					<xsl:attribute name="value"><xsl:value-of select="$strAutoAddress"/></xsl:attribute>
					<xsl:if test="ipv6DNSConfiguration='1'">
						<xsl:attribute name="default">true</xsl:attribute>
					</xsl:if>
				</Choice>
			</Data>
	

		<xsl:call-template name="ShowIPV6AddrBox">
			<xsl:with-param name="Address">
				<xsl:value-of select="DNS1Address"/>
			</xsl:with-param>
			<xsl:with-param name="IPCtrlName">IPAddressPDNS</xsl:with-param>
			<xsl:with-param name="DisplayStr"><xsl:value-of select="$strPreferredDNSSServer"/></xsl:with-param>
		</xsl:call-template>

		<xsl:call-template name="ShowIPV6AddrBox">
			<xsl:with-param name="Address">
				<xsl:value-of select="DNS2Address"/>
			</xsl:with-param>
			<xsl:with-param name="IPCtrlName">IPAddressBoxADNS</xsl:with-param>
			<xsl:with-param name="DisplayStr"><xsl:value-of select="$strAlternateDNSSServer"/></xsl:with-param>
		</xsl:call-template>
	

</xsl:template>


	<xsl:template match="EMPRACObj">
		
		<Data name="enableRACnic" type="checkbox" editable="true" align="left">
			        <xsl:attribute name="display"><xsl:value-of select="$strEnableNIC"/></xsl:attribute>
			         <xsl:if test="nicEnable ='true'">
                  <xsl:attribute name="state">1</xsl:attribute>
                </xsl:if>
              
			</Data>
		
	</xsl:template>

    <xsl:template match="EMPChSecKeyListObj">
        <xsl:if test="/OMA/OMAUserRights='7'">
            <xsl:for-each select="keyListarray/keyList">
                <xsl:if test="keyID='1'">
                   
	                    <Data editable="true" name="EncryptionKey" type="editbox" size="58" maxlength="40">
		                    <xsl:attribute name="display"><xsl:value-of select="$strEncryptionKey"/></xsl:attribute>	                 
		                    <xsl:attribute name="value"><xsl:value-of select="KeyValue"/></xsl:attribute>
	                    </Data>
                   
                </xsl:if>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>

<xsl:template name="ShowIPV4AddrBox">
	<xsl:param name="Address"/>
	<xsl:param name="IPCtrlName"/>
	<xsl:param name="DisplayStr"/>
	<xsl:call-template name="ShowIPAddrBox">
		<xsl:with-param name="Address"><xsl:value-of select="$Address"/></xsl:with-param>
		<xsl:with-param name="IPCtrlName"><xsl:value-of select="$IPCtrlName"/></xsl:with-param>
		<xsl:with-param name="DisplayStr"><xsl:value-of select="$DisplayStr"/></xsl:with-param>
		<xsl:with-param name="Size">12</xsl:with-param>
	</xsl:call-template>
</xsl:template>

<xsl:template name="ShowIPV6AddrBox">
	<xsl:param name="Address"/>
	<xsl:param name="IPCtrlName"/>
	<xsl:param name="DisplayStr"/>
	<xsl:call-template name="ShowIPAddrBox">
		<xsl:with-param name="Address"><xsl:value-of select="$Address"/></xsl:with-param>
		<xsl:with-param name="IPCtrlName"><xsl:value-of select="$IPCtrlName"/></xsl:with-param>
		<xsl:with-param name="DisplayStr"><xsl:value-of select="$DisplayStr"/></xsl:with-param>
		<xsl:with-param name="Size">38</xsl:with-param>
	</xsl:call-template>
</xsl:template>

<xsl:template name="ShowIPAddrBox">
	<xsl:param name="Address"/>
	<xsl:param name="IPCtrlName"/>
	<xsl:param name="DisplayStr"/>
	<xsl:param name="Size"/>
 	<Data type="editbox" editable="true">
		<xsl:attribute name="display"><xsl:value-of select="$DisplayStr"/></xsl:attribute>	
		<xsl:attribute name="name"><xsl:value-of select="$IPCtrlName"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="$Address"/></xsl:attribute>
		<xsl:attribute name="size"><xsl:value-of select="$Size"/></xsl:attribute>
	</Data>
</xsl:template>

<xsl:template name="chkIPValue">
	<xsl:param name="IPAddress1"/>
		<xsl:value-of select="$IPAddress1"/>
</xsl:template>

</xsl:stylesheet>
