<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<!-- including globals for CLI. GUI automatically loads globals.xsl -->
	<xsl:include href="../en/globals.xsl"/>
	<xsl:strip-space elements="*"/>
	<xsl:output method="xml" indent="no"/>
<xsl:variable name="CallingFromCLI">
 <xsl:choose>
      <xsl:when test="/OMA/@cli">true</xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
 </xsl:variable>

 <xsl:variable name="IsiDRAC8Present">
    <xsl:choose>
      <xsl:when test="/OMA/EMPObj/type = '32' or /OMA/EMPObj/type = '33' or /OMA/EMPObj/type = '34' ">true</xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
 </xsl:variable>
 
 <xsl:variable name="IsiDRAC7Present">
    <xsl:choose>
      <xsl:when test="/OMA/EMPObj/type = '16' or /OMA/EMPObj/type = '17' ">true</xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
 </xsl:variable>

 <xsl:variable name="IsiDRAC6Present"> <!--iDRAC Ent or Exp-->
    <xsl:choose>
      <xsl:when test="/OMA/EMPObj/type = '10' or /OMA/EMPObj/type = '11' ">true</xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="IsiDRACPresent"> <!--iDRAC on Blade-->
    <xsl:choose>
      <xsl:when test="/OMA/EMPObj/type = '8' ">true</xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>	


	<xsl:template match="OMA">
	<DataArea>
	<xsl:choose>
	<xsl:when test="SMStatus = '4308' or SMStatus = '212' ">
		<script language="javascript">			 		
		var value = <xsl:value-of select="SMStatus" />;
		document.location.href=top.gnv.appendVID('./DataArea?plugin=com.dell.oma.webplugins.FailureWebPlugin&amp;SMStatus=' + value+'&amp;caller='+document.location.href);
		</script>
	</xsl:when>
	</xsl:choose>
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
		

 			<PageTitle><xsl:attribute name="display"><xsl:value-of select="$strRemoteAccessInformation"/></xsl:attribute></PageTitle>
			<xsl:if test="EMPObj/defaultRestoreStatus = '0'">
				<xsl:if test="EMPObj/defaultRestoreSupport = '1'">
				<xsl:choose>
					<xsl:when test = "/OMA/@cli = 'true'">
						<PromptText><xsl:value-of select ="$gstrResetToDefaultCli"/></PromptText>
					</xsl:when>
					<xsl:otherwise>
							<PromptText><xsl:value-of select="$gstrResetToDefault"/></PromptText>
					</xsl:otherwise>
				</xsl:choose>	
				</xsl:if>
			</xsl:if>

			<xsl:choose>
				<xsl:when test="EMPObj/type='13'">	<!--MASERLite-->
					<PromptText><xsl:value-of select="$strUpgradeMaser"/></PromptText> <!--Upgrade to iDRAC Express-->
					<PromptText><xsl:value-of select="$strUpgradeAMEA"/></PromptText> <!--Upgrade to iDRAC Enterprise-->
				</xsl:when>
				<xsl:when test="(EMPObj/type='10' or EMPObj/type='11') and /OMA/MaserDeviceInfo/type != '1' ">	<!--MASER with no AMEA-->
					<PromptText><xsl:value-of select="$strUpgradeAMEA"/></PromptText>
				</xsl:when>
				<xsl:when test="(EMPObj/type='10' or EMPObj/type='11') and count(/OMA/MaserDeviceInfo) = '0' ">	<!--MASER with no AMEA--><!--It happens only on value line servers-->
					<PromptText><xsl:value-of select="$strUpgradeAMEA"/></PromptText>
				</xsl:when>
				
			</xsl:choose>

			<!--xsl:choose>
			<xsl:when test="EMPObj/defaultRestoreStatus = '0'"-->
			<!--TableData columnspacing="true">
				<Row>
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$HIPLSTR_strResetToDefault"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="$HIPLSTR_strResetToDefault"/></xsl:attribute>
					</Data>
				</Row>
			</TableData-->
			<!--/xsl:when>
			<xsl:otherwise-->
					<CustomButton>
						<Data name="Refresh"><xsl:attribute name="display"><xsl:value-of select="$strRefresh"/></xsl:attribute>
							<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.BMCViewWebPlugin&amp;help=RemoteAccess</xsl:attribute>
						</Data>
					</CustomButton>
					
					<xsl:if test="$usrights='7'">
					<CustomButton align="left">
						<!--Data name="adv"><xsl:attribute name="display"><xsl:value-of select="$strReset"/></xsl:attribute>
							<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.BMCViewWebPlugin&amp;action=reset</xsl:attribute>
						</Data-->
						<Data name="reset" id="custombutton_resetid">
							<xsl:attribute name="display"><xsl:value-of select="$strReset"/></xsl:attribute>
							<xsl:attribute name="href">javascript:reset()</xsl:attribute>
							<xsl:attribute name="formSubmit">true</xsl:attribute>
						</Data>

					</CustomButton>
					<script language="javascript">
					function reset()
					{
						if (confirm("<xsl:value-of select="$strResetToDefault"/>"))
            {
            // disable the link after the first click.
            var originallink = document.getElementById("custombutton_resetid").href;
            document.getElementById("custombutton_resetid").href = "#" + originallink;
            if (originallink.charAt(0) != '#')
            {
            document.getElementById("dataarea").action=top.gnv.appendVID('./DataArea?plugin=com.dell.hip.webplugins.BMCViewWebPlugin&amp;action=reset');
				   		        document.getElementById("dataarea").submit();
				   		    }
						}
					}
					</script>
					</xsl:if>
		<ListData name="BMC" type="custom">	          
        <xsl:attribute name="display"><xsl:value-of select="$gstrRemoteAccessDevice"/></xsl:attribute>
		    <Header>
          <Data>
            <xsl:attribute name="display"><xsl:value-of select="$gstrRemoteAccessDevice"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$gstrRemoteAccessDevice"/></xsl:attribute>         
           </Data>
	       </Header>
					 <xsl:apply-templates select="EMPObj"/>
						<xsl:apply-templates select="EMPLANConfigObj">
							<xsl:with-param name="bIsIPTable">false</xsl:with-param>
						</xsl:apply-templates>
				</ListData>
      <xsl:if test="EMPObj/ipv4State= '1' or EMPObj/ipv4State= '255'  " >
        <ListData name="IPv4Address" type="custom">
          <xsl:attribute name="display"><xsl:value-of select="$strIPv4Address"/></xsl:attribute>
          <Header>
            <Data>
            <xsl:attribute name="display"><xsl:value-of select="$strIPv4Address"/></xsl:attribute>
            <xsl:attribute name="value"><xsl:value-of select="$strIPv4Address"/></xsl:attribute>
              </Data>
          </Header>
           <xsl:apply-templates select="EMPLANConfigObj">
            <xsl:with-param name="bIsIPTable">true</xsl:with-param>
          </xsl:apply-templates>
        </ListData>
      </xsl:if>
        <xsl:if test="EMPV6LANConfigObj/ipv6State='1'" >
				<ListData type="custom"  name="IPv6Address">
					<xsl:attribute name="display">
						<xsl:value-of select="$strIPv6Address"/>
					</xsl:attribute>

					<Header value="IPv6Address Sub">
            <Data>
              <xsl:attribute name="display"><xsl:value-of select="$strIPv6Address"/></xsl:attribute>
              <xsl:attribute name="value"><xsl:value-of select="$strIPv6Address"/></xsl:attribute>
              </Data>
					</Header>
				
					<xsl:apply-templates select="EMPV6LANConfigObj"/>
				</ListData>
				</xsl:if>
        
				<xsl:if test="DRSCSummaryObj">
          <ListData name="RAC" type="custom">
            <xsl:attribute name="display"><xsl:value-of select="$strDRAC"/></xsl:attribute>
						<Header>
              <Data>
							<xsl:attribute name="display"><xsl:value-of select="$strDRAC"/></xsl:attribute>
              <xsl:attribute name="value"><xsl:value-of select="$strDRAC"/></xsl:attribute>
              </Data>
						</Header>

					
						<xsl:apply-templates select="DRSCSummaryObj"/>
						<xsl:apply-templates select="RemoteHostObj"/>
					</ListData>
					<script language="javascript">
						function loadOOB(drac_version)
						{
     						var drsHttpsPort = '<xsl:value-of select="DRSCSummaryObj/Drac3Obj/drsHttpsPort"/>';
							var drsIpAddr = '<xsl:value-of 	select="DRSCSummaryObj/CurrentLanNetworkingObj/NicCurrentIpAddress"/>';

							if (drac_version == 6)
							{
								//DRAC5
								window.open('https://' + drsIpAddr + ':' + drsHttpsPort);
							}
							else
							{
							//DRAC4 and previous DRAC versions
							window.open('https://' + drsIpAddr + ':' + drsHttpsPort + '/cgi/authentication');
							}
						}
				</script>
                    </xsl:if>


			<!--/xsl:otherwise>
			</xsl:choose-->
			<script language="javascript">
				var rci=null;
			       function loadIMC(url)
				{
				 if ((rci == null) || (rci.closed) ||(typeof(rci) == 'undefined'))
					rci = window.open ("", "rci"); 

				  rci.location.href = url;
				  rci.focus();
				}
		      </script>

		</DataArea>
</xsl:template>
<xsl:template match="EMPObj">

	<Data>
		  <xsl:attribute name="display"><xsl:value-of select="$strDeviceType"/></xsl:attribute>
	
	          <xsl:choose>	
			<xsl:when test="type='32' or type='33' or type='34' ">		  	
			<xsl:choose>
				<xsl:when test="/OMA/EMPObj/licenseClass='5' or /OMA/EMPObj/licenseClass='3' or /OMA/EMPObj/licenseClass='1' or /OMA/EMPObj/licenseClass='0'">
					<xsl:attribute name="value"><xsl:value-of select="$gstrIDRAC8Exp"/></xsl:attribute>					    
				</xsl:when>
				<xsl:when test="/OMA/EMPObj/licenseClass='4'">
					<xsl:attribute name="value"><xsl:value-of select="$gstrIDRAC8Ent"/></xsl:attribute>	    					   
				</xsl:when>
				<xsl:when test="/OMA/EMPObj/licenseClass='2'">
					<xsl:attribute name="value"><xsl:value-of select="$gstrBMC"/></xsl:attribute>	    					   
				</xsl:when>				
				<xsl:otherwise>
					<xsl:attribute name="value"><xsl:value-of select="$gstrIDRAC8Exp"/></xsl:attribute>	    					   
				</xsl:otherwise>
			</xsl:choose>
		    </xsl:when>
			
		    <xsl:when test="type='16'  or type='17'">		  	
			<xsl:choose>
				<xsl:when test="/OMA/EMPObj/licenseClass='5' or /OMA/EMPObj/licenseClass='3' or /OMA/EMPObj/licenseClass='1' or /OMA/EMPObj/licenseClass='0'">
					<xsl:attribute name="value"><xsl:value-of select="$gstrIDRAC7Exp"/></xsl:attribute>					    
				</xsl:when>
				<xsl:when test="/OMA/EMPObj/licenseClass='4'">
					<xsl:attribute name="value"><xsl:value-of select="$gstrIDRAC7Ent"/></xsl:attribute>	    					   
				</xsl:when>
				<xsl:when test="/OMA/EMPObj/licenseClass='2'">
					<xsl:attribute name="value"><xsl:value-of select="$gstrBMC"/></xsl:attribute>	    					   
				</xsl:when>				
				<xsl:otherwise>
					<xsl:attribute name="value"><xsl:value-of select="$gstrIDRAC7Exp"/></xsl:attribute>	    					   
				</xsl:otherwise>
			</xsl:choose>

		    </xsl:when>
	    
            <xsl:when test="(type='10'  or type='11') and /OMA/MaserDeviceInfo/type='1' ">
	
					    <xsl:attribute name="value"><xsl:value-of select="$gstrIDRAC6Ent"/></xsl:attribute>
            </xsl:when>
	     <xsl:when test="type='10' or type='11' ">
					    
					    <xsl:attribute name="value"><xsl:value-of select="$gstrIDRAC6Exp"/></xsl:attribute>
            </xsl:when>
	   <xsl:when test="type='13' or type='0' ">
					
					    <xsl:attribute name="value"><xsl:value-of select="$gstrBMC"/></xsl:attribute>
            </xsl:when>
	     <xsl:when test="type='8' ">
					
					    <xsl:attribute name="value"><xsl:value-of select="$gstrIDRAC"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
          
					    <xsl:attribute name="value"><xsl:value-of select="DisplayName"/></xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
				</Data>

				<xsl:if test="type='16' or type='17' or type='32' or type='33' or type='34'">
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strIDRACPorts"/></xsl:attribute>			
					 <xsl:choose>
					<xsl:when test="/OMA/MaserDeviceInfo">
						<xsl:attribute name="value"><xsl:value-of select="$strPresent"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strAbsent"/></xsl:attribute>
					</xsl:otherwise>
					</xsl:choose>
				</Data>
				</xsl:if>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strBMCFirmwareVersion"/></xsl:attribute>			
					<xsl:attribute name="value"><xsl:value-of select="Version"/></xsl:attribute>
				</Data>

				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSystemGUID"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="GUID"/></xsl:attribute>
				</Data>

			

			<xsl:if test="numPossibleActiveSessions != '255'">
			
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strNumberofPossible"/></xsl:attribute>
					  <xsl:attribute name="value"><xsl:value-of select="numPossibleActiveSessions"/></xsl:attribute>
					</Data>
				
			</xsl:if>

			<xsl:if test="numCurrentlyActiveSessions != '255'">
				
					<Data>
						<xsl:attribute name="display"><xsl:value-of select="$strNumberofCurrent"/></xsl:attribute>
						<xsl:attribute name="value"><xsl:value-of select="numCurrentlyActiveSessions"/></xsl:attribute>
					</Data>
				
			</xsl:if>
</xsl:template>
<xsl:template match="EMPLANConfigObj">
<xsl:param name="bIsIPTable">false</xsl:param>
	
	<xsl:if test="$bIsIPTable!='true'">
		
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strEnableIPMIOverLAN"/></xsl:attribute>
					<xsl:choose>
					<xsl:when test="IPMIMessagingAccessMode = '2'">
						<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
					</xsl:otherwise>
					</xsl:choose>
				</Data>		
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strSOLEnabled"/></xsl:attribute>
					
					<xsl:choose>
					<xsl:when test="/OMA/EMPSOLConfigObj/SOLEnable = '1'">
						
						<xsl:attribute name="value"><xsl:value-of select="$strYes"/></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						
						<xsl:attribute name="value"><xsl:value-of select="$strNo"/></xsl:attribute>
					</xsl:otherwise>
					</xsl:choose>
				</Data>

		
			</xsl:if>		
			
			<xsl:if test="$bIsIPTable='true'">

				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strIPAddressSource"/></xsl:attribute>
				
					<xsl:if test="IPAddrSource = '1'">
					
						<xsl:attribute name="value"><xsl:value-of select="$strStaticAddress"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="IPAddrSource = '2'">
					
						<xsl:attribute name="value"><xsl:value-of select="$strAddressObtainedby"/></xsl:attribute>
					</xsl:if>
					<xsl:if test="IPAddrSource = '3'">
				
						<xsl:attribute name="value"><xsl:value-of select="$strBIOS"/></xsl:attribute>
					</xsl:if>
				</Data>

		
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strCurrentIPAddress"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="IPAddress"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strCurrentIPSubnet"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="SubnetMask"/></xsl:attribute>
				</Data>
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strCurrentIPGateway"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="DefaultGateway"/></xsl:attribute>
				</Data>


			</xsl:if>
			<xsl:if test="$bIsIPTable!='true'">
	
				<Data>
					<xsl:attribute name="display"><xsl:value-of select="$strMACAddress"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="MACAddress"/></xsl:attribute>
				</Data>
	
			      <xsl:if test="$IsiDRAC7Present='true' or $IsiDRAC6Present='true' or $IsiDRACPresent='true' or $IsiDRAC8Present='true'">
			       <xsl:if test="$CallingFromCLI='false'">
			          <Data>
			            <xsl:attribute name="display"><xsl:value-of select="$RemoteConnect"/></xsl:attribute>
			            	<xsl:attribute name="value"><xsl:value-of select="$LogintoIPv4RemoteiDRAC"/></xsl:attribute>
			             <xsl:attribute name="href">javascript:loadIMC('<xsl:value-of select="/OMA/EMPObj/Url"/>')</xsl:attribute>
						 <xsl:attribute name="link">
				          <xsl:choose>
				            <xsl:when test="/OMA/EMPObj/uiStatus='0' or /OMA/EMPObj/Url/@isnull='true' or /OMA/EMPObj/Url=''">false</xsl:when>
			             	 	<xsl:otherwise>true</xsl:otherwise>
				          </xsl:choose>
				          </xsl:attribute>
         	                   </Data>
					</xsl:if>
			       
			       <xsl:if test=" /OMA/EMPObj/uiStatus!='0'">
				    <xsl:if test="/OMA/EMPObj/ipv6Url/@isnull!='true' or /OMA/EMPObj/ipv6Url!=''">
				
				    <xsl:if test="$CallingFromCLI='false'">
				   <Data link='true'>
					<xsl:attribute name="value"><xsl:value-of select="$LogintoIPv6RemoteiDRAC"/></xsl:attribute>
	                           <xsl:attribute name="href">javascript:loadIMC('<xsl:value-of select="/OMA/EMPObj/ipv6Url"/>')</xsl:attribute>					
				     </Data>
					 </xsl:if>
			
				</xsl:if>
				</xsl:if>
			      </xsl:if>
			      </xsl:if>

</xsl:template>

<xsl:template match="EMPV6LANConfigObj">
	
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strIPAddressSource"/></xsl:attribute>
		
			<xsl:choose>
			<xsl:when test="ipv6AddrConfiguration = '1'">		
				<xsl:attribute name="value"><xsl:value-of select="$strAuto"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
						<xsl:attribute name="value"><xsl:value-of select="$strStaticAddress"/></xsl:attribute>
			</xsl:otherwise>
			</xsl:choose>
		</Data>	

		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strGlobalLocalAddress"/></xsl:attribute>			
			<xsl:attribute name="value"><xsl:value-of select="GLAddress"/></xsl:attribute>
		</Data>	
	
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strDefaultGatewayAddress"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="GatewayAddress"/></xsl:attribute>
		</Data>

	
			<Data>
				<xsl:attribute name="display"><xsl:value-of select="$strSiteLocalAddress"/></xsl:attribute>
			<xsl:choose>
			<xsl:when test="SLAddress!=''">	
				<xsl:attribute name="value"><xsl:value-of select="SLAddress"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>		
				<xsl:attribute name="value"><xsl:value-of select="$gstrNotAvailable"/></xsl:attribute>
      </xsl:otherwise>
    </xsl:choose>
  </Data>
	
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strLinkLocalAddress"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="LLAddress"/></xsl:attribute>
		</Data>

		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strDNSAddressSource"/></xsl:attribute>
			
			<xsl:choose>
			<xsl:when test="ipv6DNSConfiguration = '1'">				
				<xsl:attribute name="value"><xsl:value-of select="$strAuto"/></xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:attribute name="value"><xsl:value-of select="$strStaticAddress"/></xsl:attribute>
			</xsl:otherwise>
			</xsl:choose>
		</Data>
	
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strPreferredDNSSServer"/></xsl:attribute>		
		<xsl:choose>
		<xsl:when test="DNS1Address != ''">	
			<xsl:attribute name="value"><xsl:value-of select="DNS1Address"/></xsl:attribute>		
		</xsl:when>
		<xsl:otherwise>		
			<xsl:attribute name="value"><xsl:value-of select="$gstrNotAvailable"/></xsl:attribute>	
		</xsl:otherwise>
		</xsl:choose>
    </Data>
	
		<Data>
			<xsl:attribute name="display"><xsl:value-of select="$strAlternateDNSSServer"/></xsl:attribute>
			
		<xsl:choose>
		<xsl:when test="DNS2Address != ''">		
			<xsl:attribute name="value"><xsl:value-of select="DNS2Address"/></xsl:attribute>	
		</xsl:when>
		<xsl:otherwise>		
			<xsl:attribute name="value"><xsl:value-of select="$gstrNotAvailable"/></xsl:attribute>

    </xsl:otherwise>
  </xsl:choose>
</Data>

</xsl:template>


<xsl:template match="DRSCSummaryObj">
		
				<Data type="ustring" editable="false">
					<xsl:attribute name="display"><xsl:value-of select="$Product"/></xsl:attribute>
					<xsl:attribute name="value">
						 <xsl:value-of select="DRSIdentificationObj/ProductInfo"/>
					</xsl:attribute>
				</Data>
			
				<Data type="ustring" editable="false">
					<xsl:attribute name="display"><xsl:value-of select="$Description"/></xsl:attribute>

          <xsl:attribute name="value">
            <xsl:value-of select="DRSIdentificationObj/DescriptionInfo"/>
          </xsl:attribute>
        </Data>

        <Data type="ustring" editable="false">
          <xsl:attribute name="display"><xsl:value-of select="$Version"/></xsl:attribute>

					<xsl:attribute name="value">
						 <xsl:value-of select="DRSIdentificationObj/VersionInfo"/>
					</xsl:attribute>
				</Data>
		
				<Data type="ustring" editable="false">
					<xsl:attribute name="display"><xsl:value-of select="$CurrentIPAddress"/></xsl:attribute>
	
					<xsl:attribute name="value">
						 <xsl:value-of select="CurrentLanNetworkingObj/NicCurrentIpAddress"/>
					</xsl:attribute>
				</Data>
		
				<Data type="ustring" editable="false">
					<xsl:attribute name="display"><xsl:value-of select="$CurrentIPSubnet"/></xsl:attribute>
			
					<xsl:attribute name="value">
						 <xsl:value-of select="CurrentLanNetworkingObj/NicCurrentNetMask"/>
					</xsl:attribute>
				</Data>
		
				<Data type="ustring" editable="false">
					<xsl:attribute name="display"><xsl:value-of select="$CurrentIPGateway"/></xsl:attribute>
				
					<xsl:attribute name="value">
						 <xsl:value-of select="CurrentLanNetworkingObj/NicCurrentNetGateway"/>
					</xsl:attribute>
				</Data>
	            <xsl:if test="$CallingFromCLI='false'">
				<Data type="ustring" editable="false" link="true">
					<xsl:attribute name="display"><xsl:value-of select="$RemoteConnect"/></xsl:attribute>
					<xsl:attribute name="value"><xsl:value-of select="$LogintoRemoteDRAC"/></xsl:attribute>
					<xsl:attribute name="href">javascript:loadOOB("<xsl:value-of select="DRSIdentificationObj/DrsType"/>")</xsl:attribute>
				</Data>
				</xsl:if>
		
</xsl:template>
</xsl:stylesheet>
