<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	 <!-- including globals.xsl for CLI-->
  	<xsl:include href="../en/globals.xsl"/>
	<xsl:output method="xml"/>
	<xsl:strip-space elements="*"/>
	<xsl:template match="OMA/OMAUserRights"/>
	
	<xsl:template match="OMA">
	<xsl:variable name="usrights"><xsl:value-of select="OMAUserRights"/></xsl:variable>
	<DataArea onLoad="true" validate="false">
	
	<xsl:attribute name="submit">./SubmitForm?plugin=com.dell.hip.webplugins.SetBMCIPv6WebPlugin</xsl:attribute>
	

	<PageTitle>
				<xsl:attribute name="display"><xsl:value-of select="$strAdditionalConfiguration"/></xsl:attribute>
	</PageTitle>
	<xsl:if test="EMPObj/defaultRestoreStatus = '0'">
				<xsl:if test="EMPObj/defaultRestoreSupport = '1'">
				<xsl:choose>
					<xsl:when test = "/OMA/@cli = 'true'">
						<PromptText><xsl:value-of select ="$gstrResetToDefaultCli"/></PromptText>
					</xsl:when>
					<xsl:otherwise>
							<PromptText><xsl:value-of select="$gstrResetToDefault"/></PromptText>
					</xsl:otherwise>
				</xsl:choose>	
				</xsl:if>
			</xsl:if>	
	<CustomButton>
				<Data name=""><xsl:attribute name="display"><xsl:value-of select="$gstrRefresh"/></xsl:attribute>
				<xsl:attribute name="href">./DataArea?plugin=com.dell.hip.webplugins.BMCIPv6WebPlugin&amp;help=iDRAC_AddConfig</xsl:attribute>
				</Data>
	</CustomButton>
        	     <xsl:if test="/OMA/EMPObj/ipv4State='0' or /OMA/EMPObj/ipv4State='1' ">
		<TableData  columnspacing="true" name="IPv4 Properties">
		<xsl:attribute name="display"><xsl:value-of select="$strIPv4Properties"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="$strIPv4Properties"/></xsl:attribute>
		<SubHeader>
				
			<xsl:attribute name="display"><xsl:value-of select="$strIPv4Properties"/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select="$strIPv4Properties"/></xsl:attribute>
				
		</SubHeader>
		
	
			<xsl:apply-templates select="EMPObj"/>
		</TableData>
	  </xsl:if >
	     <xsl:if test="/OMA/EMPV6LANConfigObj">
		<TableData  columnspacing="true" name="tabAdditionalConfiguration">
		
		<xsl:attribute name="display"><xsl:value-of select="$strIPv6Properties"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="$strIPv6Properties"/></xsl:attribute>

		<SubHeader>
				
				<xsl:attribute name="display"><xsl:value-of select="$strIPv6Properties"/></xsl:attribute>
				<xsl:attribute name="value"><xsl:value-of select="$strIPv6Properties"/></xsl:attribute>
				
		</SubHeader>
		
	
			<xsl:apply-templates select="EMPV6LANConfigObj"/>
		</TableData>	
	  </xsl:if>	
		
	 

			<script language="javascript">
			var usrights = '<xsl:value-of select="/OMA/OMAUserRights"/>';
			//var lastipsecval = '<xsl:value-of select="EMPV6LANConfigObj/ipSecState"/>';
			var lastipv6val = '<xsl:value-of select="EMPV6LANConfigObj/ipv6State"/>';
			var lastipv4val = '<xsl:value-of select="EMPObj/ipv4State"/>';

				function initializationRoutine()
				{						
					 <!--if(lastipv6val=='0')
						disableipsecchoices();!-->
			
				}

				
			
					
			        function confirmselect(element)
					
				{ 

					if(element.name =='ipv6confg')
				     {
					<!-- This functions is to get the Confirmation from user and indicate the consequences of disabling IPv6 -->
					var Ipv6confirmDis = "<xsl:value-of select="$strConfirmIPv6Disabled"/>" ;
					if(confirm(Ipv6confirmDis) != true) 
					{  	
					   if(lastipv6val==1)
					     document.getElementById("ipv6enable").checked = true;<!-- Restore the Previous IPv6 State -->
					   
					   				  					
					}
					else
					{
					
					  <!--if(  lastipsecval == 1)
					    	document.getElementById("ipsecenable").checked = true;  Restore the Previous IPSec State 
					 	disableipsecchoices();-->
					}
					
					
				     }
					
				     else
					
					{ 

					<!-- This functions is to get the Confirmation from user and indicate the consequences of disabling IPsec-->
					
					<!--
					var IpsecConfirmDis = "<xsl:value-of select="$strConfirmIPSecDisabled"/>";
					if(confirm(IpsecConfirmDis) != true) 
						{  		
					  		if(lastipsecval == 1)
							document.getElementById("ipsecenable").checked = true;  Restore the Previous IPSec State 
						} -->
					
					}

				 }
				
				<!--function enableipsecchoices()
				{
					document.getElementById("ipsecenable").disabled = false;
					document.getElementById("ipsecdisable").disabled = false;

				}
				
				function disableipsecchoices()
				{
					document.getElementById("ipsecenable").disabled = true;
					document.getElementById("ipsecdisable").disabled = true;
				}-->
			
				 function confirmIPv4Disable(element)
					
				{ 

					if(element.name =='ipv4confg')
				     {
					<!-- This functions is to get the Confirmation from user and indicate the consequences of disabling IPv4 -->
					var IPv4ConfirmDis = "<xsl:value-of select="$strConfirmIPv4Disabled"/>";
					if(confirm(IPv4ConfirmDis) != true) 
					{  	
					   if(lastipv4val==1)
					     document.getElementById("ipv4enable").checked = true;<!-- Restore the Previous IPv4 State -->					   				  					
					}					
				    }				    
				 }


			</script>

	

</DataArea>
</xsl:template>	

<xsl:template match="EMPObj">
 <Row>
			       	
	<Data width="18%">
		<xsl:attribute name="display"><xsl:value-of select="$strIPv4"/></xsl:attribute>
		<xsl:attribute name="value"><xsl:value-of select="$strIPv4"/></xsl:attribute>
	</Data>		
	<Data ignoreonweb="true">
		<xsl:if test="ipv4State='1'">
			<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
		 </xsl:if>
		 <xsl:if test="ipv4State='0'">
			 <xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
		 </xsl:if>
	</Data>	
	<Data align="center" ignoreoncli="true" >
			   	<xsl:attribute name="name">ipv4confg</xsl:attribute>
				<xsl:attribute name="id">ipv4enable</xsl:attribute>
				<xsl:attribute name="returnvalue">1</xsl:attribute>
			       	<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
			       	<xsl:attribute name="type" >radio</xsl:attribute>
				<xsl:attribute name="event">onClick</xsl:attribute>				
				<xsl:if test="ipv4State='1'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
			
				
	 </Data>
	 <Data align="center" ignoreoncli="true">
				 <xsl:attribute name="name">ipv4confg</xsl:attribute>
				<xsl:attribute name="id">ipv4disable</xsl:attribute>
				<xsl:attribute name="returnvalue">0</xsl:attribute>
	       			<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
	       			<xsl:attribute name="type" >radio</xsl:attribute>
				<xsl:attribute name="event">onClick</xsl:attribute>
				<xsl:attribute name="handler">javascript:confirmIPv4Disable(this)</xsl:attribute>
	       			<xsl:if test="ipv4State ='0'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
									       			
    	</Data>
 </Row>
</xsl:template>


<xsl:template match="EMPV6LANConfigObj">
		
		  <Row>
			       	
			<Data>
			        <xsl:attribute name="display"><xsl:value-of select="$strIPv6"/></xsl:attribute>
			        <xsl:attribute name="value"><xsl:value-of select="$strIPv6"/></xsl:attribute>
			</Data>

			<Data ignoreonweb="true">
				<xsl:if test="ipv6State='1'">
                         		<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
				 </xsl:if>
			 	 <xsl:if test="ipv6State='0'">
                         		 <xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
			 	 </xsl:if>
			</Data>			
										
			<Data align="center" ignoreoncli="true" >
			   	<xsl:attribute name="name">ipv6confg</xsl:attribute>
				<xsl:attribute name="id">ipv6enable</xsl:attribute>
				<xsl:attribute name="returnvalue">1</xsl:attribute>
			       	<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
			       	<xsl:attribute name="type" >radio</xsl:attribute>
				<!--xsl:attribute name="event">onClick</xsl:attribute>
				<xsl:attribute name="handler">javascript:enableipsecchoices()</xsl:attribute!-->
				<xsl:if test="ipv6State ='1'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
			
				
			 </Data>
			<Data align="center" ignoreoncli="true">
				 <xsl:attribute name="name">ipv6confg</xsl:attribute>
				<xsl:attribute name="id">ipv6disable</xsl:attribute>
				<xsl:attribute name="returnvalue">0</xsl:attribute>
	       			<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
	       			<xsl:attribute name="type" >radio</xsl:attribute>
				<xsl:attribute name="event">onClick</xsl:attribute>
				<xsl:attribute name="handler">javascript:confirmselect(this)</xsl:attribute>
	       			<xsl:if test="ipv6State ='0'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
									       			
    			</Data>
				
			       							
		</Row>
  		<!-->Row>
			       	
			 <Data>
			        <xsl:attribute name="display"><xsl:value-of select="$strIPSec"/></xsl:attribute>
				   <xsl:attribute name="value"><xsl:value-of select="$strIPSec"/></xsl:attribute>
		         </Data>
	
			 <Data  ignoreonweb="true">
				<xsl:choose>
					<xsl:when test="ipv6State='0'">
                        		 	 <xsl:attribute name="value"><xsl:value-of select="$gstrNA"/></xsl:attribute>
			 		</xsl:when>
			 		<xsl:otherwise>
					<xsl:if test="ipSecState='1'">
                        			 <xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
			 		</xsl:if>
			 		<xsl:if test="ipSecState='0'">
                          			<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
			 		</xsl:if>
					 </xsl:otherwise>
				 </xsl:choose>
			   </Data>	
											
			 <Data align="center" ignoreoncli="true">
			       	<xsl:attribute name="name">ipsecconfg</xsl:attribute>
				<xsl:attribute name="id">ipsecenable</xsl:attribute>
				<xsl:attribute name="returnvalue">1</xsl:attribute>
			       	<xsl:attribute name="value"><xsl:value-of select="$strEnabled"/></xsl:attribute>
			       	<xsl:attribute name="type" >radio</xsl:attribute>
				 <xsl:if test="ipSecState ='1'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
        		  </Data>
			  <Data align="center" ignoreoncli="true" >
	       			<xsl:attribute name="name">ipsecconfg</xsl:attribute>
				<xsl:attribute name="id">ipsecdisable</xsl:attribute>
				<xsl:attribute name="returnvalue">0</xsl:attribute>
	       			<xsl:attribute name="value"><xsl:value-of select="$strDisabled"/></xsl:attribute>
	          		 <xsl:attribute name="type" >radio</xsl:attribute>
				<xsl:attribute name="event">onClick</xsl:attribute>
				<xsl:attribute name="handler">javascript:confirmselect(this)</xsl:attribute>
			   	<xsl:if test="ipSecState ='0'"><xsl:attribute name="state">1</xsl:attribute></xsl:if>
			   </Data>
			  
			      							
	     </Row!-->


     </xsl:template>
</xsl:stylesheet>
