#!/bin/sh
    # fixup omreg
    cat /opt/dell/srvadmin/etc/omreg.d/*.cfg > /opt/dell/srvadmin/etc/omreg.cfg 2>/dev/null ||:

    ##########################################
    # Perform Data Engine configuration
    ##########################################
    [ ! -e /opt/dell/srvadmin/lib64/srvadmin-omilcore/Funcs.sh ] || . /opt/dell/srvadmin/lib64/srvadmin-omilcore/Funcs.sh
    DCECFG=$(GetRegVal /opt/dell/srvadmin/etc/omreg.cfg OMDataEngine.configtool)

    if [ -z "$DCECFG" ]; then
        # data engine not installed (not really possible)
        echo "Could not register data engine components because data engine not installed."
        exit 1
    fi

    $DCECFG command=addmpialias \
            update=TRUE \
            startuptype=automatic \
            aliasname=dcsnra \
            pathfname="/opt/dell/srvadmin/lib64/openmanage/libdcsnra.so" \
            dispatchfn=DCSNRA_SMMIBImplementerDispatch \
            displayname="Remote Access Controller  SNMP MIB Implementor"

