%define provider adaptec
%define rname aacraid
%define rversion 1.1.5
%define rbuild 26400

%define _libexecdir /lib/modules

#Make sure to export the environment variable $KERNEL
#before making this RPM!  It should look something like:
# export KERNEL="linux-2.6.9.11-20/bigsmp"
#at which point the driver will be compiled against
# /usr/src/$KERNELVER-obj/i386/$FLAVOR
#or, if the FLAVOR part of $KERNEL is not defined, it will build against the default tree only.

#Alternatively, if $KERNEL is not defined, then assume the current kernel/flavor.
#What follows is basically magic: splitkernel will contain only the kernel version of the intended kernel as described above, and kflavor will contain the intended flavor (the difference between kflavor and myflavor being that kflavor will report 'default' if the normal flavor is intended).
%define splitkernel %( if [ -z $KERNEL ]; then ( echo "linux-`uname -r | cut -d"-" -f1,2`" ); else ( echo "$KERNEL" | sed -e "s|\/.*||g"); fi )
%define splitflavor %( if [ -z $KERNEL ]; then ( echo `uname -r | sed -e "s|.*[Ee][Ll][0-9]*||"` ); else ( echo "$KERNEL" | sed -e "s|.*\/||g" ); fi)
%define myflavor %( if [ "%{splitflavor}" = "%{splitkernel}" ]; then (echo ""); else (echo "%{splitflavor}"); fi)

#Sets up some variables we will need later on, mostly for path purposes.
%define kver %(echo %{splitkernel} | sed -e "s|linux-||g" )
%define kversion %(echo "%{splitkernel}" | sed -e 's|-.*||')
%define kernel %( if [ "%{splitflavor}" = "%{splitkernel}" ]; then (echo "%{kver}%{myflavor}"); else (echo "%{kver}"); fi)
%define kfullver2 %(echo "%{kernel}" | sed -e 's|-|_|g')

#moduledir contains the directory beneath /lib/modules/%{kernel}/ 
#	where our modules will be installed.  This is so as not to
#	contaminate the normal module tree.
%define moduledir /updates

#
# Now things get specific; everything above can be safely duplicated.
#

#Where this particular package gets built.
%define pkgbuilddir /usr/src/redhat/BUILD/%{rname}-%{rversion}-%{rbuild}

#The name of the module that is produced by the build process.
%define modules %{rname}.ko

Prefix: /opt/Adaptec/aacraid

#Required RPM information: the summary field will probably change for you,
#	but name and version will be automatically be filled in by variables
#	up at the top of this spec.  This conforms to our specification for
#	building 'migrateable' RPMs; don't change it.
Summary: Linux driver for the sample Hello World driver
Name: %( (echo "%{rname}") )
Version: %( (echo "%{rversion}" | tr '-' '_') )
#Bump your release up a notch whenever you have a new revision!
Release: %{rbuild}

#Make sure to update this field appropriately.
License: GPL
#Since you're packaging a module, this field shouldn't need to be touched.
Group: System Environment/Kernel
#For this example, the name of the source tarball is aacraid-1.0.tar.gz .
#	It is filled in by variables here because other point releases
#	did not require significant spec file changes, so we can essentially
#	just change the version in one place to compile different versions
#	of the driver.  This may or may not be convenient for you.
Source: /opt/Adaptec/aacraid/aacraid_source.tgz
#These two scripts handle the automatic running of depmod and the updating
#	of the initrd for the specified kernel.  mkinitrd-rhel.sh will also 
#	update grub using grubby, which is unavailable on SLES at the moment,
#	hence the '-rhel' extensions on the scripts.
#In this example, the module itself is not, by default, exporting version
#	information to the kernel.  We solve this with a very small patch to
#	the actual driver source.  If at all possible, your module source
#	should do this by default.  See the patch for more information.  
Distribution: linux
Vendor: Adaptec
Packager: Achim Leubner <Achim_Leubner@adaptec.com>

BuildRoot: %{_tmppath}/root-%{name}-%{version}

#Update this field appropriately.
%description
aacraid driver

%define flav %myflavor

#In this case, the source tarball extracts to a directory called simply
#	'5.00.04', so we inform setup of this.  This section just prepares
#	the source tree with any patches/modifications/etc. you may need
#	before building.
%prep
mkdir -p %{rname}-%{rversion}-%{rbuild}
cd %{rname}-%{rversion}-%{rbuild}
%setup -c -n %{rname}-%{rversion}-%{rbuild}
cd -

%build
#generate the driver against each flavor of the kernel.
#If your drivers are fairly straightforward to compile, you shouldn't have
#	to change very much (if anything) in this section.
echo "kernpath %{_libexecdir}/%{kernel}"
	%{__rm} -rf %{buildroot}/*
	%( if [ "$(hostname)" = "aim-pendulous" ] ; then (echo ""); else (echo "%{__mkdir} -p %{buildroot}/%{prefix}"; echo "%{__cp} -f /usr/src/redhat/SOURCES/aacraid_source.tgz %{buildroot}/%{prefix}"); fi)
	%{__make} -j2 -C %{_libexecdir}/%{kernel}/build M=%{pkgbuilddir}
	%{__install} -d -m0755 %{buildroot}%{_libexecdir}/%{kernel}%{moduledir}
	%{__mv} -f %{modules} %{buildroot}/%{_libexecdir}/%{kernel}%{moduledir}


%install
#This section should not require significant modification, either.  It 
#	sets up the post-install/uninstall scripts which perform three main
#	tasks: running depmod for the targetted kernel, making a new initrd
#	for that kernel, and adding a grub entry using the new initrd.
#	Note that you will not always necessarily want to make a new initrd or
#	make a new grub entry if your driver is not DASD-related.
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
#( cd %{_libexecdir}/%{kernel}/build ; tar -zxf /opt/Adaptec/aacraid/aacraid_source.tgz )

%post
# IMPORTANT: Do not change the KERNELRELEASES definition; it will be
# replaced during driver reuse!
# set variables
KERNELRELEASES=%{kernel}

# add modules to modules.conf and run depmod
# We're pretending here that our driver is a storage driver, and as such
# prepending 'scsi_hostadapter_' to its name.
echo "alias scsi_hostadapter_aacraid aacraid" >> /etc/modprobe.conf

# update the module dependencies for the target kernel/flavor
depmod -a -F /boot/System.map-${KERNELRELEASES} ${KERNELRELEASES}

# update initrd and grub
if [ "%{myflavor}" = "xen" ] ; then
new-kernel-pkg -v --multiboot="/boot/xen.gz-`uname -r | cut -f1 -dx`" --mkinitrd --initrdfile="/boot/initrd-${KERNELRELEASES}.update" --banner="$(cat /etc/redhat-release | sed -e 's/release.*$//')" --install ${KERNELRELEASES}
else
new-kernel-pkg -v --mkinitrd --initrdfile="/boot/initrd-${KERNELRELEASES}.update" --banner="$(cat /etc/redhat-release | sed -e 's/release.*$//')" --install ${KERNELRELEASES}
fi

%postun
# IMPORTANT: Do not change the KERNELRELEASES definition; it will be
# replaced during driver reuse!
# set variables
KERNELRELEASES=%{kernel}

# remove modules from /etc/modprobe.conf
sed -i -e '/alias scsi_hostadapter_aacraid.*$/d' /etc/modprobe.conf

# update the module dependencies for the target kernel/flavor
depmod -a -F /boot/System.map-${KERNELRELEASES} ${KERNELRELEASES}

# update initrd and grub
if [ "%{myflavor}" = "xen" ] ; then
new-kernel-pkg -v --multiboot="/boot/xen.gz-`uname -r | cut -f1 -dx`" --mkinitrd --initrdfile="/boot/initrd-${KERNELRELEASES}.update" --banner="$(cat /etc/redhat-release | sed -e 's/release.*$//')" --install ${KERNELRELEASES}
else
new-kernel-pkg -v --mkinitrd --initrdfile="/boot/initrd-${KERNELRELEASES}.update" --banner="$(cat /etc/redhat-release | sed -e 's/release.*$//')" --install ${KERNELRELEASES}
fi


%clean
%{__rm} -rf ${buildroot}

#Define the package for each flavor and list the corresponding files in %files for them.
#This section should not require significant (if any) modification.
%files

%defattr(-, root, root, 0755)
/opt/Adaptec/aacraid/aacraid_source.tgz
%{_libexecdir}/%{kernel}%{moduledir}/

%changelog
* Wed Aug 30 2006 Greg Cymbalski <gcymbal@us.ibm.com> - 1.0 
- Initial package.
