%define version 1.8.8f 
%define mib "INTELLAN.txt"
%define arch $(uname -m | sed 's/i.86/ia32/')

summary: Intel(R) PRO adapters SNMP extension for Linux
name: inic-snmp
version: %{version}
release: rh3
source: %{name}-%{version}.tar.gz
vendor: Intel Corporation
license: Binary
exclusiveos: linux
group: System/Configuration/Networking
url: http://support.intel.com/support/go/linux/snmp.htm
BuildRoot: /var/tmp/%{name}-%{version}-root
Requires: net-snmp
provides: %{name}

%description
This package contains the Linux SNMP extension for the PRO/LAN adapters.

%prep

%setup

%build

%pre
snmpd_conf=`echo /etc/snmp/snmpd.conf`
if [ -z $snmpd_conf ]; then
    echo "$snmpd_conf snmp configuration file not found."
    exit 1
fi

%install
# install the driver into the build root

/bin/mkdir -p $RPM_BUILD_ROOT/usr/share/snmp/mibs/
/bin/cp %{mib} $RPM_BUILD_ROOT/usr/share/snmp/mibs/

/bin/mkdir -p $RPM_BUILD_ROOT/usr/sbin
/bin/cp %{arch}/* $RPM_BUILD_ROOT/usr/sbin

%clean
/bin/rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/usr/share/snmp/mibs/*
/usr/sbin/*
%doc LICENSE
%doc README

%post 
snmpd_conf=`echo /etc/snmp/snmpd.conf`

grep "^\( *\)pass .1.3.6.1.4.1.343.2.7.2" $snmpd_conf >& /dev/null
   
if [ $? != 0 ]; then  
    echo pass .1.3.6.1.4.1.343.2.7.2 /usr/sbin/inic_extension >> $snmpd_conf 
else
    perl -i -p -e "s{^( *)pass .1.3.6.1.4.1.343.2.7.2 (.*)}{pass .1.3.6.1.4.1.343.2.7.2 /usr/sbin/inic_extension}" $snmpd_conf 
fi

/bin/mkdir -p /snmp
/bin/touch /snmp/snmpd.conf

%postun
snmpd_conf=`echo /etc/snmp/snmpd.conf`
if [ -f $snmpd_conf ]; then
    perl -i -p -e "s{^( *)pass .1.3.6.1.4.1.343.2.7.2 /usr/sbin/inic_extension\n}{}" $snmpd_conf
fi
