%define version 1.8.8f 
%define mib "INTELLAN.txt"

summary: Intel(R) PRO adapters SNMP extension for Linux
name: inic-snmp
version: %{version}
release: rh21
source: %{name}-%{version}.tar.gz
vendor: Intel Corporation
license: Binary
exclusiveos: linux
group: System/Configuration/Networking
url: http://support.intel.com/support/go/linux/snmp.htm
BuildRoot: /var/tmp/%{name}-%{version}-root
Requires: ucd-snmp
provides: %{name}

%description
This package contains the Linux SNMP extension for the PRO/LAN adapters.

%prep

%setup

%build

%pre
man snmpd.conf | col -b | grep /.*/snmpd.conf | grep configuration | grep file > /tmp/snmpddir
snmpd_dirs=`cat /tmp/snmpddir`

for elem in $snmpd_dirs ; do
    if  echo $elem | egrep "^/.*/snmpd.conf$" > /dev/null; then
        snmpd_conf=$elem
        break
    fi
done

/bin/rm -rf /tmp/snmpddir    
if [ -z $snmpd_conf ]; then
    echo "snmpd configuration file unknown."
    exit 1
fi

echo $snmpd_conf > /tmp/inic_snmp_data

%install
# install the driver into the build root

/bin/mkdir -p $RPM_BUILD_ROOT/usr/share/snmp/mibs/
/bin/cp %{mib} $RPM_BUILD_ROOT/usr/share/snmp/mibs/

/bin/mkdir -p $RPM_BUILD_ROOT/usr/sbin
/bin/cp ia32/* $RPM_BUILD_ROOT/usr/sbin

%clean
/bin/rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/usr/share/snmp/mibs/*
/usr/sbin/*
%doc LICENSE
%doc README

%post 
snmpd_conf=`cat /tmp/inic_snmp_data`
/bin/rm -f /tmp/inic_snmp_data

if [ ! -f $snmpd_conf ]; then
    touch  $snmpd_conf
fi

grep "^\( *\)pass .1.3.6.1.4.1.343.2.7.2" $snmpd_conf >& /dev/null
   
if [ $? != 0 ]; then  
    echo pass .1.3.6.1.4.1.343.2.7.2 /usr/sbin/inic_extension >> $snmpd_conf 
else
    perl -i -p -e "s{^( *)pass .1.3.6.1.4.1.343.2.7.2 (.*)}{pass .1.3.6.1.4.1.343.2.7.2 /usr/sbin/inic_extension}" $snmpd_conf 
fi

%postun
man snmpd.conf | col -b | grep /.*/snmpd.conf | grep configuration | grep file > /tmp/snmpddir
snmpd_dirs=`cat /tmp/snmpddir`

for elem in $snmpd_dirs ; do
    if  echo $elem | egrep "^/.*/snmpd.conf$" > /dev/null; then
        snmpd_conf=$elem
        break
    fi
done

/bin/rm -f /tmp/snmpddir  

if [ -f $snmpd_conf ]; then
    perl -i -p -e "s{^( *)pass .1.3.6.1.4.1.343.2.7.2 /usr/sbin/inic_extension\n}{}" $snmpd_conf
fi
