
Option Explicit
Dim colArgs, strSettingsFile, SValueSet, SessionObject, NetServiceObject
Dim strIfSetFile, strFileName, strSave, strChoices, strInput, bError, strNetSerObjPath
Dim strSettingName, strFname, index, bUserInput, bModified, NetServiceSet
Dim totalAdapters, totalTeams, existTotalAdapters, bNewTeam, ServiceObject, FinalTargetObj
Dim AdapterSets, AdapterObj, wbemServices, strComputer, bHasTeamOrVLAN, wbemServices1
Dim bMisMatch, bSelected, strSettingsIndex, strCapabilities, strAdapterName, strAdapterPCIDeviceID ',strOrgDispName
Dim arrPrivDesc(), arrTeamPrivDesc(), Adapters(), Captions(), Teams() ,AdapterPath(), AdapterPCIDeviceID()
Dim TeamsObjSet, TeamObj,Temp ,VLANObjSet, VLANObj, virtualAdapterSets, virtualAdapterObj
Dim bMFOEnabled, shell, IPFilePath
const HKEY_LOCAL_MACHINE = &H80000002
Dim strRemove
Dim isPowerManagementSupported
isPowerManagementSupported = False
'Dim blTenGigFETeamError
'blTenGigFETeamError = False

'During DMiX-to-DMiX upgrade scenarios only, the PermanentAddress 
'will be stored in the config file instead of the PCIDeviceID.
'The is due to the fact that the initial release of DMiX 
'did not have support for the PCIDeviceID property.
Dim bIsUpgrade		
bIsUpgrade = False	'Initialize to FALSE.

Dim InParameterETObj,TempETObject,OutParameterETObj
Set shell = CreateObject("WScript.Shell")
'  	Set env = shell.Environment("USER")

IPFilePath = shell.ExpandEnvironmentStrings("%TEMP%")
IPFilePath = IPFilePath & "\PROSetDX\DMIX\StaticIP.txt"



Const maxAdapterTeamVLANs = 64
Const maxAdapterTeam = 64

Const wbemFlagAmendedCreateOnly = &h20002  

Const maxSettings = 1000
Const DefaultFileName = "WmiConf.txt"


Set colArgs = WScript.Arguments
strComputer = "."

' Check submitted arguments, show Usage for no arguments, ? or help arguments
If (WScript.Arguments.Count = 0) Then 
	PrintUsage()
Else 
	If (WScript.Arguments(0) = "?" ) OR (LCase(WScript.Arguments(0)) = "help") Then
		PrintUsage()
	Else
		' Assign variables after determining what combination of options have been submitted
		If WScript.Arguments.Count = 1 Then
			strIfSetFile = "FALSE"
			If LCase(WScript.Arguments(0)) = "save" Then
				strSave = "TRUE"
			ElseIf LCase(WScript.Arguments(0)) = "restore" Then
				strSave = "FALSE"
			ElseIf LCase(WScript.Arguments(0)) = "upsave" Then
				bIsUpgrade = True
				strSave = "TRUE"
			ElseIf LCase(WScript.Arguments(0)) = "uprestore" Then
				bIsUpgrade = True
				strSave = "FALSE"
			ElseIf LCase(WScript.Arguments(0)) = "remove" Then
				strRemove = "TRUE"
			End If
		Else
			If LCase(WScript.Arguments(0)) = "save" Then
				strSave = "TRUE"
			ElseIf LCase(WScript.Arguments(0)) = "restore" Then	
				strSave = "FALSE"
			ElseIf LCase(WScript.Arguments(0)) = "upsave" Then
				bIsUpgrade = True
				strSave = "TRUE"
			ElseIf LCase(WScript.Arguments(0)) = "uprestore" Then
				bIsUpgrade = True
				strSave = "FALSE"
			ElseIf LCase(WScript.Arguments(0)) = "remove" Then
				strRemove = "TRUE"	
			End If
			If LCase(WScript.Arguments(1)) = "default" Then
				strIfSetFile = "FALSE"
			Else
				strIfSetFile = "TRUE"
			End If
		End If
	
		'Execute Save, Restore, Install or Remove on what data user submitted, depending on the arguments set above			
		If (strIfSetFile = "FALSE") Then
			strSettingsFile = defaultFileName
			If (bIsUpgrade = True) AND (strSave = "TRUE") Then
				WScript.Echo "Executing Save during upgrade on local computer with " & strSettingsFile
				SaveSettings(strSettingsFile)
			ElseIf (bIsUpgrade = True) AND (strSave = "FALSE") Then
				WScript.Echo "Executing Restore during upgrade on local computer with " & strSettingsFile
				RestoreSettings(strSettingsFile)
			ElseIf strSave = "TRUE" Then		
				WScript.Echo "Executing Save on local computer with " & strSettingsFile
				SaveSettings(strSettingsFile)
			ElseIf strSave = "FALSE" Then
				WScript.Echo "Executing Restore on local computer with " & strSettingsFile
				RestoreSettings(strSettingsFile)
			Elseif strRemove  = "TRUE" Then
				WScript.Echo "Executing Remove on local computer"
				Remove()
			Else				
				WScript.Echo "Unrecognized keyword:  " & WScript.Arguments(0) & ".  Keyword must be 'save' or 'restore' or 'remove' only."
			End If
		Else
			strSettingsFile = WScript.Arguments(1)
			If (bIsUpgrade = True) AND (strSave = "TRUE") Then
				WScript.Echo "Executing Save during upgrade on local computer with " & strSettingsFile
				SaveSettings(strSettingsFile)
			ElseIf (bIsUpgrade = True) AND (strSave = "FALSE") Then
				WScript.Echo "Executing Restore during upgrade on local computer with " & strSettingsFile
				RestoreSettings(strSettingsFile)
			ElseIf strSave = "TRUE" Then
				WScript.Echo "Executing Save on local computer with " & strSettingsFile
				SaveSettings(strSettingsFile)
			ElseIf strSave = "FALSE" Then
				WScript.Echo "Executing Restore on local computer with " & strSettingsFile
				RestoreSettings(strSettingsFile)
			Elseif strRemove  = "TRUE" Then
				WScript.Echo "Executing Remove on local computer with " & strSettingsFile
				Remove()
			Else
				WScript.Echo "Unrecognized keyword:  " & WScript.Arguments(0) & ".  Keyword must be 'save' or 'restore' or 'remove' only."
			End If
		End If
	End If
End If

'=======================================================================================
'
' Sub:	PrintUsage()
'  
'=======================================================================================
Sub PrintUsage()
	WScript.Echo "Intel(R) SavResDx.vbs version 1.0 "
	WScript.Echo "Copyright (C) Intel, Inc. 2005. All rights reserved."
	WScript.Echo ""
	WScript.Echo "   Usage: SavResDX.vbs keywords default/settingsfile"
	WScript.Echo "   Keywords are required and are 'save' or 'restore' only."
	WScript.Echo "   Settings file can be the keyword 'default' or an explicit file name."
	WScript.Echo "   Settings filename must include the file path."
	WScript.Echo "   Default filename is WMIConf.txt, saved to the current directory."
	WScript.Echo "   Default filename is used if no settings filename is given or"
	WScript.Echo "   the keyword 'default' is used."  
End Sub

'=======================================================================================
'
' Sub:  SaveSettings(ByVal strFname)
'		Save Adapter's, team's and VLAN's info. and settings info. to a text file.
'		Save Adapter's compatiblity settings. 
'  
'=======================================================================================
Sub SaveSettings(byVal strFileName)	
	dim colNetDevicesPhysical,colNetDevicesLogical
	dim objNetDevicePhyObj,objFile,objNetDeviceLogObj
	dim wbemServices
	dim DeviceIndex
		
	'Create a configuration file
	If IsEmpty(CreateConfigFile(strFileName)) Then
		Exit sub
	Else
		Set objFile=CreateConfigFile(strFileName)
	End If
	objFile.WriteLine "*** NCS2 DMiX Save Data ***"
	objFile.WriteLine "*** Date " & Date & " Time " & Time() & "  ***"
	objFile.WriteLine "**********************************************"
	objFile.WriteLine ""	
	
'	Set wbemServices = GetObject("winmgmts://./root/IntelNcs2")  
	Set wbemServices = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/IntelNcs2")	
	wbemServices.Security_.Privileges.AddAsString "SeLoadDriverPrivilege", True
		
	'Get all instances from IANet_PhysicalEthernetAdapter for adapters
	
	Set colNetDevicesPhysical = wbemServices.InstancesOf("IANet_PhysicalEthernetAdapter") 
	'Save Adapters 
	DeviceIndex=1	
	For each objNetDevicePhyObj in colNetDevicesPhysical
		'Save settings for only Intel adapters by checking for Non-Intel and disabled adapters
'		If (StrComp(Mid(objNetDevicePhyObj.Caption, 1, 13), "Intel(R) PRO/", vbTextCompare)) = 0 AND (objNetDevicePhyObj.StatusInfo= 3) then	
		If(InStr(1,objNetDevicePhyObj.Caption, "Intel(R) PRO/", 1) <> 0) AND (objNetDevicePhyObj.StatusInfo= 3) then				
			'Save Adapter specific info			
				objFile.WriteBlankLines(1)				
				SaveAdapterInfo objFile, objNetDevicePhyObj, DeviceIndex				
				SaveAdvancedSettings objFile, objNetDevicePhyObj, wbemServices
				SaveVlanSettings objFile, objNetDevicePhyObj, wbemServices
				DeviceIndex=DeviceIndex + 1
		End if
	Next
	
	objFile.WriteBlankLines(1)
	
	'Get all instances from IANet_LogicalEthernetAdapter for teams
	Set colNetDevicesLogical = wbemServices.InstancesOf("IANet_LogicalEthernetAdapter") 

	For each objNetDeviceLogObj in colNetDevicesLogical
		'Save Team specific info
		SaveTeamInfo objFile, objNetDeviceLogObj, DeviceIndex, wbemServices			
		SaveTeamAdvancedSettings objFile,objNetDeviceLogObj,wbemServices
		SaveVlanSettings objFile, objNetDeviceLogObj, wbemServices
		DeviceIndex=DeviceIndex + 1
		objFile.WriteBlankLines(1)	
	Next
		
	objFile.WriteBlankLines(1)
	
	objFile.close
	Wscript.Echo "Saving done!"

	
	SaveStaticIPSettings(IPFilePath)
	
	
End Sub

'****************************************************************************
Private Function SaveAdapterInfo(objFile,objAdapter,DeviceIndex)
	dim LastCapIndex
	dim index,bFound 
	bFound = False
	
	LastCapIndex=Ubound(objAdapter.Capabilities)
	'objFile.WriteLine "Adapter Name=" & objAdapter.Caption 20/2/2004
	objFile.WriteLine "Adapter Name=" & objAdapter.OriginalDisplayName

	If bIsUpgrade Then
		'Save MAC address in config file for DMiX-to-DMiX upgrade scenarios only.
		objFile.WriteLine "Adapter PCIDeviceID=" & objAdapter.PermanentAddress
	Else
		objFile.WriteLine "Adapter PCIDeviceID=" & objAdapter.PCIDeviceID
	End if

	objFile.WriteLine "Adapter Index=" & DeviceIndex
	objFile.WriteLine "Private Description="
	objFile.Write "Adapter Capabilities=" 
	
	For index = 0 to LastCapIndex-1
		objFile.Write objAdapter.Capabilities(index) 
		objFile.Write ","
		if( objAdapter.Capabilities(index) = 50) then			
			bFound = True		
		End if	
	Next
	if bFound then
		isPowerManagementSupported = True
	Else
		isPowerManagementSupported = False	
	End if
	objFile.WriteLine objAdapter.Capabilities(LastCapIndex)
	objFile.WriteLine "Description=" & objAdapter.Description
End Function

'*****************************************************************************
Private Function CreateConfigFile(byVal strFileName)
	dim fso
	dim file
	
	Set fso = CreateObject("Scripting.FileSystemObject")
	Set file=fso.CreateTextFile(strFileName,True)
	Set CreateConfigFile=file

End Function

'*****************************************************************************
Private Function SaveAdvancedSettings(objFile,objAdapter,wbemServices)
	dim strQuery
	dim IANET_config
	dim IANet_Obj,OutParam

	strQuery = "ASSOCIATORS OF {" & objAdapter.Path_.Path & "} WHERE ResultClass = IANet_AdapterSetting"
	Set IANet_config = wbemServices.ExecQuery(strQuery)
				
	For Each IANet_Obj In IANet_config
		If (StrComp(Mid(IANet_Obj.Caption, 1, 14), "ExpressTeaming", vbTextCompare) <>0) Then ' For avoiding Express Team Info
			objFile.WriteLine "setting Name=" & IANet_Obj.Caption 			
			objFile.WriteLine "setting Current Value=" & IANet_Obj.CurrentValue
			objFile.WriteLine "setting Description=" & IANet_Obj.Description
		End If			

	Next	
		
	'Power Saver

	if (isPowerManagementSupported = True) Then	

		Set OutParam = objAdapter.ExecMethod_("GetPowerUsageOptions")
		if isnull(OutParam.AutoPowerSaveModeEnabled) Then	
		else
			objFile.WriteLine"setting Name=AutoPowerSaveModeEnabled"
    		objFile.WriteLine"setting Current Value=" & OutParam.AutoPowerSaveModeEnabled
    		objFile.WriteLine"setting Description=AutoPowerSaveModeEnabled"
    	End If
		if isnull(OutParam.ReduceSpeedOnPowerDown) Then	
		else
			objFile.WriteLine"setting Name=ReduceSpeedOnPowerDown"
    		objFile.WriteLine"setting Current Value=" & OutParam.ReduceSpeedOnPowerDown
    		objFile.WriteLine"setting Description=ReduceSpeedOnPowerDown"
    	End If
    	if isnull(OutParam.SmartPowerDown)Then    
		else    		   
	   		objFile.WriteLine"setting Name=SPDEnabled"
			objFile.WriteLine"setting Current Value=" & OutParam.SmartPowerDown
			objFile.WriteLine"setting Description=SmartPowerDown"
		End If
		if isnull(OutParam.SavePowerNowEnabled) Then	
		else
			objFile.WriteLine"setting Name=SavePowerNowEnabled"		
			objFile.WriteLine"setting Current Value=" & OutParam.SavePowerNowEnabled
			objFile.WriteLine"setting Description=SavePowerNowEnabled"
		End If
	End If

End Function

'*****************************************************************************
Private Function SaveTeamInfo(objFile,objNetDeviceLogObj,DeviceIndex,wbemServices)
 	dim colTeamedAdapters,colTeamedMemberAdapter,colTeam
 	dim TeamedAdapter,TeamedMemberAdapter,objTeam    
    dim strQuery
 

    'Access the same Team from IANet_TeamOfAdapters 
    strQuery="ASSOCIATORS OF {" & objNetDeviceLogObj.Path_.Path & "} where ResultRole=SameElement"
	Set colTeam = wbemServices.ExecQuery(strQuery)
	
    For Each objTeam In colTeam 'only one team in this collection    	
	    'objFile.WriteLine "Team Name=" & objTeam.Caption modified on 28th June 
	    objFile.WriteLine "Team Name=" & Mid(objTeam.Caption,8)
		objFile.WriteLine "Description=" & objTeam.Description
		objFile.WriteLine "Team Settings Index=" & DeviceIndex				
		'Get Team Mode and Adapter count
		objFile.WriteLine "Team Type=" & objTeam.TeamingMode
		
		objFile.WriteLine "Adapter Count=" & objTeam.AdapterCount	
		'MFO Enabled
		ManageabilityTeam objFile,objNetDeviceLogObj,wbemServices,objTeam

		'Access Members of this Team
		
		strQuery="ASSOCIATORS OF {" & objTeam.Path_.Path & "} where ResultRole=PartComponent"   
		Set colTeamedAdapters = wbemServices.ExecQuery(strQuery) 		
		For Each TeamedAdapter In colTeamedAdapters
		'	objFile.WriteLine "Member Adapter="&TeamedAdapter.Caption	
			objFile.WriteLine "Member Adapter="&TeamedAdapter.OriginalDisplayName
			If bIsUpgrade Then
				objFile.WriteLine "Member PCIDeviceID="&TeamedAdapter.PermanentAddress	'Save MAC address in config file for upgrade scenarios only.
			Else
				objFile.WriteLine "Member PCIDeviceID="&TeamedAdapter.PCIDeviceID
			End if

			'Get Priority settings for this member adapter
			strQuery="REFERENCES OF {" & TeamedAdapter.Path_.Path & "} where ResultClass=IANet_TeamedMemberAdapter"
			Set colTeamedMemberAdapter= wbemServices.ExecQuery(strQuery)
			For Each TeamedMemberAdapter In colTeamedMemberAdapter
				objFile.WriteLine "-Preferred Priority Setting="&TeamedMemberAdapter.AdapterFunction
			Next	
		Next	
	Next
	
End Function		

'*****************************************************************************
Private Function SaveTeamAdvancedSettings(objFile,objNetDevicelogObj,wbemServices)
	dim strQuery
	dim IANET_config
	dim IANet_Obj

	strQuery = "ASSOCIATORS OF {" & objNetDeviceLogObj.Path_.Path & "} WHERE ResultClass = IANet_TeamSetting"
	Set IANet_config = wbemServices.ExecQuery(strQuery)
	
		
		For Each IANet_Obj In IANet_config
			objFile.WriteLine "setting Name=" & IANet_Obj.Caption                             
			objFile.WriteLine "setting Current Value=" & IANet_Obj.CurrentValue
			objFile.WriteLine "setting Description=" & IANet_Obj.Description
		Next	
End Function

'*****************************************************************************
Private Function SaveVlanSettings(objFile,objAdapter,wbemServices)
	dim strQuery
	dim IANet_802dot1VLANService,IANet_VLANSet
	dim IANet_802dot1VLANObj,IANet_VLANObj

		strQuery = "ASSOCIATORS OF {" & objAdapter.Path_.Path & "} WHERE ResultClass = IANet_802dot1QVLANService"
		Set IANet_802dot1VLANService = wbemServices.ExecQuery(strQuery)
		If IANet_802dot1VLANService.Count <> 0 Then 
			For Each IANet_802dot1VLANObj In IANet_802dot1VLANService	      
				strQuery = "ASSOCIATORS OF {" & IANet_802dot1VLANObj.Path_.Path & "} WHERE ResultClass = IANet_VLAN"
				Set IANet_VLANSet = wbemServices.ExecQuery(strQuery)
				If IANet_VLANSet.Count > 0 Then
					For Each IANet_VLANObj In IANet_VLANSet
						objFile.WriteLine "VLAN Name=" & IANet_VLANObj.VLANName
						objFile.WriteLine "VLAN Id=" & IANet_VLANObj.VLANNumber
						If(IANet_VLANObj.ParentType = 0) Then 'If parent is adapter,then only save vlan settings
							SaveVLANAdvancedSettingsForAdapter objFile,IANet_VLANObj,wbemServices	
						Elseif(IANet_VLANObj.ParentType = 1) Then
							SaveVLANAdvancedSettingsForTeam objFile,IANet_VLANObj,wbemServices								
						End if
					Next
				End If
			Next
		End If
End Function

	
'*****************************************************************************
Private Function SaveVLANAdvancedSettingsForAdapter(objFile,objNetDeviceLogObj,wbemServices)
	dim strQuery
	dim IANET_config
	dim IANet_Obj
	strQuery = "ASSOCIATORS OF {" & objNetDeviceLogObj.Path_.Path & "} WHERE ResultClass = IANet_VLANSetting"
	Set IANet_config = wbemServices.ExecQuery(strQuery)
	
		
		For Each IANet_Obj In IANet_config
			objFile.WriteLine "setting Name=" & IANet_Obj.Caption                             
			objFile.WriteLine "setting Current Value=" & IANet_Obj.CurrentValue
			objFile.WriteLine "setting Description=" & IANet_Obj.Description
		Next	
End Function

'*****************************************************************************
'*****************************************************************************
Private Function SaveVLANAdvancedSettingsForTeam(objFile,objNetDeviceLogObj,wbemServices)
	dim strQuery
	dim IANET_config
	dim IANet_Obj
	strQuery = "ASSOCIATORS OF {" & objNetDeviceLogObj.Path_.Path & "} WHERE ResultClass = IANet_VLANSetting"
	Set IANet_config = wbemServices.ExecQuery(strQuery)
	
		
		For Each IANet_Obj In IANet_config
			if(Strcomp(Mid(IANet_Obj.Caption,1,4),"GMRP") = 0) Then
				objFile.WriteLine "setting Name=" & IANet_Obj.Caption                             
				objFile.WriteLine "setting Current Value=" & IANet_Obj.CurrentValue
				objFile.WriteLine "setting Description=" & IANet_Obj.Description
			Elseif(Strcomp(Mid(IANet_Obj.Caption,1,4),"GVRP") = 0) Then
				objFile.WriteLine "setting Name=" & IANet_Obj.Caption                             
				objFile.WriteLine "setting Current Value=" & IANet_Obj.CurrentValue
				objFile.WriteLine "setting Description=" & IANet_Obj.Description
			End if
		Next	
End Function

'*****************************************************************************



'=====================================================================================
'
' Sub:	RestoreSettings(ByVal strFname)
'		Call subs to read file to get all the info. about adapter, Team and VLANs.
'		If there are the same number of adapters as settings then 
'		it will apply the saved settings, as long as the adapters are the same type.  
'		If the adapter is a different type, compatibility
'		is determined by local network speed.  Then applicable settings are applied.
'		If number of settings and adapters are mismatched, user is prompted for selection
'   
'=====================================================================================
Sub RestoreSettings(ByVal strFname)

	Dim strTeamName

	bError = FALSE
	
	'Read File and assign found values to Teams() and Adapters()
	ReadFile(strFname)
	If bError = FALSE Then
	'Remove any existing Teams and VLANs.
	Remove()
	'Create single session to make changes..
	CreateSessions() 
	ValidateAdapters()

	'Cycle as many times as adapter sets in file, check selection and compatibility, then apply
		For Each AdapterObj in AdapterSets
				For index = 0 to (totalAdapters - 1)
					strAdapterName = Adapters(index, 1, 0)			'Adapter Name
					strAdapterPCIDeviceID = Adapters(index, 1, 1)	'Adapter PCIDeviceID or PermanentAddress
					strCapabilities = Adapters(index, 2, 0)			'Capabilities
					strSettingsIndex = Adapters(index, 3, 0)		'Setting Index
				
					If bMisMatch = TRUE Then
						CheckSelected strSettingsIndex
						If bUserInput = TRUE Then
							If bSelected = TRUE Then
							
								If strAdapterName = AdapterObj.Caption Then	
									If (Adapters(index, 0, 1) <> 1) AND (InStr(1,AdapterObj.Caption, "Intel(R) PRO/", 1) <> 0) Then 																				
										ApplyAdapterSettings(strSettingsIndex)										
										Exit For
									End If
								End If
							End If
						End If
					Else
						If strAdapterName = AdapterObj.Caption Then
							If (Adapters(index, 0, 1) <> 1) AND (InStr(1,AdapterObj.Caption, "Intel(R) PRO/", 1) <> 0) Then 
								ApplyAdapterSettings(strSettingsIndex)																			
								Exit For
							End If
						Elseif (bIsUpgrade = True) AND (strAdapterPCIDeviceID = AdapterObj.PermanentAddress) AND (AdapterObj.PermanentAddress <> "") Then
							If (Adapters(index, 0, 1) <> 1) AND (InStr(1,AdapterObj.Caption, "Intel(R) PRO/", 1) <> 0) Then 
								ApplyAdapterSettings(strSettingsIndex)																			
								Exit For
							End If
						Elseif (bIsUpgrade = False) AND (strAdapterPCIDeviceID = AdapterObj.PCIDeviceID) AND (AdapterObj.PCIDeviceID <> "") Then
							If (Adapters(index, 0, 1) <> 1) AND (InStr(1,AdapterObj.Caption, "Intel(R) PRO/", 1) <> 0) Then 
								ApplyAdapterSettings(strSettingsIndex)																			
								Exit For
							End If
						End If
					End If
				Next				
		Next	
		ExecApply wbemServices, strNetSerObjPath, SessionObject	'SCR 37163

				
		For index = 0 to (totalTeams - 1)
			strSettingsIndex = Teams(index, 1, 2)
			strTeamName = Teams(index, 0, 0)
			If bMisMatch = TRUE Then
				'Sets bSelected
				CheckSelected strSettingsIndex
				If bSelected = TRUE Then					
					ApplyTeamSettings(strSettingsIndex)					
				End If			
			Else
				ApplyTeamSettings(strSettingsIndex)								
			End If
		Next
'		If bModified = TRUE Then
'			ExecApply wbemServices, strNetSerObjPath, SessionObject						
'		ElseIf bHasTeamOrVLAN = true Then 
'			ExecApply wbemServices, strNetSerObjPath, SessionObject  				

'		ElseIf bNewTeam = TRUE Then
'			ExecApply wbemServices, strNetSerObjPath, SessionObject 		

'		End If
	
		If bNewTeam  = TRUE Then
			WScript.Echo  "New team(s) were created based on settings file"						
		ElseIf bModified = TRUE Then 'or bExpressTeam = TRUE Then
			WScript.Echo "New Settings were applied!"
		ElseIf bUserInput = TRUE Then
			WScript.Echo "No new settings were applied.  Any existing teams were deleted."
		Else
			WScript.Echo "No new settings were applied.  Any existing teams were deleted."
		End If
	ElseIf bError = TRUE Then
		Exit Sub
	End If			

	ReleaseHandle wbemServices, strNetSerObjPath, SessionObject 
	
	RestoreStaticIPSettings(IPFilePath)

End Sub
	
'=====================================================================================
'
' Sub:	Sub ExecApply(ByVal wbemServices, ByVal strNetSerObjPath, ByVal SessionObject)
'  
'=====================================================================================
Sub ExecApply(ByVal wbemServices, ByVal strNetSerObjPath, ByVal SessionObject)
	Dim StdOut,oReg,strComputer,strKeyPath,strValueName,strValue
	
	WScript.Echo "Executing apply..."	
	Set NetServiceObject = wbemServices.Get(strNetSerObjPath)
	Set FinalTargetobj = NetServiceObject.ExecMethod_("Apply", SessionObject)
	'WScript.Echo "FinalTargetobj.FollowupAction" & FinalTargetobj.FollowupAction
	if FinalTargetobj.FollowupAction = 1 Then
		WScript.Echo "FinalTargetobj.FollowupAction" & FinalTargetobj.FollowupAction
		strComputer = "."
		Set StdOut = WScript.StdOut
		Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\" &_ 
		strComputer & "\root\default:StdRegProv")
		strKeyPath ="SOFTWARE\INTEL\Network_Services\DMIX"
		strValueName = "RebootReq"
		strValue = "1"
		oReg.SetStringValue HKEY_LOCAL_MACHINE,strKeyPath,strValueName,strValue
	End if
	
End Sub

'=====================================================================================
'
' Sub:	Sub ReleaseHandle(ByVal wbemServices, ByVal strNetSerObjPath, ByVal SessionObject)
'  
'=====================================================================================
Sub ReleaseHandle(ByVal wbemServices, ByVal strNetSerObjPath, ByVal SessionObject)
	WScript.Echo "Releasing Session Handle"
	Set NetServiceObject = wbemServices.Get(strNetSerObjPath)
	Set FinalTargetobj = NetServiceObject.ExecMethod_("Apply", SessionObject)
End Sub

'==================================================================================================
'
' CreateSessions()
' Create sessions to make settings changes
'
'==================================================================================================

Sub CreateSessions()

	Dim IANet_NetServiceClassDescription,cstring
	Dim Method 
	Dim ServiceObject,TempObj
	Set wbemServices = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/IntelNcs2")	
	' SCR fix for 38688 and 39528
	wbemServices.Security_.Privileges.AddAsString "SeLoadDriverPrivilege", True
	Set IANet_NetServiceClassDescription = wbemServices.Get("IANet_NetService")
	Set SessionObject = IANet_NetServiceClassDescription.Methods_.Item("Apply").InParameters.SpawnInstance_()  
	
	Set SValueSet = CreateObject("WbemScripting.SWbemNamedValueSet")
	Set NetServiceSet = wbemServices.InstancesOf("IANet_NetService")

	For Each NetServiceObject In NetServiceSet	
		strNetSerObjPath = NetServiceObject.Path_.Path	
		Set Method = NetServiceObject.Methods_("BeginApply")			' Save the path for later use
		Set ServiceObject = NetServiceObject.ExecMethod_("BeginApply")
		If ServiceObject.returnValue = 0 Then
			cstring = ServiceObject.ClientSetHandle
		End If
	
	Next
	
	SValueSet.Add "ClientSetId", cstring
	SessionObject.ClientSetHandle = cstring	

	Set AdapterSets = wbemServices.InstancesOf("IANet_PhysicalEthernetAdapter",,SValueSet)	
	'Remove any existing teams or vlans

'	Set VLANObjSet = wbemServices.InstancesOf("IANet_VLAN",,SValueSet)
'	For Each VLANObj In VLANObjSet				
'		bHasTeamOrVLAN = TRUE 
'		WScript.Echo "Removing any existing VLAN's..."
'		VLANObj.Delete_ 0, SValueSet
'	Next 

	
'	Set TeamsObjSet = wbemServices.InstancesOf("IANet_TeamOfAdapters",,SValueSet)
'	For Each TeamObj In TeamsObjSet		
'		WScript.Echo "Removing any existing Teams..."
'		bHasTeamOrVLAN = True		
'		TeamObj.Delete_ 0, SValueSet
'	Next
	'Remove Express Team
	'RemoveExpressTeams()
	
	'If (StrComp(strOrgDispName,"" , vbTextCompare)) <> 0 Then 
	'	CreateExpressTeam()
	'End if
End Sub

'======================================================================================
'
' Sub ValidateInput(ByVal strInput)
'Validate input by removing any spaces or periods in strInput, returns strChoices
'========================================================================================
Sub ValidateInput(ByVal strInput)

	Dim i, ii, arrChoices
	arrChoices = Split(strInput, ",")
	For i = 0 to Ubound(arrChoices)
		arrChoices(i) = Trim(arrChoices(i))
		If Right(arrChoices(i), 1) = "." Then
			arrChoices(i) = Replace(arrChoices(i), ".", "")
		End If
	Next
	strChoices = Join(arrChoices, ",")
End Sub

'=================================================================================================
'
' Sub ReadFile(ByVal strFname)
' Read File and assign found values to Adapters() and Teams() arrays
'
'=================================================================================================
Sub ReadFile(ByVal strFname)

	Dim v, i, ii, x, fso, strAdapterName ,w
	Dim strAdapterCaps, strNewAdapterName, strPCIDeviceID, strAdapterIndex 
	Dim strCapabilities, strSettingsSet, arrSettingsSets
	Dim strIsDefault, ts, strLine, z, numVLANS, numTVLANS
	
	Set fso = CreateObject("Scripting.FileSystemObject")
	If fso.FileExists (strFname) <> True Then
		Wscript.Echo "The configuration file can not be found or is"
		Wscript.Echo "not in the same directory as SavResDX.vbs."
		WScript.Echo "Try using full pathname to the configuration file."
		bError = TRUE
		Exit Sub
	Else
	
		' Array Adapters holds all the info. about the adapter's and related VLANs info.
		' Adapters( , 0, 0) is a flag of Adapter's existence
		' Adapters( , 0, 1) is a flag for setting having been applied
		' Adapters( , 0, 2) is Number of VLANS on Adapter
		' Adapters( , 1, 0) is Adapter's Name
		' Adapters( , 1, 1) is Adapter's PCIDeviceID or PermanentAddress
		' Adapters( , 2, 0) is Adapter's Capabilities
		' Adapters( , 3, 0) is Settings Index, for selecting settings sets
		' Adapters( , 3, 1) is Settings Default, "TRUE" or "FALSE" for selecting settings sets
		' Adapters( , 4, 0) is Adapter's Setting Name 
		' Adapters( , 4, 1) is Adapter's Setting value
		'
		' Adapters( , x, 0) is Keyword "VLAN", any elements after this keyword are VLAN's setting name and value 
		
		Redim Adapters(maxAdapterTeam, maxSettings, 5)  
		
		' Array Teams holds all the info. about the Team's and related VLANs info.
		' Teams( , 0, 0) is Team's Name
		' Teams( , 0, 1) is a flag for setting having been applied
		' Teams( , 0, 2) is number of VLANS on Team
		' Teams( , 1, 0) is Team's Type
		' Teams( , 1, 1) is Team's Adapter Count
		' Teams( , 1, 2) is Teams Settings Index for user selection
		
		' Teams( , 2, 0) is keyword "MemberAdapter", 
		' Teams( , 2, 1) is Member adapter's caption
		' Teams( , 2, 2) is Member adapter's flag for client(0) or server(1) property
		' Teams( , 2, 3) is Member adapter's Preferred Priority Setting
		' Teams( , 2, 4) is Member adapter's flag for "Already Added to Team" (1 or 0)
		' Teams( , 2, 5) is Member adapter's PCIDeviceID or PermanentAddress
		'
		' Teams( , x, 0) is keyword "MemberAdapter", 
		' Teams( , x, 1) is related adapter's caption
		' Teams( , x+1, 0) is Teams's Setting Name; Teams( , x+1, 1) is team's Setting value
		' Teams( , y, 0) is Keyword "VLAN", any elements after this keyword are VLAN's setting name and value 
		Redim Teams(maxAdapterTeam, maxSettings, 10)  

		totalAdapters = 0
		totalTeams = 0

		' Read the text file and save all the info. to two arrays - Adapters() & Teams()
		Set ts = fso.OpenTextFile(strFname, 1)
		ii = 0
		v = 0
		x = 0
		w=0
		Do Until ts.AtEndOfStream
			
			
			ReDim Preserve arrPrivDesc(v + 1)
			ReDim Preserve arrTeamPrivDesc(x + 1)
			strLine = ts.ReadLine()
			If StrComp(Mid(strLine, 1, 13), "Adapter Name=", vbTextCompare) = 0 Then
				numVLANS = 0  
				strNewAdapterName = Mid(strLine, 14)
				strLine = ts.ReadLine()
				If StrComp(Mid(strLine, 1, 20), "Adapter PCIDeviceID=", vbTextCompare) = 0 Then
					strPCIDeviceID = Mid(strLine, 21)
					strLine = ts.ReadLine()
				End If
				If StrComp(Mid(strLine, 1, 14), "Adapter Index=", vbTextCompare) = 0 Then
					strAdapterIndex = Mid(strLine, 15)
					strLine = ts.ReadLine()	
				End If
				If StrComp(Mid(strLine, 1, 20), "Private Description=", vbTextCompare) = 0 Then
					arrPrivDesc(v) = Mid(strLine, 21) 
					strLine = ts.ReadLine()
					v = v + 1
				End If
				If StrComp(Mid(strLine, 1, 21), "Adapter Capabilities=", vbTextCompare) = 0 Then
					strCapabilities =Mid(strLine, 22)
					strLine = ts.ReadLine()
				End If ' End If strComp for Adapter Capabilities
				strLine = ts.ReadLine()
				
				'Assign found values to array"
				Adapters(totalAdapters, 1, 0) = strNewAdapterName
				Adapters(totalAdapters, 1, 1) = strPCIDeviceID
				Adapters(totalAdapters, 2, 0) = strCapabilities
 		   		Adapters(totalAdapters, 3, 0) = strAdapterIndex              
				Adapters(totalAdapters, 3, 1) = strIsDefault
				
				'assigning settings values"
				i = 4
				
				'SCR 40856
				'strLine = ts.ReadLine() 
				Do while StrComp(strLine, "", vbTextCompare) <> 0
					If StrComp(Mid(strLine, 1, 13), "Setting Name=", vbTextCompare) = 0 Then
						Adapters(totalAdapters, i, 0) = Mid(strLine, 14)	'Setting Name
						strLine = ts.ReadLine()
						Adapters(totalAdapters, i, 1) = Mid(strLine, 23)	'Setting Value
						i = i + 1
						strLine = ts.ReadLine()			' Skip the description
					ElseIf StrComp(Mid(strLine, 1, 10), "VLAN Name=", vbTextCompare) = 0 Then
						Do while StrComp(strLine, "", vbTextCompare) <> 0
							Adapters(totalAdapters, i, 0) = "VLAN"				'Set up keyword for searching VLAN later
							numVLANS = numVLANS + 1
							Adapters(totalAdapters, 0, 2) = numVLANS
							Adapters(totalAdapters, i+1, 0) = Mid(strLine, 11)	'VLAN Name
							strLine = ts.ReadLine()
							Adapters(totalAdapters, i+2, 0) = Mid(strLine, 9)	'VLAN ID
							i = i + 3
							strLine = ts.ReadLine()
							Do While StrComp(Mid(strLine, 1, 10), "VLAN Name=", vbTextCompare) <> 0
								If StrComp(Mid(strLine, 1, 13), "Setting Name=", vbTextCompare) = 0 Then
									Adapters(totalAdapters, i, 0) = Mid(strLine, 14)	'Setting Name																											
									strLine = ts.ReadLine()									
									Adapters(totalAdapters, i, 1) = Mid(strLine, 23)	'Setting Value									
									strLine = ts.ReadLine()
								End If
								If strLine <> "" Then
									strLine = ts.ReadLine()
									i = i + 1
								Else
									Exit Do
								End If
							Loop
						Loop
					End If  
					If StrComp(strLine, "", vbTextCompare) <> 0 Then
						strLine = ts.ReadLine()
					End If
				Loop
				totalAdapters = totalAdapters + 1
			ElseIf StrComp(Mid(strLine, 1, 10), "Team Name=", vbTextCompare) = 0 Then
				Teams(totalTeams, 0, 0) = Mid(strLine, 11)
				strLine = ts.ReadLine()
				strLine = ts.ReadLine()	'Skip Description line
				If StrComp(Mid(strLine, 1, 20), "Team Settings Index=", vbTextCompare) = 0 Then
					Teams(totalTeams, 1, 2) = Mid(strLine, 21)
					strLine = ts.ReadLine()
				End If
				If StrComp(Mid(strLine, 1, 10), "Team Type=", vbTextCompare) = 0 Then
					Teams(totalTeams, 1, 0) = Mid(strLine, 11)
					strLine = ts.ReadLine()
				End If
				If StrComp(Mid(strLine, 1, 14), "Adapter Count=", vbTextCompare) = 0 Then
					Teams(totalTeams, 1, 1) = Mid(strLine, 15)
					strLine = ts.ReadLine()
				End If			
			
				'Added for MFO on 17th Feb
				If StrComp(Mid(strLine, 1, 11), "MFOEnabled=", vbTextCompare) = 0 Then
					'bMFOEnabled =Mid(strLine, 12)
					Teams(totalTeams, 1, 3)=Mid(strLine, 12)						
					strLine = ts.ReadLine()					
				Else
					Teams(totalTeams, 1, 3)=0
				End If 
				
				If StrComp(Mid(strLine, 1, 20), "Private Description=", vbTextCompare) = 0 Then
					arrTeamPrivDesc(x) = Mid(strLine, 21)
					x = x + 1
					strLine = ts.ReadLine()
				End If				
				i = 2
				Do While StrComp(Mid(strLine, 1, 15), "Member Adapter=", vbTextCompare) = 0
					Dim vi
					Teams(totalTeams, i, 0) = "MemberAdapter"
					Teams(totalTeams, i, 1) = Mid(strLine, 16)
					strLine = ts.Readline()
					If StrComp(Mid(strLine, 1, 19), "Member PCIDeviceID=", vbTextCompare) = 0 Then
						Teams(totalTeams, i, 5) = Mid(strLine, 20)
						strLine = ts.Readline()
					End If
					If StrComp(Mid(strLine, 1, 28), "-Preferred Priority Setting=", vbTextCompare) = 0 Then
						Teams(totalTeams, i, 3) = Mid(strLine, 29)
					End If
					strLine = ts.ReadLine()
					i = i + 1
				Loop
				
				
				Do while StrComp(strLine, "", vbTextCompare) <> 0					
					If StrComp(Mid(strLine, 1, 13), "Setting Name=", vbTextCompare) = 0 Then
					
						Teams(totalTeams, i, 0) = Mid(strLine, 14)	'Setting Name
						strLine = ts.ReadLine()						
						Teams(totalTeams, i, 1) = Mid(strLine, 23)	'Setting Value
						i = i + 1
						strLine = ts.ReadLine()						' Skip the description
						strLine = ts.ReadLine()
					ElseIf StrComp(Mid(strLine, 1, 10), "VLAN Name=", vbTextCompare) = 0 Then
						Teams(totalTeams, i, 0) = "VLAN"				'Set up keyword for searching VLAN later
						numTVLANS = numTVLANS + 1
						Teams(totalTeams, 0, 2) = numTVLANS
						Teams(totalTeams, i+1, 0) = Mid(strLine, 11)	'VLAN Name
						strLine = ts.ReadLine()
						Teams(totalTeams, i+2, 0) = Mid(strLine, 9)	'VLAN ID												
						i = i + 3
						strLine = ts.ReadLine()
					End If   
				Loop				
				totalTeams = totalTeams + 1
			End If
		Loop 'Until ts.AtEndOfStream
		ts.Close
	End If
End Sub

'=================================================================================================
'
' Sub ValidateAdapters()
' Check for installed adapter count, check against settings sets and get user input for mismatches.
' Sets strInput and strChoices
'
'=================================================================================================
Sub ValidateAdapters()
	Dim ii, iii, counter
	Dim strTemp, strTeamTemp, strCaptions, bFound
	
	bUserInput = FALSE
	existTotalAdapters = 0
	iii = 0
	'Count existing adapters and assign captions to array for user selection
	For Each AdapterObj In AdapterSets
		'Knock out Non-Intel and disabled adapters		
		If (InStr(1,AdapterObj.Caption, "Intel(R) PRO/", 1) <> 0) AND (AdapterObj.StatusInfo= 3) Then	'StatusInfo=3 (Enabled)
			ReDim Preserve Captions(iii + 1)
			existTotalAdapters = existTotalAdapters + 1
			Captions(iii) = AdapterObj.Caption
			iii = iii + 1	
		End If
	Next

	'Check existing adapters against settings sets and set bFound value accordingly
	For index = 0 to existTotalAdapters - 1
		For Each AdapterObj In AdapterSets
			If StrComp(AdapterObj.Caption, Adapters(index, 1, 0)) = 0 Then	'Adapter's Name
				bFound = True
			Elseif (bIsUpgrade = True) AND (StrComp(AdapterObj.PermanentAddress, Adapters(index, 1, 1)) = 0) AND (AdapterObj.PermanentAddress <> "") Then	'Adapter's PermanentAddress
				bFound = True
			Elseif (bIsUpgrade = False) AND (StrComp(AdapterObj.PCIDeviceID, Adapters(index, 1, 1)) = 0) AND (AdapterObj.PCIDeviceID <> "") Then			'Adapter's PCIDeviceID
				bFound = True
			End If
		Next
		If bFound = TRUE Then
			Adapters(index, 0, 0) = TRUE  'Adapter existence flag
		Else
			Adapters(index, 0, 0) = FALSE
		End If
	Next

	'Set string of adapter settings captions for user selection
	For ii = 0 to (totalAdapters - 1) 
		If Adapters(ii, 1, 0) <> "" Then
			strTemp = strTemp & Adapters(ii, 3, 0) & ". " & Adapters(ii, 1, 0) & (Chr(10) & Chr(13)) & "    Priv Desc:  " & arrPrivDesc(ii) & (Chr(10) & Chr(13))
			'<SettingsIndex> + ". " + <AdapterName> + 
			'Newline + 
			'Return + "Priv Desc:  " + <PrivateDesc> + 
			'Newline + 
			'Return
		End If
	Next
	'Set string of team descriptions for user selection
	For ii = 0 to (totalTeams - 1) 
		If Teams(ii, 0, 0) <> "" Then
			strTeamTemp = strTeamTemp & Teams(ii, 1, 2) & "." & Teams(ii, 0, 0) & (Chr(10) & Chr(13))
			counter = counter + 1
		End If
	Next

	'Set string of installed adapter captions for user selection
	For ii = 0 to Ubound(Captions)
		If Captions(ii) <> "" Then
			strCaptions = strCaptions & Captions(ii) & (Chr(10) & Chr(13))
		End If
	Next

	'Checking number of installed adapters vs. settings list, prompt user if the numbers don't match"
	bMisMatch = FALSE

'	If existTotalAdapters < (totalAdapters) Then
'		bMisMatch = TRUE
'		strInput = InputBox("There are " & existTotalAdapters & " installed adapters and " & totalAdapters & " adapter configuration sets contained in " & strFname & "."  & (Chr(10) & Chr(13)) & (Chr(10) & Chr(13)) & "Installed Adapters:  " & (Chr(10) & Chr(13)) & strCaptions & (Chr(10) & Chr(13)) & "Enter selections separated by commas, no spaces or periods."  & (Chr(10) & Chr(13)) &  "Adapter Sets-" & (Chr(10) & Chr(13)) & strTemp & (Chr(10) & Chr(13)) & "Team Sets-  " & (Chr(10) & Chr(13)) & strTeamTemp, "Mismatched Settings Sets")
'		If strInput <> "" Then
'			bUserInput = TRUE
'			ValidateInput strInput
'			
'		Else
'			strInput = InputBox("ERROR:  No Selection Entered!" & (Chr(10) & Chr(13)) & "User-defined descriptions are listed below.  Enter selections to apply, enter numbers separated by commas, no spaces or periods." & (Chr(10) & Chr(13)) & (Chr(10) & Chr(13)) & strTemp & (Chr(10) & Chr(13)) & strTeamTemp, "Enter Selection")
'			If strInput = "" Then
'				WScript.Echo "Script cannot continue without user selection."
'				bUserInput = FALSE
'				Exit Sub
'			Else
'				bUserInput = TRUE
'				ValidateInput strInput
'			End If
'		End If
'	ElseIf existTotalAdapters > totalAdapters Then		
'		bMisMatch = TRUE
'		WScript.Echo "There are not enough settings sets to apply to installed adapters.  Resave or check settings file."
'		bUserInput=FALSE
'		Exit Sub
'	End If
	
End Sub

'=================================================================================================
'
' Sub CheckSelected(ByVal strSettingsIndex)
' Check whether current settings set was selected by any user input, defaults to true if no mismatch
' Sets bSelected to True or False
'
'=================================================================================================
Sub CheckSelected(ByVal strSettingsIndex)
	bSelected = FALSE
	Dim iv, v, b
	If strChoices <> "" Then
		v = InStr(1, strChoices, ",", vbTextCompare)
		If v > 0 Then 
			iv = InStr(1, strChoices, strSettingsIndex, vbTextCompare)
			If iv > 0 Then
				bSelected = TRUE
			End If
		ElseIf (strChoices = strSettingsIndex) Then
				bSelected = TRUE
		End If
	ElseIf bMisMatch = FALSE Then
		bSelected = TRUE
	End If
End Sub

'==================================================================================================
'
' ApplyAdapterSettings(strSettingsIndex)
' Apply selected or all adapter settings and return status message to user
' 
'==================================================================================================
Sub ApplyAdapterSettings(ByVal strSettingsIndex)

	Dim IANet_configur, IANet_Obj, IANetSettingObj
	Dim IANet_802dot1VLANService, IANet_802dot1VLANObj
	Dim IANet_VLANconfigur, IANet_VLANObj, InParameterObj, OutParameterObj
	Dim TempVlanObject, VlanObjectSet,VlanObject, IANet_VLANConfObj,IANet_VLANSet
	Dim strSettingValue,bFoundPossibleValue,bVLAN 
	Dim strVLANName, strVLANID, FinalVlanObject
	Dim strQuery, strExistAdapterName, strExist
	Dim Dumbpath, i, ii, iii, iv, z, b, k, x, cstrPath, pos, intCurCount
	Dim TargetObjInstance, TargetObj, numVLANS,InParameter
	Const wbemFlagUseAmendedQualifiers = &h20000
	Const Temp = TRUE

	Set Dumbpath = CreateObject("WbemScripting.SWbemObjectPath")
	'Setting applied flag to 0
	Adapters(index, 0, 1) = 0

	On Error Resume Next
	'Updating Adapter's settings by checking if selected and if not already applied
	
	strExistAdapterName = AdapterObj.Caption
	If (Adapters(index, 3, 0) = strSettingsIndex) Then
		WScript.Echo "Applying setting set " & strSettingsIndex & " to " & AdapterObj.Caption 
		If Adapters(index, 0, 0) Then	' Check if this adapter exists from previous validation sequence (Adapter Existence flag)
			strAdapterName = Adapters(index, 1, 0)			' Get Adapter's Name from this settings set 
			strSettingsIndex = Trim(strSettingsIndex)
		
			Adapters(index, 0, 1) = 1  ' Flag for setting being applied
			
			strQuery = "ASSOCIATORS OF {" & AdapterObj.Path_.Path & "} WHERE ResultClass = IANet_AdapterSetting"
			Set IANet_configur = wbemServices.ExecQuery(strQuery,,,SValueSet)			
							
				Dim j
				For j = 4 to maxSettings-1
					If StrComp(Adapters(index, j, 0), "", vbTextCompare) = 0 then   'Adapter setting Name
						Exit For						
						
					ElseIf bVLAN Then
						For x = 0 to numVLANS - 1
						
							Set TempVlanObject = wbemServices.Get("IANet_802dot1QVLANService", ,SValueSet)
							Set InParameterObj = TempVlanObject.Methods_.Item("CreateVLAN").InParameters.SpawnInstance_()
							InParameterObj.Name = Adapters(index, j, 0)						
							InParameterObj.VLANNumber = Adapters(index, j+1, 0)						
							strQuery = "ASSOCIATORS OF {" & AdapterObj.Path_.Path & "} WHERE ResultClass = IANet_802dot1QVLANService"
							Set VlanObjectSet = wbemServices.ExecQuery(strQuery,,,SValueSet)
							
							For Each VlanObject In VlanObjectSet
								Set FinalVlanObject = wbemServices.Get(VlanObject.Path_.Path, ,SValueSet)						
								Set OutParameterObj = FinalVlanObject.ExecMethod_("CreateVLAN", InParameterObj, 0, SValueSet)
								'If Err <> 0 Then 
								'	ErrorCheck()
								'End If
								bModified = TRUE
								Exit For
							Next
							WSCript.Echo "updating VLAN:" & Adapters(index, j, 0) & " settings..."
							For k = j+2 to maxSettings-1
								If StrComp(Adapters(index, k, 0), "", vbTextCompare) = 0 then
									Exit For		
								ElseIf Adapters(index, k, 0) = "VLAN" Then
									Exit For
								Else
									strQuery = "ASSOCIATORS OF {" & AdapterObj.Path_.Path & "}WHERE ResultClass = IANet_802dot1QVLANService"
									Set IANet_802dot1VLANService = wbemServices.ExecQuery(strQuery,,,SValueSet)
									If IANet_802dot1VLANService.Count <> 0 Then 
										For Each IANet_802dot1VLANObj In IANet_802dot1VLANService
											strQuery = "ASSOCIATORS OF {" & IANet_802dot1VLANObj.Path_.Path & "}WHERE ResultClass = IANet_VLAN"
											Set IANet_VLANSet = wbemServices.ExecQuery(strQuery,,,SValueSet)
											For Each IANet_VLANObj In IANet_VLANSet
												If StrComp(IANet_VLANObj.VLANName, Adapters(index, j, 0), vbTextCompare) = 0 Then
												
												strQuery = "ASSOCIATORS OF {" & IANet_VLANObj.Path_.Path & "} WHERE ResultClass = IANet_VLANSetting" 
														Set IANet_VLANconfigur = wbemServices.ExecQuery(strQuery,,,SValueSet)
													For Each IANet_VLANConfObj In IANet_VLANconfigur
														If StrComp(IANet_VLANConfObj.Caption, Adapters(index, k, 0), vbTextCompare) = 0 Then
															If StrComp(IANet_VLANConfObj.CurrentValue, Adapters(index, k, 1), vbTextCompare) <> 0 Then
																IANet_VLANConfObj.CurrentValue = Adapters(index, k, 1)
																Set Dumbpath = IANet_VLANConfObj.Put_ (wbemFlagUseAmendedQualifiers, SValueSet) 
																bModified = True
																Exit For				
															End If
														End If
													Next
												End If
											Next
										Next
									End If
								End If
							Next 
						j = k + 1
						Next
						bVLAN = False
					ElseIf StrComp(Adapters(index, j, 0), "VLAN", vbTextCompare) = 0 Then
						bVLAN = True
						numVLANS = Adapters(index, 0, 2)
					ElseIf StrComp(Adapters(index, j, 0), "", vbTextCompare) <> 0 Then
					    For Each IANet_Obj In IANet_configur
						   If StrComp(Adapters(index, j, 0), IANet_Obj.Caption, vbTextCompare) = 0 Then								
								If StrComp(Adapters(index, j, 1), IANet_Obj.CurrentValue, vbTextCompare) <> 0 Then
									Set IANetSettingObj = wbemServices.Get(IANet_Obj.Path_.Path, ,SValueSet)
									If StrComp(IANet_Obj.Path_.Class, "IANet_AdapterSettingEnum", vbTextCompare) = 0 Then						
										bFoundPossibleValue = False
											
										For I = 0 To UBound(IANet_Obj.PossibleValues)
											If StrComp(IANet_Obj.PossibleValues(I), Adapters(index, j, 1), vbTextCompare) = 0 Then
												IANetSettingObj.CurrentValue = IANet_Obj.PossibleValues(I)
												Set Dumbpath = IANetSettingObj.Put_(wbemFlagUseAmendedQualifiers, SValueSet)
												bModified = True	
												bFoundPossibleValue = True
												Exit For
											End If
										Next
											
										If bFoundPossibleValue = False Then
											WScript.Echo "Can't apply the setting '" & Adapters(index, j, 0) & "' to the new value '" & _
											Adapters(index, j, 1) & "' because the new value is not a possible value."
										End If
									Else
										IANet_Obj.CurrentValue = Adapters(index, j, 1)	
										
										Set Dumbpath = IANet_Obj.Put_(wbemFlagUseAmendedQualifiers,SValueSet)'(wbemChangeFlagUpdateOnly, SValueSet)																
										bModified = True
										Exit For
									End If			
								End If								
							End If
						Next
						
						'Power Saver					
						Set InParameter = AdapterObj.Methods_.Item("SetPowerUsageOptions").InParameters
						If StrComp(Adapters(index, j, 0), "AutoPowerSaveModeEnabled", vbTextCompare) = 0 Then											
							InParameter.AutoPowerSaveModeEnabled = Adapters(index, j, 1)																				
						End if					
						If StrComp(Adapters(index, j, 0), "ReduceSpeedOnPowerDown", vbTextCompare) = 0 Then											
							InParameter.ReduceSpeedOnPowerDown = Adapters(index, j, 1)																				
						End if					
						'If StrComp(Adapters(index, j, 0), "SmartPowerDown", vbTextCompare) = 0 Then					
					'	If StrComp(Adapters(index, j, 0), "SPDEnabled", vbTextCompare) = 0 Then					
					'		InParameter.SmartPowerDown = Adapters(index, j, 1)														
					'	End if					
						If StrComp(Adapters(index, j, 0), "SavePowerNowEnabled", vbTextCompare) = 0 Then											
							InParameter.SavePowerNowEnabled = Adapters(index, j, 1)														
						End if						
						Set OutParam = AdapterObj.ExecMethod_("SetPowerUsageOptions",InParameter,0,SValueSet)					
						
					End If
				Next	
		End If 	
	End If 
End Sub

'=================================================================================================
'
' ApplyTeamSettings(ByVal strSettingsIndex)
' Apply selected settings and return status to user
'
'=================================================================================================
Sub ApplyTeamSettings(ByVal strSettingsIndex)

	Dim TargetObjInstance 
	Dim bTeam, i, j, k, x, intCurCount, TeamAdapObj, TeamAdapObjSet, FinalVlanObject
	Dim IANet_configur, IANet_Obj, IANetSettingObj, TeamsObjSet, cstrPath,temObj
	Dim IANet_802dot1VLANService, IANet_802dot1VLANObj, TeamObjSet1, pos
	Dim IANet_VLANconfigur, IANet_VLANObj, Dumbpath, bTest, VLANObjectSet
	Dim VLANObjSet, VLANObj, b, a, TempVlanObject, InParameterObj, VlanObject
	Dim PartComponentString, GroupComponentString, TargetObj, TeamObj
	Dim TeamObj1, TeamsSet, TeamDeviceId, OutParameterObj, bFoundPossibleValue
	Dim strCapabilities, intTest, arrCaps, strQuery, bVLAN, numTVLANS
	Dim p, r,IANet_Virtualconfigur,temp,jj,adapterCount
	'For GVRP settings restore for Vlans
	Dim IANet_VlanIns,IANet_VlanObject,IANet_VLANSettingIns,IANet_VLANSettingObj
	Const wbemFlagUseAmendedQualifiers = &h20000
	bModified = False
	On Error Resume Next
	
	p=0
	r=2		
	i=5

	CreateSessions() 'SCR 37163
	
	Redim Preserve AdapterPath(1)
	
	If Teams(index, 1, 2) = strSettingsIndex Then	
		
		bTeam = TRUE
		WScript.Echo "Creating Team: " & Teams(index, 0, 0) & "..."
		Set TeamsSet = wbemServices.Get("IANet_TeamOfAdapters",,SValueSet)
		Set InParameterObj = TeamsSet.Methods_.Item("CreateTeam").InParameters.SpawnInstance_()
		adapterCount = Teams(index, 1, 1)
		
		Redim Preserve AdapterPath(adapterCount)

		For jj=0 to adapterCount
			For Each AdapterObj In AdapterSets 
				If AdapterObj.Caption = Teams(index, r, 1) then 						
					AdapterPath(p) = AdapterObj.Path_.Path
					p=p+1
					r=r+1
				Elseif (bIsUpgrade = True) AND (AdapterObj.PermanentAddress = Teams(index, r, 5)) AND (AdapterObj.PermanentAddress <> "") then
					AdapterPath(p) = AdapterObj.Path_.Path
					p=p+1
					r=r+1
				Elseif (bIsUpgrade = False) AND (AdapterObj.PCIDeviceID = Teams(index, r, 5)) AND (AdapterObj.PCIDeviceID <> "") then
					AdapterPath(p) = AdapterObj.Path_.Path
					p=p+1
					r=r+1
				End if
			Next
		Next

		Redim Preserve AdapterPath(p-1)
		InParameterObj.Properties_.Item("Adapters") = AdapterPath		
		InParameterObj.TeamingMode = Teams(index, 1, 0)			
		InParameterObj.TeamName    = Teams(index, 0, 0)		
		InParameterObj.MFOEnable   = Teams(index, 1, 3)	
		Dim TempTeam
		TempTeam = InParameterObj.TeamName 
		Set OutParameterObj = TeamsSet.ExecMethod_("CreateTeam", InParameterObj, 0, SValueSet)		
		
		
		
		If Err <> 0 Then
			WScript.Echo "Adding Adapter Failed..."
			ErrorCheck()
			'If blTenGigFETeamError Then
			'	SetTenGigFERegKey()
			'End If	
		
		Else
			WScript.Echo "Create Team Success!!!"
			bNewTeam = True
		End If
		ExecApply wbemServices, strNetSerObjPath, SessionObject	'SCR 37163
		
		
		CreateSessions() 'SCR 37163
			
		
		WScript.Echo "Applying Team Settings to " & TempTeam
		Set virtualAdapterSets = wbemServices.InstancesOf("IANet_LogicalEthernetAdapter",,SValueSet) 
			
		For each virtualAdapterObj in virtualAdapterSets			
			if StrComp(TempTeam,Mid(virtualAdapterObj.Caption,8), vbTextCompare) = 0 then				
				strQuery = "ASSOCIATORS OF {" & virtualAdapterObj.Path_.Path & "} WHERE ResultClass = IANet_TeamSetting"
				Set IANet_Virtualconfigur = wbemServices.ExecQuery(strQuery,,,SValueSet)
				TeamDeviceId = virtualAdapterObj.DeviceID			
				If Err <> 0 Then
					WScript.Echo "Query Failed..."
					ErrorCheck()	
				End if			
				
			bVLAN = False
			numTVLANS = Teams(index, 0, 2)		
			For j = 4 to maxSettings-1
				If StrComp(Teams(index, j, 0), "", vbTextCompare) = 0 then			
					Exit For	
				ElseIf bVLAN Then										
						Set TempVlanObject = wbemServices.Get("IANet_802dot1QVLANService",,SValueSet)
						Set InParameterObj = TempVlanObject.Methods_.Item("CreateVLAN").InParameters.SpawnInstance_()
						InParameterObj.Name = Teams(index, j, 0)
						InParameterObj.VLANNumber = Teams(index, j+1, 0)								
						j = j + 1
						Set VlanObjectSet = wbemServices.InstancesOf("IANet_802dot1QVLANService", , SValueSet)
						For Each VlanObject In VlanObjectSet								
							If  TeamDeviceId = VlanObject.Name Then															
								Set FinalVlanObject = wbemServices.Get(VlanObject.Path_.Path, ,SValueSet)
								Set OutParameterObj = FinalVlanObject.ExecMethod_("CreateVLAN", InParameterObj, 0, SValueSet)																		
								Exit For
							Else 
								Exit For										
							End If
						Next
						bVLAN = false
						WSCript.Echo "updating VLAN:" & Teams(index, j-1, 0) & " settings..."																		
						For k = j+1 to maxSettings-1
							If StrComp(Teams(index, k, 0), "", vbTextCompare) = 0 then
								Exit For		
							ElseIf Teams(index, k, 0) = "VLAN" Then
								Exit For
							ElseIf StrComp(Teams(index, j, 0), "", vbTextCompare) <> 0 Then		
								Set IANet_VlanIns = wbemServices.InstancesOf("IANet_Vlan",,SValueSet) 
								For Each IANet_VlanObject in IANet_VlanIns													
									If IANet_VlanObject.ParentID = TeamDeviceId then																	
										strQuery = "ASSOCIATORS OF {" & IANet_VlanObject.Path_.Path & "}WHERE ResultClass = IANet_VLANSetting"
										Set IANet_VLANSettingIns = wbemServices.ExecQuery(strQuery,,,SValueSet)								
										For each IANet_VLANSettingObj in IANet_VLANSettingIns																					
											If StrComp(IANet_VLANSettingObj.Caption,Teams(index, k, 0), vbTextCompare) = 0 Then																																						
												If StrComp(IANet_VLANSettingObj.CurrentValue, Teams(index, k, 1), vbTextCompare) <> 0 Then																																													
													IANet_VLANSettingObj.CurrentValue = Teams(index, k, 1)
													Set Dumbpath = IANet_VLANSettingObj.Put_ (wbemFlagUseAmendedQualifiers, SValueSet) 																
													Exit For
												End If										
											End if										
										Next																	
									End if								
								Next					
							End If														
						Next 					
				ElseIf StrComp(Teams(index, j, 0), "VLAN", vbTextCompare) = 0 Then
					bVLAN = True					
					
				ElseIf StrComp(Teams(index, j, 0), "", vbTextCompare) <> 0 Then		
				' Updating Team's Settings
					For Each IANet_Obj In IANet_Virtualconfigur
					  If StrComp(TeamDeviceId, IANet_Obj.ParentId, vbTextCompare) =0 Then
						If StrComp(Teams(index, j, 0), IANet_Obj.Caption, vbTextCompare) = 0 Then
							If StrComp(Teams(index, j, 1), IANet_Obj.CurrentValue, vbTextCompare) <> 0 Then
								If StrComp(IANet_Obj.Path_.Class, "IANet_TeamSettingEnum", vbTextCompare) = 0 Then
									bFoundPossibleValue = False
									For I = 0 To UBound(IANet_Obj.PossibleValues)
										If StrComp(IANet_Obj.PossibleValues(I), Teams(index, j, 1), vbTextCompare) = 0 Then
											IANet_Obj.CurrentValue = IANet_Obj.PossibleValues(I)
											Set Dumbpath = IANet_Obj.Put_(wbemFlagUseAmendedQualifiers, SValueSet)
											bModified = True
											bFoundPossibleValue = True
											Exit For
										End If
									Next
									If bFoundPossibleValue = False Then
										WScript.Echo "Can't apply the new '" & Teams(index, j, 0) & "' setting value of " & Teams(index, j, 1) & "' because the new value is not in the possible value range."
									End If
								Else
									IANet_Obj.CurrentValue = Teams(index, j, 1)
									Set Dumbpath = IANet_Obj.Put_ (wbemFlagUseAmendedQualifiers, SValueSet)									
									bModified = True
									Exit For
								End If			
							End If				
						End If
					  End if
					Next
				
				End If
			Next
			End if
		Next	
	End if
	ExecApply wbemServices, strNetSerObjPath, SessionObject	'SCR 37163
End Sub
'======================================================================================================

'Sub SetTenGigFERegKey()
	'Write a value to the Registry that Team Creation Failed because we found a 10/100 and 10 gig Team	
'	Dim oReg, strKeyPath,strValueName,strValue
'	Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\default:StdRegProv")
'	strKeyPath ="SOFTWARE\INTEL\NIC\Team_FE_10Gig"
'	strValueName = "10Gig_FE_Team"
'	strValue = 1
'	WScript.Echo "Setting the Registry Value"
'	oReg.SetDWORDValue HKEY_LOCAL_MACHINE,strKeyPath,strValueName,strValue	
	

'End Sub
'======================================================================================================
'
' Sub ErrorCheck()
' Displays Error and Extended Error Info to standard output
'
'======================================================================================================
Sub ErrorCheck()
	Dim errExObject, strErrText
	WScript.Echo "Error Number=" & Err.Number
	WScript.Echo "Error Description=" & Err.Description
	Set errExObject = CreateObject("WbemScripting.SWbemLastError")
	If IsNull(errExObject) = FALSE Then
		strErrText = errExObject.GetObjectText_
		WScript.Echo "MOF=" & strErrText
		'If(InStr(1,strErrText, "StatusCode = 10000;", 1) <> 0) then
		'	blTenGigFETeamError = true							
		'End If
	End If
End Sub
'======================================================================================================

'*****************************************************************************************
'Sub RemoveExpressTeams()
'Remove any existing team or vlan instances
'*****************************************************************************************
Sub RemoveExpressTeams()

	For each TempETObject in AdapterSets
		If TempETObject.ExpressTeaming =1 then			
			wscript.echo "Deleting existing Express Team..." 
			Set InParameterETObj = TempETObject.Methods_.Item("ExpressTeam").InParameters.SpawnInstance_()
			InParameterETObj.CreateExpressTeam = FALSE
			Set OutParameterETObj = TempETObject.ExecMethod_("ExpressTeam", InParameterETObj, 0, SValueSet)	
		End if
	Next
End Sub


'*****************************************************************************************
'Sub CreateExpressTeam()
'Creates Express Team
'*****************************************************************************************

Sub CreateExpressTeam()
	For each TempETObject in AdapterSets
			if TempETObject.OriginalDisplayName = strOrgDispName then
				wscript.echo "Creating Express Team on " & strOrgDispName				
				Set InParameterETObj = TempETObject.Methods_.Item("ExpressTeam").InParameters.SpawnInstance_()
				InParameterETObj.CreateExpressTeam = TRUE
				Set OutParameterETObj = TempETObject.ExecMethod_("ExpressTeam", InParameterETObj, 0, SValueSet)
				bExpressTeam = TRUE			
			End if
	Next
End Sub
'*****************************************************************************************
'Sub ManageabilityTeam(objFile,objNetDeviceLogObj,wbemServices,objTeam)
'Checks if ManageabilityTeam is existing
'*****************************************************************************************

Sub ManageabilityTeam(objFile,objNetDeviceLogObj,wbemServices,objTeam)
	dim colAdapters
	On Error Resume Next
	Set colAdapters = wbemServices.InstancesOf("IANet_TeamOfAdapters where MFOEnabled=False")	'Need to implement true case
	If Err <> 0 Then
		WScript.Echo "ManageabilityEnabled property not supported"		
	Else
				objFile.WriteLine "MFOEnabled=" & objTeam.MFOEnabled			
	End If
End Sub
'*****************************************************************************************
'Sub SaveExpressTeamInfo(objFile,objNetDevicePhyObj,wbemServices)
'Saves Express Team Info
'*****************************************************************************************
Sub SaveExpressTeamInfo(objFile,objNetDevicePhyObj,wbemServices)
	dim colAdapters1,objAdapters1
	On Error Resume Next
'	Set colAdapters = wbemServices.InstancesOf("IANet_PhysicalEthernetAdapter where ExpressTeaming=1")	
	

		objFile.WriteLine "Original Display Name=" & objNetDevicePhyObj.OriginalDisplayName
		objFile.WriteLine "ExpressTeam="& objNetDevicePhyObj.ExpressTeaming				


End Sub
'*****************************************************************************************
'*****************************************************************************************
'=======================================================================================
'
' Sub:  Remove()
'	Removes teams and VLANs from the system
'  
'=======================================================================================

Sub Remove()	
	CreateSessions()

	Set VLANObjSet = wbemServices.InstancesOf("IANet_VLAN",,SValueSet)
	For Each VLANObj In VLANObjSet				
		bHasTeamOrVLAN = TRUE 
		WScript.Echo "Removing any existing VLAN's..."
		VLANObj.Delete_ 0, SValueSet
	Next 

	
	Set TeamsObjSet = wbemServices.InstancesOf("IANet_TeamOfAdapters",,SValueSet)
	For Each TeamObj In TeamsObjSet		
		WScript.Echo "Removing any existing Teams..."
		bHasTeamOrVLAN = True		
		TeamObj.Delete_ 0, SValueSet
	Next
	ExecApply wbemServices, strNetSerObjPath, SessionObject	
End Sub

'****************************************************************************

'=====================================================================================
'
' Sub:	RestoreStaticIPSettings(ByVal strInputFname)'
'   
'=====================================================================================

Sub RestoreStaticIPSettings(ByVal strInputFname)

	Dim fso, wbemServices
	Dim VLANSets,VlanObj,TeamSets,TeamObj
	Dim ts, strLine
	Dim IPAddress(),IPSubnet(),DeviceGUID,TeamName,VlanName,AdapterName

		
	Set wbemServices = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/IntelNcs2")		
	wbemServices.Security_.Privileges.AddAsString "SeLoadDriverPrivilege", True	
		
	
	Set fso = CreateObject("Scripting.FileSystemObject")
	
	If fso.FileExists (strInputFname) <> True Then
		Wscript.Echo "The file " & strInputFname
		Wscript.Echo "could not be found."
		Wscript.Echo "Either the file or the directory has been deleted."
		WScript.Echo "Unable to restore Static IP Addresses."	
		bError = TRUE
		Exit Sub
	Else	
		Set ts = fso.OpenTextFile(strInputFname, 1)
		
		ReDim Preserve IPAddress(0)
		ReDim Preserve IPSubnet(0)
			
		Do Until ts.AtEndOfStream		

			strLine = ts.ReadLine()
			If StrComp(strLine,"Team", vbTextCompare) = 0 Then			
				strLine = ts.ReadLine()
				'Store Team Name
				TeamName = Mid(strLine,11)								
				strLine = ts.ReadLine()				
				If StrComp(strLine,"IPAddress", vbTextCompare) = 0 Then
					strLine = ts.ReadLine()					
					'Store IP Address
					IPAddress(0) = strLine				
					'Store IP Subnet
					strLine = ts.ReadLine()							
					IPSubnet(0) = strLine					
					strLine = ts.ReadLine()	
				
					Set TeamSets = wbemServices.InstancesOf("IANet_LogicalEthernetAdapter")			
					For each TeamObj in TeamSets					
						if (StrComp(Mid(TeamObj.Caption,8),TeamName,VbTextCompare) = 0) then
							DeviceGUID = TeamObj.DeviceID							
							SetIPInfo DeviceGUID,IPAddress,IPSubnet				
						End If
					Next
					if(StrComp(strLine,"VLAN", vbTextCompare) = 0) Then					
						Do while StrComp(strLine, "", vbTextCompare) <> 0											
							strLine = ts.ReadLine()
							VlanName = Mid(strLine,11)										
							strLine = ts.ReadLine()	
							If StrComp(strLine,"IPAddress", vbTextCompare) = 0 Then					
								strLine = ts.ReadLine()
								'Store IP Address
								IPAddress(0) = strLine				
								strLine = ts.ReadLine()							
								'Store IP Subnet
								IPSubnet(0) = strLine					
								strLine = ts.ReadLine()	
								Set VLANSets = wbemServices.InstancesOf("IANet_VLAN")			
								For each VlanObj in VLANSets												
									If (StrComp(VlanObj.VLANName,VlanName,VbTextCompare) = 0) then
										If (InStr(1,VlanObj.Caption, TeamName, 1) <> 0) then
											DeviceGUID = VlanObj.Name												
											SetIPInfo DeviceGUID,IPAddress,IPSubnet				
											exit for
										End if
									End If
								Next
							Else
								'wscript.echo"Nothing to set Vlan-Team"			
								'exit do
							End if						
						Loop					
					End if
				ElseIf(StrComp(strLine,"VLAN", vbTextCompare) = 0) Then	
					Do while StrComp(strLine, "", vbTextCompare) <> 0					
						strLine = ts.ReadLine()
						VlanName = Mid(strLine,11)										
						strLine = ts.ReadLine()	
						If StrComp(strLine,"IPAddress", vbTextCompare) = 0 Then					
							strLine = ts.ReadLine()
							'Store IP Address
							IPAddress(0) = strLine				
							strLine = ts.ReadLine()							
							'Store IP Subnet
							IPSubnet(0) = strLine					
							strLine = ts.ReadLine()	
							Set VLANSets = wbemServices.InstancesOf("IANet_VLAN")			
							For each VlanObj in VLANSets												
								If (StrComp(VlanObj.VLANName,VlanName,VbTextCompare) = 0) then
									If (InStr(1,VlanObj.Caption, TeamName, 1) <> 0) then
										DeviceGUID = VlanObj.Name											
										SetIPInfo DeviceGUID,IPAddress,IPSubnet				
										exit for
									End if
								End If
							Next
						Else
							'wscript.echo"Nothing to set Vlan-Team"										
						End if						
					Loop
				Else 
					'wscript.echo"Nothing to set Team"			
				End if				
			ElseIf(StrComp(Mid(strLine,1,13),"Adapter Name=", vbTextCompare) = 0) Then	
				Do while StrComp(strLine, "", vbTextCompare) <> 0				
					AdapterName = Mid(strLine,14)								
					strLine = ts.ReadLine()
				
					If(StrComp(strLine,"VLAN", vbTextCompare) = 0) Then							
						strLine = ts.ReadLine()
						VlanName = Mid(strLine,11)										
						strLine = ts.ReadLine()	
						If StrComp(strLine,"IPAddress", vbTextCompare) = 0 Then					
							strLine = ts.ReadLine()
							'Store IP Address
							IPAddress(0) = strLine											
							strLine = ts.ReadLine()							
							'Store IP Subnet
							IPSubnet(0) = strLine			
							strLine = ts.ReadLine()	
							
							Set VLANSets = wbemServices.InstancesOf("IANet_VLAN")			
							For each VlanObj in VLANSets												
								If (StrComp(VlanObj.VLANName,VlanName,VbTextCompare) = 0) then
									If (InStr(1,VlanObj.Caption, AdapterName, 1) <> 0) then
										DeviceGUID = VlanObj.Name	
										SetIPInfo DeviceGUID,IPAddress,IPSubnet	
									End if			
								End If
							Next
						Else
							'Wscript.echo"Nothing to set vlan-adapter"										
						End if
					End if													
				Loop	
			End if																		
		Loop																			
	End if		
	
End Sub
'=====================================================================================
'=====================================================================================
'Sub SetIPInfo(DeviceGUID,IPAddress,IPSubnet)
'=====================================================================================

Sub SetIPInfo(DeviceGUID,IPAddress,IPSubnet)

	On Error Resume Next 
	dim RebootReq, W32_NetAdapConfigObj	, W32_NetAdapConfig, objWMIService

	RebootReq = 0


	dim jjj
	jjj = 0		
	For jjj=LBound(IPAddress) to UBound(IPAddress)
		wscript.Echo"IPAddress : " & IPAddress(jjj)
		wscript.Echo"IPSubnet : " & IPSubnet(jjj)
	Next 					


	Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\cimv2")
	Set W32_NetAdapConfig = objWMIService.ExecQuery("SELECT * FROM Win32_NetworkAdapterConfiguration WHERE IPEnabled = True")

	If W32_NetAdapConfig.Count > 0 Then
 
		For Each W32_NetAdapConfigObj In W32_NetAdapConfig  			
  			If W32_NetAdapConfigObj.DHCPEnabled Then
  				If (strcomp(W32_NetAdapConfigObj.SettingID,DeviceGUID,vbTextCompare) = 0) then
    				WScript.Echo "Enabling static IP address for "	& W32_NetAdapConfigObj.Description
    				intReturn = W32_NetAdapConfigObj.EnableStatic(IPAddress, IPSubnet)
    				If intReturn = 0 Then      					
      					WScript.Echo "DHCP disabled, static IP address enabled." 
    				ElseIf intReturn = 1 Then
      					RebootReq = RebootReq + 1
     					WScript.Echo "Reboot required."
    				Else
      					WScript.Echo "Unable to enable static IP address."
    				End If
  				Else	
    				WScript.Echo "    Static IP address already enabled."
  				End If
  			End If
		Next
		wscript.echo "IP Information Restored!!!"	
	Else 
		wscript.echo"No IP information available to restore"
	
	End If
	If (RebootReq > 0) Then
  		WScript.Echo VbCrLf & "Restart system for changes to take effect."
	End If	
End Sub
'=====================================================================================
'
' Sub:  SaveStaticIPSettings(ByVal strInputFname)
'		Save Adapter's, team's and VLAN's IP info to a text file.
'  
'=======================================================================================

Sub SaveStaticIPSettings(byVal strOutputFileName)	
	dim colNetDevicesPhysical,colNetDevicesLogical
	dim objNetDevicePhyObj,objFile,objNetDeviceLogObj
	dim wbemServices,objWMIService

	
	'Create a configuration file
	If IsEmpty(CreateIPConfigFile(strOutputFileName)) then
		Exit Sub
	Else
		Set objFile=CreateIPConfigFile(strOutputFileName)
	End If
	objFile.WriteLine "*** NCS2 DMiX IP information  ***"
	objFile.WriteLine "*** Date " & Date & " Time " & Time() & "  ***"
	objFile.WriteLine "**********************************************"
	objFile.WriteLine ""	
	
	Set wbemServices = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/IntelNcs2")	
	wbemServices.Security_.Privileges.AddAsString "SeLoadDriverPrivilege", True
		
	'Get all instances from IANet_PhysicalEthernetAdapter for adapters
	
	Set colNetDevicesPhysical = wbemServices.InstancesOf("IANet_PhysicalEthernetAdapter") 
	For each objNetDevicePhyObj in colNetDevicesPhysical
		If(InStr(1,objNetDevicePhyObj.Caption, "Intel(R) PRO/", 1) <> 0) AND (objNetDevicePhyObj.StatusInfo= 3) then				
				SaveVlanIPSettings objFile, objNetDevicePhyObj, wbemServices				
				SaveIPInfo objFile,objNetDevicePhyObj				
		End if
	Next
	
	objFile.WriteBlankLines(1)
	
	'Get all instances from IANet_LogicalEthernetAdapter for teams
	Set colNetDevicesLogical = wbemServices.InstancesOf("IANet_LogicalEthernetAdapter") 

	For each objNetDeviceLogObj in colNetDevicesLogical		
		SaveTeamIPSettings objFile, objNetDeviceLogObj, wbemServices					
		SaveVlanIPSettings objFile, objNetDeviceLogObj, wbemServices
		SaveIPInfo objFile,objNetDeviceLogObj		
		objFile.WriteBlankLines(1)	
	Next
		
	objFile.WriteBlankLines(1)
	
	objFile.close
	Wscript.Echo "Static IP information saved!"
End Sub


'*****************************************************************************
Private Function CreateIPConfigFile(byVal strOutputFileName)
	dim fso
	dim file
	Dim szTmpFld
	Set fso = CreateObject("Scripting.FileSystemObject")
	szTmpFld = shell.ExpandEnvironmentStrings("%TEMP%")
	If (fso.FolderExists(szTmpFld)) <> True Then
		Wscript.Echo ""
		Wscript.Echo "Unable to create the configuration file required"
		Wscript.Echo "to save the static IP information."
		Wscript.Echo "Static IP information will not be saved."
		bError = TRUE
		Exit Function
	End If
	szTmpFld = szTmpFld & "\PROSetDX\DMIX\"
	'make sure the folder exists before creating the text file
	If (fso.FolderExists(szTmpFld)) <> True Then
		'need to create destination folder one directory at a time
		szTmpFld = shell.ExpandEnvironmentStrings("%TEMP%")
		szTmpFld = szTmpFld & "\PROSetDX"
		If (fso.FolderExists(szTmpFld)) <> True Then
			fso.CreateFolder(szTmpFld)
		End If
		szTmpFld = szTmpFld & "\DMIX"
		fso.CreateFolder(szTmpFld)
		If (fso.FolderExists(szTmpFld)) <> True Then
			Wscript.Echo ""
			Wscript.Echo "Unable to create the configuration file required"
			Wscript.Echo "to save the static IP information."
			Wscript.Echo "Static IP information will not be saved."
			bError = TRUE
			Exit Function
		End If
	End If
	Set file=fso.CreateTextFile(strOutputFileName,True)
	Set CreateIPConfigFile=file

End Function
'*****************************************************************************
Private Function SaveTeamIPSettings(objFile,objNetDeviceLogObj,wbemServices)
 	dim colTeam,objTeam,strQuery
 	 
    strQuery="ASSOCIATORS OF {" & objNetDeviceLogObj.Path_.Path & "} where ResultRole=SameElement"
	Set colTeam = wbemServices.ExecQuery(strQuery)
	
    For Each objTeam In colTeam 'only one team in this collection    		    
	    objFile.WriteLine "Team" 
	    objFile.WriteLine "Team Name=" & Mid(objTeam.Caption,8)
	Next
	
End Function		


'*****************************************************************************
Private Function SaveVlanIPSettings(objFile,objAdapter,wbemServices)
	dim strQuery
	dim IANet_802dot1VLANService,IANet_VLANSet,IANet_802dot1VLANObj,IANet_VLANObj

		strQuery = "ASSOCIATORS OF {" & objAdapter.Path_.Path & "} WHERE ResultClass = IANet_802dot1QVLANService"
		Set IANet_802dot1VLANService = wbemServices.ExecQuery(strQuery)
		If IANet_802dot1VLANService.Count <> 0 Then 			
			For Each IANet_802dot1VLANObj In IANet_802dot1VLANService	      
				strQuery = "ASSOCIATORS OF {" & IANet_802dot1VLANObj.Path_.Path & "} WHERE ResultClass = IANet_VLAN"
				Set IANet_VLANSet = wbemServices.ExecQuery(strQuery)
				If IANet_VLANSet.Count > 0 Then								
					For Each IANet_VLANObj In IANet_VLANSet
						If(IANet_VLANObj.ParentType = 0) Then
							objFile.WriteLine "Adapter Name=" & objAdapter.Caption
							objFile.WriteLine "VLAN"						
							objFile.WriteLine "VLAN Name=" & IANet_VLANObj.VLANName
							SaveIPInfoForVLAN objFile,IANet_VLANObj						
							objFile.WriteBlankLines(1)	
						Else
							objFile.WriteLine "VLAN"						
							objFile.WriteLine "VLAN Name=" & IANet_VLANObj.VLANName
							SaveIPInfoForVLAN objFile,IANet_VLANObj						
						End if						
					Next
				End If
			Next
		End If
End Function

	

'****************************************************************************
Private Function SaveIPInfo(objFile,Adapter)
	dim objNetAdapter,colNetAdapters
	dim objWMIService
	dim GUID,colWMISettings
	dim i
	
	Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/cimv2")
		
	Set colWMISettings = objWMIService.InstancesOf("Win32_NetworkAdapterConfiguration where DHCPEnabled = False") 
	
	For Each objNetAdapter In colWMISettings	
		If strcomp(objNetAdapter.SettingID,Adapter.DeviceID,vbTextCompare) = 0 then			
			If Not IsNull(objNetAdapter.IPAddress) Then					
				objFile.WriteLine "IPADDRESS"
				For i=LBound(objNetAdapter.IPAddress) to UBound(objNetAdapter.IPAddress)
					objFile.WriteLine objNetAdapter.IPAddress(i)            	
				Next
			End If
			If Not IsNull(objNetAdapter.IPSubnet) Then	
				For i=LBound(objNetAdapter.IPSubnet) to UBound(objNetAdapter.IPSubnet)
					objFile.WriteLine objNetAdapter.IPSubnet(i)            		
				Next
			End If		
		End if
	Next		
End Function
'****************************************************************************
Private Function SaveIPInfoForVLAN(objFile,VLANObj)
	dim objNetAdapter,colNetAdapters
	dim objWMIService
	dim GUID,colWMISettings
	dim i
	
	Set objWMIService = GetObject("winmgmts:{impersonationLevel=impersonate}//./root/cimv2")
	
	Set colWMISettings = objWMIService.InstancesOf("Win32_NetworkAdapterConfiguration where DHCPEnabled = False") 
	
	For Each objNetAdapter In colWMISettings	
		If strcomp(objNetAdapter.SettingID,VLANObj.Name,vbTextCompare) = 0 then			
			If Not IsNull(objNetAdapter.IPAddress) Then				
				objFile.WriteLine "IPADDRESS"
				For i=LBound(objNetAdapter.IPAddress) to UBound(objNetAdapter.IPAddress)
					objFile.WriteLine objNetAdapter.IPAddress(i)            	
				Next
			End If
			If Not IsNull(objNetAdapter.IPSubnet) Then	
				For i=LBound(objNetAdapter.IPSubnet) to UBound(objNetAdapter.IPSubnet)
					objFile.WriteLine objNetAdapter.IPSubnet(i)            		
				Next
			End If			
		End if
	Next		
End Function

'*****************************************************************************

