@echo off
rem *******************************************************************************
rem Make sure we are in the right directory
rem *******************************************************************************
if NOT exist .\PUSHCOPY.BAT GOTO WRONGDIR


rem *******************************************************************************
rem %1 = Destination Path
rem %2 = W98 or WME or XP or WS03 or W2K or NT
rem *******************************************************************************

if "%2"=="w98" goto Win9x
if "%2"=="W98" goto Win9x
if "%2"=="wme" goto Win9x
if "%2"=="WME" goto Win9x
if "%2"=="nt"  goto WinNT
if "%2"=="NT"  goto WinNT
if "%2"=="w2k" goto WIN2K
if "%2"=="W2K" goto WIN2K
if "%2"=="xp"  goto WINXP
if "%2"=="XP"  goto WINXP
if "%2"=="ws03"  goto WS03
if "%2"=="WS03"  goto WS03

goto Usage

rem *******************************************************************************
rem 	WIN9X file copies
rem *******************************************************************************
:Win9x

rem *****************************************************
rem copy the base driver files for win9x
rem *****************************************************

rem 10/100 specific files
copy ..\..\..\PRO100\WIN_98ME\e100b9x.inf %1
copy ..\..\..\PRO100\WIN_98ME\e100b9xa.inf %1
copy ..\..\..\PRO100\WIN_98ME\e100b9x.din %1
copy ..\..\..\PRO100\WIN_98ME\E100BNT.SYS %1
copy ..\..\..\PRO100\WIN_98ME\E100BNT5.SYS %1
copy ..\..\..\PRO100\WIN_98ME\8255iNDI.DLL %1
copy ..\..\..\PRO100\WIN_98ME\8255xdel.exe %1
copy ..\..\..\PRO100\WIN_98ME\WOL558.vxd %1

rem Gigabit specific files
copy ..\..\..\PRO1000\WIN_98ME\E1000W9x.INF %1
copy ..\..\..\PRO1000\WIN_98ME\E1000W9x.DIN %1
copy ..\..\..\PRO1000\WIN_98ME\E1000W9x.SYS %1


copy ..\..\TOOLS\DIAGS.EXE %1



rem *******************************************************************************
rem Copy MSBATCH.INF and CUSTOM.INF
rem *******************************************************************************
copy win9x\*.inf            %1

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************

if NOT Exist ..\..\PROSet\WN98SEME\iansw98.sys goto NO9XANS
copy ..\..\PROSet\WN98SEME\iansw98.sys  %1
:NO9XANS

rem *******************************************************************************
rem Copy the NDIS2 DOS driver so network connectivity can be re-established if necessary
rem *******************************************************************************
copy ..\..\..\PRO100\dos\e100bodi.com       %1

rem *******************************************************************************
rem Copy the PROSet files
rem *******************************************************************************
copy ..\..\PROSet\WN98SEME\Proset.exe             %1
copy ..\..\PROSet\WN98SEME\Proset.msi             %1
copy ..\..\PROSet\WN98SEME\instmsia.exe            %1

goto end

rem *******************************************************************************
rem 	WINNT file copies
rem *******************************************************************************
:WinNT
echo *** WinNT file copy


rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$OEM$
md %1\$OEM$\Net
md %1\$OEM$\Net\PRO100
md %1\$OEM$\Net\PRO100\WINNT4
md %1\$OEM$\Net\PRO1000
md %1\$OEM$\Net\PRO1000\WINNT4
md %1\$OEM$\Net\APPS
md %1\$OEM$\Net\APPS\PROSET
md %1\$OEM$\Net\APPS\PROSET\WINNT4

xcopy /s ..\..\..\PRO100\WINNT4\*.* %1\$OEM$\Net\PRO100\WINNT4
xcopy /s ..\..\..\PRO1000\WINNT4\*.* %1\$OEM$\Net\PRO1000\WINNT4
xcopy /s ..\..\..\APPS\PROSET\WINNT4\*.* %1\$OEM$\Net\APPS\PROSET\WINNT4
copy Winnt\*.* %1\$OEM$\Net

goto end

rem *******************************************************************************
rem 	WIN2K file copies
rem *******************************************************************************

:WIN2K
echo *** Win2K file copy

rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\2KXPWS03
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\2KXPWS03\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\W98-WS32
md %1\$oem$\$1\drivers\net\INTEL\PRO100
md %1\$oem$\$1\drivers\net\INTEL\PRO100\WS03XP2K
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\WS03XP2K

rem *************************************************************************
rem  Copy the base driver files
rem *************************************************************************

rem 10/100 specific files to the root OEM directory and to the specific 10/1000/OS directory (needed for setupBD)
copy ..\..\..\PRO100\WS03XP2K\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO100\WS03XP2K

rem Gigabit specific files
copy ..\..\..\PRO1000\WS03XP2K\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\WS03XP2K

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\2KXPWS03\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\PROSetDX\2KXPWS03

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\2KXPWS03\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\PROSetDX\2KXPWS03\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\W98-WS32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\W98-WS32

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

rem *******************************************************************************
rem Copy the sample UNATTEND.TXT, Install.bat and help file
rem *******************************************************************************
copy win2k\pushw2k.txt %1\$oem$\$1\drivers\net\INTEL
copy win2k\unattend.txt %1\$oem$\$1\drivers\net\INTEL
copy win2k\Install.bat %1\$oem$\$1\WMIScr

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\INTELAMT\DRIVERS\WS03XP goto end
md %1\$oem$\$1\drivers\net\INTEL\APPS\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\APPS\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\APPS\INTELAMT\DRIVERS\WS03XP
copy ..\..\INTELAMT\DRIVERS\WS03XP\*.*  %1\$oem$\$1\drivers\net\INTEL\APPS\INTELAMT\DRIVERS\WS03XP

Goto end

rem *******************************************************************************
rem 	WINXP file copies
rem *******************************************************************************
:WINXP
echo *** WinXP file copy

rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\2KXPWS03
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\2KXPWS03\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\W98-WS32
md %1\$oem$\$1\drivers\net\INTEL\PRO100
md %1\$oem$\$1\drivers\net\INTEL\PRO100\WS03XP2K
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\WS03XP2K

REM **********************************************************************
REM  COPY Base driver files for Windows XP
REM **********************************************************************

rem 10/100 specific files to the root OEM directory and to the specific 10/1000/OS directory (needed for setupBD)
copy ..\..\..\PRO100\WS03XP2K\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO100\WS03XP2K

rem Gigabit specific files
copy ..\..\..\PRO1000\WS03XP2K\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\WS03XP2K

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\2KXPWS03\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\2KXPWS03

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\2KXPWS03\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\2KXPWS03\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\W98-WS32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\W98-WS32

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

rem *******************************************************************************
rem Copy the sample UNATTEND.TXT, Install.bat and help file
rem *******************************************************************************
copy WS03XP32\Unattend.txt %1\$oem$\$1\drivers\net\INTEL
copy WS03XP32\Pushxp.txt %1\$oem$\$1\drivers\net\INTEL
copy WS03XP32\Install.bat %1\$oem$\$1\WMIScr

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\INTELAMT\DRIVERS\WS03XP goto end
md %1\$oem$\$1\drivers\net\INTEL\APPS\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\APPS\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\APPS\INTELAMT\DRIVERS\WS03XP
copy ..\..\INTELAMT\DRIVERS\WS03XP\*.*  %1\$oem$\$1\drivers\net\INTEL\APPS\INTELAMT\DRIVERS\WS03XP

Goto end


rem *******************************************************************************
rem 	WINDOWS SERVER 2003 file copies
rem *******************************************************************************
:WS03
echo *** Windows Server 2003 file copy

rem *******************************************************************************
rem Create the OEM driver directory structure
rem *******************************************************************************
md %1\$oem$
md %1\$oem$\$$
md %1\$oem$\$$\system32
md %1\$oem$\$1
md %1\$oem$\$1\WMIScr
md %1\$oem$\$1\drivers
md %1\$oem$\$1\drivers\net
md %1\$oem$\$1\drivers\net\INTEL
md %1\$oem$\$1\drivers\net\INTEL\APPS
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\2KXPWS03
md %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\2KXPWS03\Drivers
md %1\$oem$\$1\drivers\net\INTEL\APPS\Tools
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD
md %1\$oem$\$1\drivers\net\INTEL\APPS\Setup\SetupBD\W98-WS32
md %1\$oem$\$1\drivers\net\INTEL\PRO100
md %1\$oem$\$1\drivers\net\INTEL\PRO100\WS03XP2K
md %1\$oem$\$1\drivers\net\INTEL\PRO1000
md %1\$oem$\$1\drivers\net\INTEL\PRO1000\WS03XP2K

REM **********************************************************************
REM  COPY Base driver files for Windows Server 2003
REM **********************************************************************

rem 10/100 specific files
copy ..\..\..\PRO100\WS03XP2K\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO100\WS03XP2K

rem Gigabit specific files
copy ..\..\..\PRO1000\WS03XP2K\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\PRO1000\WS03XP2K

rem *******************************************************************************
rem Copy the PROSet DX files
rem *******************************************************************************
copy ..\..\PROSetDX\2KXPWS03\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\2KXPWS03

rem *******************************************************************************
rem Copy the ANS files
rem *******************************************************************************
copy ..\..\PROSetDX\2KXPWS03\DRIVERS\*.* %1\$oem$\$1\drivers\net\INTEL\APPS\ProsetDX\2KXPWS03\Drivers

rem *******************************************************************************
rem Copy the SetupBD files
rem *******************************************************************************
copy ..\..\SETUP\SETUPBD\W98-WS32\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Setup\SetupBD\W98-WS32

rem *******************************************************************************
rem Copy the Tools files
rem *******************************************************************************
copy ..\..\Tools\*.* %1\$OEM$\$1\DRIVERS\NET\INTEL\APPS\Tools

rem *******************************************************************************
rem Copy the sample UNATTEND.TXT, Install.bat and help file
rem *******************************************************************************
copy WS03XP32\Unattend.txt %1\$oem$\$1\drivers\net\INTEL
copy WS03XP32\PushWs3.txt %1\$oem$\$1\drivers\net\INTEL
copy WS03XP32\Install.bat %1\$oem$\$1\WMIScr

REM *******************************************************************************
REM Copy the Intel Active Management Technology drivers and Serial Over Lan drivers if avialable
REM *******************************************************************************
if not exist ..\..\INTELAMT\DRIVERS\WS03XP goto end
md %1\$oem$\$1\drivers\net\INTEL\APPS\INTELAMT
md %1\$oem$\$1\drivers\net\INTEL\APPS\INTELAMT\DRIVERS
md %1\$oem$\$1\drivers\net\INTEL\APPS\INTELAMT\DRIVERS\WS03XP
copy ..\..\INTELAMT\DRIVERS\WS03XP\*.*  %1\$oem$\$1\drivers\net\INTEL\APPS\INTELAMT\DRIVERS\WS03XP

Goto end

:WRONGDIR
echo.
echo.
echo PUSHCOPY must be run from the \APPS\SETUP\PUSH directory on the CD or 
echo CD image to work properly.  
echo.
echo  Please change directories to the \APPS\SETUP\PUSH directory before running PUSHCOPY.
echo.
echo.


:Usage
echo.
echo usage rules;
echo pushcopy [Destination Path] [OS]
echo where [destination] is the drive letter and path (such as Z:)
echo       Do not add a trailing backslash (\) to the destination path. 
echo [OS]    = OS family
echo W98     = Microsoft Windows 98 and Windows 98SE*
echo WME     = Microsoft Windows ME*
echo NT      = Microsoft Windows NT*
echo W2K     = Microsoft Windows* 2000
echo XP      = Microsoft Windows XP*
echo WS03    = Microsoft Windows Server 2003*
echo.

:end
