/*******************************************************************************

  
  Copyright(c) 2003 - 2005 Intel Corporation. All rights reserved.
  
  This program is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2 of the License, or (at your option) 
  any later version.
  
  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called LICENSE.
  
  Contact Information:
  Linux NICS <linux.nics@intel.com>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497
  
  file: eider_main.c
  part of "Intel(R) Active Management Technology - IDER" Linux driver 

*******************************************************************************/
#include <linux/config.h>
#include <linux/types.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/ioport.h>
#include <linux/pci.h>
#include <linux/hdreg.h>
#include <linux/ide.h>
#include <linux/delay.h>
#include <linux/init.h>
#include <linux/version.h>
#include <asm/io.h>


#include "eider.h"


extern void ide_setup_pci_device(struct pci_dev *, ide_pci_device_t *);

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0))
extern void probe_hwif(ide_hwif_t *hwif);
extern int hwif_init(ide_hwif_t *hwif);
#endif

static unsigned int __init init_chipset_ider (struct pci_dev *dev, const char *name)
{
	return 0;
}

/**
 *	init_setup_ider		-	callback for IDE initialize
 *
 */
 
static void __init init_setup_ider (struct pci_dev *dev, ide_pci_device_t *d)
{
	ide_setup_pci_device(dev, d);
}

static void __init init_hwif_ider (ide_hwif_t *hwif)
{
	if (!(hwif->dma_base))
		return;

	hwif->autodma = 0;
	hwif->drives[0].autodma = 0;
	hwif->drives[1].autodma = 0;
}

static void init_dma_ider (ide_hwif_t *hwif, unsigned long dmabase)
{
	ide_setup_dma(hwif, dmabase, 8);
}

static struct pci_device_id ider_pci_tbl[] __devinitdata = {
	{ PCI_VENDOR_ID_INTEL, PCI_DEVICE_ID_INTEL_AMT_IDER, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{ 0, },
};

static int __devinit ider_init_one(struct pci_dev *dev, const struct pci_device_id *id)
{
	ide_pci_device_t *d = &ider_pci_info[id->driver_data];
	u16 command;
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0))
	int i;
#endif

	if (dev->device != d->device)
	  BUG();

	pci_read_config_word(dev, PCI_COMMAND, &command);
	if(!(command & PCI_COMMAND_IO))
	{
		printk(KERN_INFO "Skipping disabled %s IDE controller.\n", d->name);
		return 1; 
	}
	ide_setup_pci_device(dev, d);

    // in 2.4 kernel ide_setup_pci_device doesn't call probe_hwif and hwif_init. 
    // since we are after init (loadable module) we need to call them explicitly.
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0))	
	for(i=0;i<MAX_HWIFS;i++) {
		if (ide_hwifs[i].pci_dev == dev) {
			probe_hwif(&ide_hwifs[i]);
			hwif_init(&ide_hwifs[i]);
            break;
		}
	}
#endif

    // proc has been already created so we need to recreate with our device.
	create_proc_ide_interfaces();
  
	return 0;
}

void ider_remove (struct pci_dev *dev) {
    int i;
    for(i=0;i<MAX_HWIFS;i++) {
        if (ide_hwifs[i].pci_dev == dev) {
            ide_unregister(i);
            /*
            if (ide_hwifs[i].proc) {            
                ide_remove_proc_entries(ide_hwifs[i].proc, hwif_entries);
                remove_proc_entry(ide_hwifs[i].name, proc_ide_root);
                ide_hwifs[i].proc = NULL;
            }
            */
            break;
        }
    }
}

static struct pci_driver driver = {
	.name		= "EIDER",
	.id_table	= ider_pci_tbl,
	.probe		= ider_init_one,
    .remove     = ider_remove,
};

static int ider_init(void)
{
  return ide_pci_register_driver(&driver);
}


static void ider_exit(void)
{
  ide_pci_unregister_driver(&driver);
}
module_init(ider_init);
module_exit(ider_exit);

MODULE_AUTHOR("Intel, Intel");
MODULE_DESCRIPTION("Intel(R) Active Management Technology - IDE-R, Linux driver");
MODULE_LICENSE("GPL");
