/*******************************************************************************

  
  Copyright(c) 2003 - 2005 Intel Corporation. All rights reserved.
  
  This program is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2 of the License, or (at your option) 
  any later version.
  
  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called LICENSE.
  
  Contact Information:
  Linux NICS <linux.nics@intel.com>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497
  
  file: eider.h
  part of "Intel(R) Active Management Technology - IDER" Linux driver 

*******************************************************************************/
#ifndef EIDER_H
#define EIDER_H

#include <linux/config.h>
#include <linux/pci.h>
#include <linux/ide.h>

#define PCI_DEVICE_ID_INTEL_AMT_IDER 0x108D

static void init_setup_ider(struct pci_dev *, ide_pci_device_t *);
static unsigned int __devinit init_chipset_ider(struct pci_dev *, const char *);
static void init_hwif_ider(ide_hwif_t *);
static void init_dma_ider(ide_hwif_t *, unsigned long);


/*
 *	Table of the various IDER capability blocks
 *
 */
static ide_pci_device_t ider_pci_info[] __devinitdata = {
	{	/* 0 */
		.vendor		= PCI_VENDOR_ID_INTEL,
		.device		= PCI_DEVICE_ID_INTEL_AMT_IDER,
		.name		= "EIDER",
		.init_setup	= init_setup_ider,
		.init_chipset	= init_chipset_ider,
		.init_iops	= NULL,
		.init_hwif	= init_hwif_ider,
		.init_dma	= init_dma_ider,
		.channels	= 1,
		.autodma	= NODMA,
		.enablebits	= {{0x00,0x00,0x00}, {0x00,0x00,0x00}},
		.bootable	= OFF_BOARD,
		.extra		= 0,
	}, {
		.vendor		= 0,
		.device		= 0,
		.channels	= 0,
		.init_setup	= NULL,
		.bootable	= EOL,
	}
};

#endif /* EIDER_H */
