
#define __NO_VERSION__
#include <sound/driver.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/fs.h>
#include <asm/uaccess.h>
#include <linux/init.h>
#include <linux/slab.h>
#include <linux/pci.h>
#include <linux/delay.h>
#include <linux/list.h>

#include <linux/version.h>
#if 0
static nid_converter_t alc880_converter_nids[] = {
	// format = {number of ADC, number of DAC, list of ADC nids {adc0, adc1, adc2, etc}, list of DAC nids {front, rear, clfe, rear_surr, etc.}
	{3, 4, {0x7, 0x8, 0x9}, {0x2, 0x5, 0x4, 0x3}},	// Three Stack Digital Implementation
	{3, 4, {0x7, 0x8, 0x9}, {0x2, 0x5, 0x4, 0x3}},	// Three Stack Implementation
	{3, 4, {0x7, 0x8, 0x9}, {0x2, 0x5, 0x4, 0x3}},	// Five Stack Digital Implementation
	{3, 4, {0x7, 0x8, 0x9}, {0x2, 0x5, 0x4, 0x3}},	// Five Stack Implementation
	{0, 0, {0x0}, {0x0}},
};

#define AZX_CODEC_CUSTOM(xname, info_func, get_func, put_func, private_val) \
{ .iface = SNDRV_CTL_ELEM_IFACE_MIXER, .name = xname, .info = info_func, \
  .get = get_func, .put = put_func, \
  .private_value = private_val }

snd_kcontrol_new_t three_stack_rear_panel_mixer[] = {
//	AZX_CODEC_VOLUME("control name here", nid, index, direction, max_val, type)
	AZX_CODEC_VOLUME("PCM Front Playback Volume", 0x0C, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("PCM Front Playback Switch", 0x14, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("PCM Rear Playback Volume", 0x0F, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("PCM Rear Playback Switch", 0x1A, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("PCM C/LFE Playback Volume", 0x0E, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("PCM C/LFE Playback Switch", 0x18, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("CD Playback Volume", 0x0B, 0x04, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("CD Playback Switch", 0x0B, 0x04, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Line Playback Volume", 0x0B, 0x02, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Line Playback Switch", 0x0B, 0x02, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Mic-1 Playback Volume", 0x0B, 0x0, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Mic-1 Playback Switch", 0x0B, 0x0, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Mic-2 Playback Volume", 0x0B, 0x3, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Mic-2 Playback Switch", 0x0B, 0x3, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Headphone Playback Volume", 0x0D, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("Headphone Playback Switch", 0x19, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Capture Volume", 0x07, 0x0, INPUT, 0x23, VOLUME),
//	AZX_CODEC_ENUM("Capture Source", 0x07, 0x0),
	AZX_CODEC_CUSTOM("Channel Source", snd_azx_mux_info, snd_azx_mux_get, snd_azx_mux_put, 0x0)
};

snd_kcontrol_new_t base_panel_mixer[] = {
//	AZX_VOLUME("control name here", nid, index, direction, max_val, type)
	AZX_CODEC_VOLUME("Stereo Playback Volume", 0x0C, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("Stereo Playback Switch", 0x14, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("CD Playback Volume", 0x0B, 0x04, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("CD Playback Switch", 0x0B, 0x04, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Line Playback Volume", 0x0B, 0x02, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Line Playback Switch", 0x0B, 0x02, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Mic Playback Volume", 0x0B, 0x0, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Mic Playback Switch", 0x0B, 0x0, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Capture Volume", 0x07, 0x0, INPUT, 0x23, VOLUME),
//	AZX_CODEC_ENUM("Capture Source", 0x07, 0x01)
};

snd_kcontrol_new_t five_stack_rear_panel_mixer[] = {
//	AZX_CODEC_VOLUME("control name here", nid, index, direction, max_val, type)
	AZX_CODEC_VOLUME("Front Playback Volume", 0x0C, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("Front Playback Switch", 0x14, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Surround Playback Volume", 0x0F, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("Surround Playback Switch", 0x17, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("C/LFE Playback Volume", 0x0E, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("C/LFE Playback Switch", 0x16, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("CD Playback Volume", 0x0B, 0x04, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("CD Playback Switch", 0x0B, 0x04, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Line Playback Volume", 0x0B, 0x02, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Line Playback Switch", 0x0B, 0x02, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Mic-1 Playback Volume", 0x0B, 0x0, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Mic-1 Playback Switch", 0x0B, 0x0, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Mic-2 Playback Volume", 0x0B, 0x3, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Mic-2 Playback Switch", 0x0B, 0x3, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Headphone Playback Volume", 0x0D, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("Headphone Playback Switch", 0x19, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Capture Volume", 0x07, 0x0, INPUT, 0x23, VOLUME),
//	AZX_ENUM("control name", nid, index into the enum list where the NID is associated with the selection)
//	AZX_CODEC_ENUM("Capture Source", 0x07, 0x0)
};

snd_kcontrol_new_t five_stack_rear_panel_digital_mixer[] = {
//	AZX_CODEC_VOLUME("control name here", nid, index, direction, max_val, type)
	AZX_CODEC_VOLUME("PCM Front Playback Volume", 0x0C, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("PCM Front Playback Switch", 0x14, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("PCM Rear Playback Volume", 0x0F, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("PCM Rear Playback Switch", 0x17, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("PCM C/LFE Playback Volume", 0x0E, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("PCM C/LFE Playback Switch", 0x16, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("CD Playback Volume", 0x0B, 0x04, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("CD Playback Switch", 0x0B, 0x04, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Line Playback Volume", 0x0B, 0x02, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Line Playback Switch", 0x0B, 0x02, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Mic-1 Playback Volume", 0x0B, 0x0, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Mic-1 Playback Switch", 0x0B, 0x0, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Mic-2 Playback Volume", 0x0B, 0x3, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Mic-2 Playback Switch", 0x0B, 0x3, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Headphone Playback Volume", 0x0D, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("Headphone Playback Switch", 0x19, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Capture Volume", 0x07, 0x0, INPUT, 0x23, VOLUME),
//	AZX_CODEC_ENUM("Capture Source", 0x07, 0x0),
	AZX_CODEC_CUSTOM("Digital-Out", snd_azx_mux_digital_info, snd_azx_mux_digital_get, snd_azx_mux_digital_put, 0x0)
};

snd_kcontrol_new_t three_stack_rear_panel_digital_mixer[] = {
//	AZX_CODEC_VOLUME("control name here", nid, index, direction, max_val, type)
	AZX_CODEC_VOLUME("PCM Front Playback Volume", 0x0C, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("PCM Front Playback Switch", 0x14, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("PCM Rear Playback Volume", 0x0F, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("PCM Rear Playback Switch", 0x1A, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("PCM C/LFE Playback Volume", 0x0E, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("PCM C/LFE Playback Switch", 0x18, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("CD Playback Volume", 0x0B, 0x04, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("CD Playback Switch", 0x0B, 0x04, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Line Playback Volume", 0x0B, 0x02, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Line Playback Switch", 0x0B, 0x02, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Mic-1 Playback Volume", 0x0B, 0x0, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Mic-1 Playback Switch", 0x0B, 0x0, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Mic-2 Playback Volume", 0x0B, 0x3, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Mic-2 Playback Switch", 0x0B, 0x3, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Headphone Playback Volume", 0x0D, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("Headphone Playback Switch", 0x19, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Capture Volume", 0x07, 0x0, INPUT, 0x23, VOLUME),
//	AZX_CODEC_ENUM("Capture Source", 0x07, 0x0),
	AZX_CODEC_CUSTOM("Channel Source", snd_azx_mux_info, snd_azx_mux_get, snd_azx_mux_put, 0x0),
	AZX_CODEC_CUSTOM("Digital-Out", snd_azx_mux_digital_info, snd_azx_mux_digital_get, snd_azx_mux_digital_put, 0x0)
};

static verb_t alc880_three_stack_volume[] = {
// format = {nid, direct, command, parameter}
// Line In pin widget(nid=0x14) for input
	{0x1A, 0x0, AC_VERB_SET_PIN_WIDGET_CONTROL, 0x20},
// CD pin widget(nid=0x1C) for input
	{0x1C, 0x0, AC_VERB_SET_PIN_WIDGET_CONTROL, 0x20},
// Mic1 (rear panel) pin widget(nid=0x18) for input and vref at 80%
	{0x18, 0x0, AC_VERB_SET_PIN_WIDGET_CONTROL, 0x24},
// Mic2 (front panel) pin widget(nid=0x1B) for input and vref at 80%
	{0x1B, 0x0, AC_VERB_SET_PIN_WIDGET_CONTROL, 0x24},
// unmute amp left and right
	{0x07, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0x7000},
// set connection select to line in (default select for this ADC)
	{0x07, 0x0, AC_VERB_SET_CONNECT_SEL, 0x02},
// unmute front mixer amp left and right and set to max volume Line out
	{0x0C, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0xB040},
// unmute pin widget amp left and right (no gain on this amp)
	{0x14, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0x0B000},
// unmute rear mixer amp left and right and set to max volume rear
	{0x0F, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0xB040},
// unmute pin widget amp left and right (no gain on this amp)
	{0x1A, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0x0B000},
// unmute rear mixer amp left and right and set to max volume clfe
	{0x0E, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0xB040},
// unmute pin widget amp left and right (no gain on this amp)
	{0x18, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0x0B000},

// using rear surround as the path for headphone output
	// unmute rear surround mixer amp left and right and set to max volume
	{0x0D, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0xB040},
	// PASD 3 stack boards use the Mic 2 as the headphone output
	// need to program the selector associated with the Mic 2 pin widget to
	// surround path (index 0x01) for headphone output
	{0x11, 0x0, AC_VERB_SET_CONNECT_SEL, 0x01},
	// unmute pin widget amp left and right (no gain on this amp)
	{0x19, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0x0B000},
	// need to retask the Mic 2 pin widget to output
	{0x19, 0x0, AC_VERB_SET_PIN_WIDGET_CONTROL, 0x40},

// Unmute input amps (CD, Line In, Mic 1 & Mic 2) for mixer widget(nid=0x0B) to support
	// the input path of analog loopback
	// Note: PASD motherboards uses the Line In 2 as the input for front panel mic (mic 2)
	// Amp Indexes: CD = 0x04, Line In 1 = 0x02, Mic 1 = 0x00 & Line In 2 = 0x03
	// unmute CD
	{0x0B, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x04 << 8))},
	// unmute Line In
	{0x0B, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x02 << 8))},
	// unmute Mic 1
	{0x0B, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x00 << 8))},
	// unmute Line In 2 (for PASD boards Mic 2)
	{0x0B, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x03 << 8))},

	// Unmute input amps for the line out paths to support the output path of analog loopback
	// the mixers on the output path has 2 inputs, one from the DAC and one from the mixer
	// Amp Indexes: DAC = 0x01 & mixer = 0x00
	// Unmute Front out path
	{0x0C, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x00 << 8))},
	{0x0C, 0x0,AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x01 << 8))},
	// Unmute Surround (used as HP) out path
	{0x0D, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x00 << 8))},
	{0x0D, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x01 << 8))},
	// Unmute C/LFE out path
	{0x0E, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x00 << 8))},
	{0x0E, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x01 << 8))},
	// Unmute rear Surround out path
	{0x0F, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x00 << 8))},
	{0x0F, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x01 << 8))},

	{0x0, 0x0, 0x0, 0x0}
};

static verb_t alc880_five_stack_volume[] = {
// format = {nid, direct, command, parameter}
// Line In pin widget(nid=0x14) for input
	{0x1A, 0x0, AC_VERB_SET_PIN_WIDGET_CONTROL, 0x20},
// CD pin widget(nid=0x1C) for input
	{0x1C, 0x0, AC_VERB_SET_PIN_WIDGET_CONTROL, 0x20},
// Mic1 (rear panel) pin widget(nid=0x18) for input and vref at 80%
	{0x18, 0x0, AC_VERB_SET_PIN_WIDGET_CONTROL, 0x24},
// Mic2 (front panel) pin widget(nid=0x1B) for input and vref at 80%
	{0x1B, 0x0, AC_VERB_SET_PIN_WIDGET_CONTROL, 0x24},
// unmute amp left and right
	{0x07, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0x7000},
// set connection select to line in (default select for this ADC)
	{0x07, 0x0, AC_VERB_SET_CONNECT_SEL, 0x02},
// unmute front mixer amp left and right and set to max volume Line out
	{0x0C, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0xB040},
// unmute pin widget amp left and right (no gain on this amp)
	{0x14, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0x0B000},
// five rear and clfe
// unmute rear mixer amp left and right and set to max volume 
	{0x0F, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0xB040},
// unmute pin widget amp left and right (no gain on this amp)
	{0x17, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0x0B000},
// unmute rear mixer amp left and right and set to max volume clfe
	{0x0E, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0xB040},
// unmute pin widget amp left and right (no gain on this amp)
	{0x16, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0x0B000},

// using rear surround as the path for headphone output
	// unmute rear surround mixer amp left and right and set to max volume
	{0x0D, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0xB040},
	// PASD 3 stack boards use the Mic 2 as the headphone output
	// need to program the selector associated with the Mic 2 pin widget to
	// surround path (index 0x01) for headphone output
	{0x11, 0x0, AC_VERB_SET_CONNECT_SEL, 0x01},
	// unmute pin widget amp left and right (no gain on this amp)
	{0x19, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0x0B000},
	// need to retask the Mic 2 pin widget to output
	{0x19, 0x0, AC_VERB_SET_PIN_WIDGET_CONTROL, 0x40},

// Unmute input amps (CD, Line In, Mic 1 & Mic 2) for mixer widget(nid=0x0B) to support
	// the input path of analog loopback
	// Note: PASD motherboards uses the Line In 2 as the input for front panel mic (mic 2)
	// Amp Indexes: CD = 0x04, Line In 1 = 0x02, Mic 1 = 0x00 & Line In 2 = 0x03
	// unmute CD
	{0x0B, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x04 << 8))},
	// unmute Line In
	{0x0B, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x02 << 8))},
	// unmute Mic 1
	{0x0B, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x00 << 8))},
	// unmute Line In 2 (for PASD boards Mic 2)
	{0x0B, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x03 << 8))},

	// Unmute input amps for the line out paths to support the output path of analog loopback
	// the mixers on the output path has 2 inputs, one from the DAC and one from the mixer
	// Amp Indexes: DAC = 0x01 & mixer = 0x00
	// Unmute Front out path
	{0x0C, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x00 << 8))},
	{0x0C, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x01 << 8))},
	// Unmute Surround (used as HP) out path
	{0x0D, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x00 << 8))},
	{0x0D, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x01 << 8))},
	// Unmute C/LFE out path
	{0x0E, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x00 << 8))},
	{0x0E, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x01 << 8))},
	// Unmute rear Surround out path
	{0x0F, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x00 << 8))},
	{0x0F, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x01 << 8))},

	{0x0, 0x0, 0x0, 0x0}
};

static codec_mixer_t alc880_mixer[] = {
	{"*-*- ALC880 Three Stack Digital\n", 19, three_stack_rear_panel_digital_mixer, 28, alc880_three_stack_volume},
	{"*-*- ALC880 Three Stack Implementation Mixer\n", 18, three_stack_rear_panel_mixer, 28, alc880_three_stack_volume},
	{"*-*- ALC880 Five Stack Digital\n", 18, five_stack_rear_panel_digital_mixer, 28, alc880_five_stack_volume},
	{"*-*- ALC880 Five Stack Implementation Mixer\n", 17, five_stack_rear_panel_mixer, 28, alc880_five_stack_volume},
	{"",0, NULL}
};

int mixer_codec_setup_alc880(azx_codec_t* azx_codec, snd_card_t* card, u8 table_index)
{
	int err = 0;
	int temp;

	// set codec default volume and connect
	verb_t *def_ctrl = alc880_mixer[table_index].mixer_default_vol;
	for (temp = 0; temp < alc880_mixer[table_index].num_default; temp++) {
		snd_azx_codec_write(azx_codec, def_ctrl[temp].nid, def_ctrl[temp].direct, def_ctrl[temp].command, def_ctrl[temp].parameter);
	}

	// set mixer controller
	snd_kcontrol_new_t* mixer_controls = alc880_mixer[table_index].mixer_ctrls;
	for (temp = 0; temp < alc880_mixer[table_index].num_controls; temp++) {
		if ((err = snd_ctl_add(card, snd_ctl_new1(&(mixer_controls[temp]), azx_codec))) < 0) {
			printk("Error adding %s to mixer\n", three_stack_rear_panel_mixer[temp].name);
		}
	}
	return err;
}

int pcm_codec_setup_alc880(azx_t *chip, azx_dev_t *azx_dev, u32 num_channels, u32 board_config)
{
	u32 format = azx_dev->format_val;
	u32 stream_tag = azx_dev->stream_tag;
	u8 operation = chip->operation;		// 0 = capture, 1 = playback
	u8 nid = 0;
	u8 channel_id;
	u8 table_index = (board_config & 0xFF0) >> 4;
	u8 front_panel_support = (board_config & 0x2);

	if (operation) {
		// playback
		// stereo & headphone support (both uses the same DAC)
		nid = alc260_converter_nids[table_index].dac[FRONT];
		channel_id = 0x0;
		snd_azx_pcm_setup_codec(chip->azx_codec, nid, stream_tag, channel_id, format);

		// front panel output support
		if (front_panel_support) {
			// currently using REAR SURROUND output as the headphone output
			nid = alc880_converter_nids[table_index].dac[REAR_SURR];
			// headphone out will just decode front left/right (stereo)
			channel_id = 0x0;
			snd_azx_pcm_setup_codec(chip->azx_codec, nid, stream_tag, channel_id, format);
		}

		// multi-channel support with 2 channel samples
		if ((6 == mixer_values.channel_setting) & (2 == num_channels))  {
			// setup the rear output
			nid = alc880_converter_nids[table_index].dac[REAR];
			// mapping stereo to rears
			channel_id = 0x0;
			snd_azx_pcm_setup_codec(chip->azx_codec, nid, stream_tag, channel_id, format);

			// setup the C/LFE output
			nid = alc880_converter_nids[table_index].dac[CLFE];
			// mapping stereo to C/LFE
			channel_id = 0x0;
			snd_azx_pcm_setup_codec(chip->azx_codec, nid, stream_tag, channel_id, format);
		}

		// multi-channel support with 4 channel samples
		if ((6 == mixer_values.channel_setting) & (4 == num_channels))  {
			// setup the rear output
			nid = alc880_converter_nids[table_index].dac[REAR];
			// set DAC to decode rear
			channel_id = 0x2;
			snd_azx_pcm_setup_codec(chip->azx_codec, nid, stream_tag, channel_id, format);
			// nothing to do with c/lfe...
		}

		// multi-channel support with 6 channel samples
		if ((6 == mixer_values.channel_setting) & (6 == num_channels))  {
			// setup the rear output
			nid = alc880_converter_nids[table_index].dac[REAR];
			// set DAC to decode rear
			channel_id = 0x2;
			snd_azx_pcm_setup_codec(chip->azx_codec, nid, stream_tag, channel_id, format);
			// setup the C/LFE output
			nid = alc880_converter_nids[table_index].dac[CLFE];
			// set DAC to decode c/lfe
			channel_id = 0x4;
			snd_azx_pcm_setup_codec(chip->azx_codec, nid, stream_tag, channel_id, format);
		}

		// for digital output
		if (mixer_values.current_mux_digital_select_val) {
			channel_id = 0x0;
			nid = 0x06;
			snd_azx_pcm_setup_codec(chip->azx_codec, nid, stream_tag, channel_id, format);
		}

	} else {
		// capture
		nid = alc880_converter_nids[table_index].adc[CAP0];
		channel_id = 0x0;
		snd_azx_pcm_setup_codec(chip->azx_codec, nid, stream_tag, channel_id, format);
	}
	return 0;
}

int azx_alc880_codec_driver_create(u32 board_config)
{
	u8 config_val = (board_config & 0x01);

	if (1 == config_val) {
		// board has a five stack back panel
		// set the value of channel to 6
		mixer_values.channel_setting = 6;
	} else {
		// board only has a 3 stack back panel
		// set the value of channel to 2 as default
		mixer_values.channel_setting = 2;
	}

	return 0;
}

int azx_alc880_codec_driver_free(void)
{
	return 0;
}

void patch_alc880(azx_codec_t *azx_codec) 
{
	codec_callback_info.pcm_codec_setup = pcm_codec_setup_alc880;
	codec_callback_info.mixer_codec_setup = mixer_codec_setup_alc880;
	codec_callback_info.codec_driver_free = azx_alc880_codec_driver_free;
	codec_callback_info.codec_driver_create = azx_alc880_codec_driver_create;
	codec_callback_info.pcm_setup_info = NULL;
	codec_callback_info.model_num = 1;
}

// ************************************** MIXER/CONTROL ***************************
/****
 * snd_azx_mux_info - custom .info function for control that allows retasking
 * of the mic input and line input to outputs supporting 6channel output on
 * certain implementations.
 * @kcontrol: snd_kcontrol_t instance
 * @uinfo: snd_ctl_elem_info_t instance
 *
 * Returns error
****/
static int snd_azx_mux_info(snd_kcontrol_t* kcontrol, snd_ctl_elem_info_t* uinfo)
{
	static char *texts[2] = {
		"2ch", "6ch"
	};


	uinfo->type = SNDRV_CTL_ELEM_TYPE_ENUMERATED;
	uinfo->count = 1;
	uinfo->value.enumerated.items = 2;
	strcpy(uinfo->value.enumerated.name, texts[uinfo->value.enumerated.item]);
	return 0;

}

int snd_azx_codec_setup_multi_channel_selector(azx_codec_t* azx_codec, u8 rear_index, u8 clfe_index)
{
	u32 cad = 0x02;
	u32 nid;
	u32 direct = 0;
	u32 parameter;

	// this is to set the selector for retasking the rear panel jacks to support 6 channel
	// output
	// for rear channel output using Line In 1
	// set select widget connection (nid = 0x12) - to summer node for front NID = 0x0C...offset 0 in connection list
	nid = 0x12;
	parameter = rear_index;
	snd_azx_codec_write(azx_codec, nid, direct, AC_VERB_SET_CONNECT_SEL, parameter);

	// Program PW for Line In pin NID = 0x1A;
	nid = 0x1A;
	// set select pin widget connection - to selector node NID = 0x10...offset 0 in connection list
	parameter = 0x0;
	snd_azx_codec_write(azx_codec, nid, direct, AC_VERB_SET_CONNECT_SEL, parameter);

	// Rear Pin Widget AMP SETUP (LEFT)

	// **** set the summer gain/mute to unmute **************************
	parameter = 0xB080;
	snd_azx_codec_write(azx_codec, nid, direct, AC_VERB_SET_AMP_GAIN_MUTE, parameter);

	// program R_PW controls to output instead of default input
	parameter = 0x40;
	snd_azx_codec_write(azx_codec, nid, direct, AC_VERB_SET_PIN_WIDGET_CONTROL, parameter);

	// for Mic1 - retask for center/lfe
	// set select widget connection (nid = 0x10) - to summer node for front NID = 0x0C...offset 0 in connection list
	nid = 0x10;
	parameter = clfe_index;
	snd_azx_codec_write(azx_codec, nid, direct, AC_VERB_SET_CONNECT_SEL, parameter);

	// Program PW for MIC1 pin NID = 18;
	nid = 0x18;

	// set select pin widget connection - to selector node NID = 0x10...offset 0 in connection list
	parameter = 0x0;
	snd_azx_codec_write(azx_codec, nid, direct, AC_VERB_SET_CONNECT_SEL, parameter);

	// Rear Pin Widget AMP SETUP (LEFT)
	parameter = 0xB080;
	snd_azx_codec_write(azx_codec, nid, direct, AC_VERB_SET_AMP_GAIN_MUTE, parameter);

	// program R_PW controls to output instead of default input
	parameter = 0x40;
	snd_azx_codec_write(azx_codec, nid, direct, AC_VERB_SET_PIN_WIDGET_CONTROL, parameter);

	return 0;	
}

/****
 * snd_azx_mux_get - custom .get function for control that allows retasking
 * of the mic input and line input to outputs supporting 6channel output on
 * certain implementations.
 * @kcontrol: snd_kcontrol_t instance
 * @ucontrol: snd_ctl_elem_value_t instance
 *
 * Returns error
****/
static int snd_azx_mux_get(snd_kcontrol_t* kcontrol, snd_ctl_elem_value_t* ucontrol)
{


	ucontrol->value.enumerated.item[0] = mixer_values.current_mux_select_val;

	return 0;
}

static int snd_azx_mux_put(snd_kcontrol_t* kcontrol, snd_ctl_elem_value_t* ucontrol)
{
	azx_codec_t* azx_codec = snd_kcontrol_chip(kcontrol);
	u32 nid = 0x07;
	u32 cad = 0x02;
	u32 direct = 0x0;
	u32 parameter = 0;

	int changed;
	mixer_values.current_mux_select_val = ucontrol->value.enumerated.item[0];

	switch (ucontrol->value.enumerated.item[0]) {
		case 0 :
			// set the path ways for 2 channel output
			// need to set the codec line out and mic 1 pin widgets to inputs
			// set pin widget 1Ah (line in) for input
			parameter = 0x20;
			nid = 0x1A;
			snd_azx_codec_write(azx_codec, nid, direct, AC_VERB_SET_PIN_WIDGET_CONTROL, parameter);

			// set pin widget 18h (mic1) for input
			// for mic you need to also enable the vref
			nid = 0x18;
			parameter = 0x24;
			snd_azx_codec_write(azx_codec, nid, direct, AC_VERB_SET_PIN_WIDGET_CONTROL, parameter);

			// need to mute the output
			// for Line In PW
			snd_azx_codec_amp_put(azx_codec, 0x1A, 0x80, 0x80, OUTPUT, 0x00);

			// for Mic1 PW
			snd_azx_codec_amp_put(azx_codec, 0x18, 0x80, 0x80, OUTPUT, 0x00);

			// set variable to let pcm engine know that it need to setup for multichannel
			mixer_values.channel_setting = 2;

			parameter = mixer_values.current_mux_select_val;
			break;
		case 1 :
			// need to set the codec line out and mic 1 pin widgets to outputs
			// set pin widget 1Ah (line in) for output
			parameter = 0x40;
			nid = 0x1A;
			snd_azx_codec_write(azx_codec, nid, direct, AC_VERB_SET_PIN_WIDGET_CONTROL, parameter);

			// set pin widget 18h (mic1) for output
			nid = 0x18;
			snd_azx_codec_write(azx_codec, nid, direct, AC_VERB_SET_PIN_WIDGET_CONTROL, parameter);

			// need to unmute the output
			// for Line In PW
			snd_azx_codec_amp_put(azx_codec, 0x1A, 0x00, 0x00, OUTPUT, 0x00);
			
			// for Mic1 PW
			snd_azx_codec_amp_put(azx_codec, 0x18, 0x00, 0x00, OUTPUT, 0x00);
			
			// set variable to let pcm engine know that it need to setup for multichannel
			mixer_values.channel_setting = 6;

			// set the selector for retasking inputs to outputs
			snd_azx_codec_setup_multi_channel_selector(azx_codec, 0x03, 0x02);

			parameter = mixer_values.current_mux_select_val;
			break;
	}

	changed = 1;

	return changed;
}

/****
 * snd_azx_mux_digital_info - custom .info function for control that allows
 * retasking enabling of digital output (SPDIF) on certain implementations.
 * @kcontrol: snd_kcontrol_t instance
 * @uinfo: snd_ctl_elem_info_t instance
 *
 * Returns error
****/
static int snd_azx_mux_digital_info(snd_kcontrol_t* kcontrol, snd_ctl_elem_info_t* uinfo)
{
	static char *texts[2] = {
		"Off", "On"
	};

	uinfo->type = SNDRV_CTL_ELEM_TYPE_ENUMERATED;
	uinfo->count = 1;
	uinfo->value.enumerated.items = 2;
	strcpy(uinfo->value.enumerated.name, texts[uinfo->value.enumerated.item]);
	return 0;

}

/****
 * snd_azx_mux_digital_get - custom .get function for control that allows
 * retasking enabling of digital output (SPDIF) on certain implementations.
 * @kcontrol: snd_kcontrol_t instance
 * @ucontrol: snd_ctl_elem_value_t instance
 *
 * Returns error
****/
static int snd_azx_mux_digital_get(snd_kcontrol_t* kcontrol, snd_ctl_elem_value_t* ucontrol)
{
	ucontrol->value.enumerated.item[0] = mixer_values.current_mux_digital_select_val;

	return 0;
}

/****
 * snd_azx_mux_digital_put - custom .put function for control that allows
 * retasking enabling of digital output (SPDIF) on certain implementations.
 * @kcontrol: snd_kcontrol_t instance
 * @ucontrol: snd_ctl_elem_value_t instance
 *
 * Returns error
****/
static int snd_azx_mux_digital_put(snd_kcontrol_t* kcontrol, snd_ctl_elem_value_t* ucontrol)
{
	azx_codec_t* azx_codec = snd_kcontrol_chip(kcontrol);


	u32 nid = 0x06;
//	u32 cad = 0x02;
	u32 direct = 0x0;
	u32 parameter = 0;

	int changed;
	mixer_values.current_mux_digital_select_val = ucontrol->value.enumerated.item[0];

	switch (ucontrol->value.enumerated.item[0]) {
		case 0 :
			parameter = 0x0;
			snd_azx_codec_write(azx_codec, nid, direct, AC_VERB_SET_DIGI_CONVERT_1, parameter);
			break;
		case 1 :
			parameter = 0x01;
			snd_azx_codec_write(azx_codec, nid, direct, AC_VERB_SET_DIGI_CONVERT_1, parameter);
			break;
	}

	changed = 1;

	return changed;
}

#endif
