
#if 0
#include <sound/azalia_codec.h>	

// example of what nid_converter_t will contain
static nid_converter_t alc260_converter_nids[] = {
	// format = {number of ADC, number of DAC, list of ADC nids {adc0, adc1, adc2, etc}, list of DAC nids {front, rear, clfe, rear_surr, etc.}
	{2, 1, {0x4, 0x5}, {0x2}},	// Three Stack Implementation
};

snd_kcontrol_new_t three_stack_rear_panel_mixer[] = {
//	AZX_CODEC_VOLUME("control name here", nid, index, direction, max_val, type)
	AZX_CODEC_VOLUME("PCM Playback Volume", 0x08, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("PCM Playback Switch", 0x0F, 0x0, OUTPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("CD Playback Volume", 0x07, 0x04, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("CD Playback Switch", 0x07, 0x04, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Line Playback Volume", 0x07, 0x02, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Line Playback Switch", 0x07, 0x02, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Mic-1 Playback Volume", 0x07, 0x0, INPUT, 0x41, VOLUME),
	AZX_CODEC_MUTE("Mic-1 Playback Switch", 0x07, 0x0, INPUT, 0x01, MUTE),
	AZX_CODEC_VOLUME("Headphone Playback Volume", 0x09, 0x0, OUTPUT, 0x40, VOLUME),
	AZX_CODEC_MUTE("Headphone Playback Switch", 0x10, 0x0, OUTPUT, 0x01, MUTE),
	// 10th entry
	AZX_CODEC_VOLUME("Capture Volume", 0x04, 0x0, INPUT, 0x23, VOLUME),
//	AZX_CODEC_ENUM("Capture Source", 0x04, 0x0),
};

static verb_t alc260_default_volume[] = {
// format = {nid, direct, command, parameter}
// Line In pin widget(nid=0x14) for input
	{0x14, 0x0, AC_VERB_SET_PIN_WIDGET_CONTROL, 0x20},
// CD pin widget(nid=0x1C) for input
	{0x16, 0x0, AC_VERB_SET_PIN_WIDGET_CONTROL, 0x20},
// Mic1 (rear panel) pin widget(nid=0x18) for input and vref at 80%
	{0x12, 0x0, AC_VERB_SET_PIN_WIDGET_CONTROL, 0x24},
// Mic2 (front panel) pin widget(nid=0x1B) for input and vref at 80%
	{0x13, 0x0, AC_VERB_SET_PIN_WIDGET_CONTROL, 0x24},
// unmute amp left and right
	{0x04, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0x7000},
// set connection select to line in (default select for this ADC)
	{0x04, 0x0, AC_VERB_SET_CONNECT_SEL, 0x02},
// unmute front mixer amp left and right and set to max volume
	{0x08, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0xB040},
// unmute pin widget amp left and right (no gain on this amp)
	{0x0F, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0x0B000},
	{0x09, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0xB040},
// unmute pin widget amp left and right (no gain on this amp)
	{0x10, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, 0x0B000},
// Amp Indexes: CD = 0x04, Line In 1 = 0x02, Mic 1 = 0x00 & Line In 2 = 0x03
// unmute CD
	{0x07, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x04 << 8))},
// unmute Line In
	{0x07, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x02 << 8))},
// unmute Mic 1
	{0x07, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x00 << 8))},
// Amp Indexes: DAC = 0x01 & mixer = 0x00
// Unmute Front out path
	{0x08, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x00 << 8))},
	{0x08, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x01 << 8))},
// Unmute Headphone out path
	{0x09, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x00 << 8))},
	{0x09, 0x0, AC_VERB_SET_AMP_GAIN_MUTE, (0x7000 | (0x01 << 8))},
	{0x0, 0x0, 0x0, 0x0}
};

static codec_mixer_t alc260_mixer[] = {
	{"*-*- ALC260 Implementation Mixer\n", 11,  three_stack_rear_panel_mixer, 17, alc260_default_volume},
	{"",0, NULL, 0, NULL}
};


int pcm_codec_setup_alc260(azx_t *chip, azx_dev_t *azx_dev, u32 num_channels, u32 board_config)
{
	u32 format = azx_dev->format_val;
	u32 stream_tag = azx_dev->stream_tag;
	u8 operation = chip->operation;		// 0 = capture, 1 = playback
	u8 nid = 0;
	u8 channel_id;
	u8 table_index = (board_config & 0xFF0) >> 4;

	if (operation) {
		// playback
		// stereo & headphone support (both uses the same DAC)
		nid = alc260_converter_nids[table_index].dac[FRONT];
		channel_id = 0x0;
		snd_azx_pcm_setup_codec(chip->azx_codec, nid, stream_tag, channel_id, format);
	} else {
		// capture
		nid = alc260_converter_nids[table_index].adc[CAP0];
		channel_id = 0x0;
		snd_azx_pcm_setup_codec(chip->azx_codec, nid, stream_tag, channel_id, format);
	}
	return 0;
}

int mixer_codec_setup_alc260(azx_codec_t* azx_codec, snd_card_t* card, u8 table_index)
{
	int err = 0;
	int temp;

	// set codec default volume and connect
	verb_t *def_ctrl = alc260_mixer[table_index].mixer_default_vol;
	for (temp = 0; temp < alc260_mixer[table_index].num_default; temp++) {
		snd_azx_codec_write(azx_codec, def_ctrl[temp].nid, def_ctrl[temp].direct, def_ctrl[temp].command, def_ctrl[temp].parameter);
	}

	// set mixer controller
	snd_kcontrol_new_t* mixer_controls = alc260_mixer[table_index].mixer_ctrls;
	for (temp = 0; temp < alc260_mixer[table_index].num_controls; temp++) {
		if ((err = snd_ctl_add(card, snd_ctl_new1(&(mixer_controls[temp]), azx_codec))) < 0) {
			printk("Error adding %s to mixer\n", three_stack_rear_panel_mixer[temp].name);
		}
	}
	return err;
}

int azx_alc260_codec_driver_create(u32 board_config)
{
//	mixer_values.channel_setting = 2;
	return 0;
}

int azx_alc260_codec_driver_free(void)
{
	return 0;
}

void patch_alc260(azx_codec_t *azx_codec) 
{
//	codec_callback_info.pcm_codec_setup = pcm_codec_setup_alc260;
//	codec_callback_info.mixer_codec_setup = mixer_codec_setup_alc260;
//	codec_callback_info.codec_driver_free = azx_alc260_codec_driver_free;
//	codec_callback_info.codec_driver_create = azx_alc260_codec_driver_create;
	codec_callback_info.pcm_setup_info = NULL;
	codec_callback_info.model_num = 0;
}
#endif
