/*
 *  Copyright (c) by PeiSen Hou <pshou@realtek.com.tw>
 *  Universal routines for Azalia codec
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

#include <sound/driver.h>
#include <linux/delay.h>
#include <linux/init.h>
#include <linux/slab.h>
#include <sound/core.h>
#include <sound/pcm.h>
#include <sound/azalia_codec.h>
#include <sound/asoundef.h>
#include <sound/initval.h>
#include "azalia_local.h"
#include "azalia_id.h"


MODULE_AUTHOR("PeiSen Hou <pshou@realtek.com.tw>");
MODULE_DESCRIPTION("Universal interface for Azalia Codec ");
MODULE_LICENSE("GPL");

#define chip_t azalia_codec_t

typedef struct {
	unsigned int id;
	unsigned int mask;
	const char *name;
} azalia_codec_id_t;

static const azalia_codec_id_t snd_azalia_codec_id_vendors[] = {
{ 0x10ec0000, 0xffff0000, "Realtek"},
};

static const azalia_codec_id_t snd_azalia_codec_ids[] = {
{ 0x10ec0260, 0xffffffff, "ALC260"},
};

static int snd_azalia_codec_bus_free(azalia_codec_bus_t *bus)
{
	if (bus) {
		snd_azalia_codec_bus_proc_done(bus);
		if (bus->pcms)
			kfree(bus->pcms);
		if (bus->private_free)
			bus->private_free(bus);
		snd_magic_kfree(bus);
	}
	return 0;
}

static int snd_azalia_codec_bus_dev_free(snd_device_t *device)
{
	azalia_codec_bus_t *bus = snd_magic_cast(azalia_codec_bus_t, device->device_data, return -ENXIO);
	return snd_azalia_codec_bus_free(bus);
}

static int snd_azalia_codec_free(azalia_codec_t *azalia_codec)
{
	if (azalia_codec) {
		if (azalia_codec->private_free)
			azalia_codec->private_free(azalia_codec);
		snd_magic_kfree(azalia_codec);
	}
	return 0;
}

static int snd_azalia_codec_dev_free(snd_device_t *device)
{
	azalia_codec_t *azalia_codec = snd_magic_cast(azalia_codec_t, device->device_data, return -ENXIO);
	return snd_azalia_codec_free(azalia_codec);
}

int snd_azalia_codec_bus(snd_card_t * card, azalia_codec_bus_t * _bus, azalia_codec_bus_t ** rbus)
{
	int err;
	azalia_codec_bus_t *bus;
	static snd_device_ops_t ops = {
		.dev_free =	snd_azalia_codec_bus_dev_free,
	};

	snd_assert(card != NULL, return -EINVAL);
	snd_assert(_bus != NULL && rbus != NULL, return -EINVAL);
	bus = snd_magic_kmalloc(azalia_codec_bus_t, 0, GFP_KERNEL);
	if (bus == NULL)
		return -ENOMEM;
	*bus = *_bus;
	bus->card = card;
	if (bus->clock == 0)
		bus->clock = 48000;
	spin_lock_init(&bus->bus_lock);
	snd_azalia_codec_bus_proc_init(bus);
	if ((err = snd_device_new(card, SNDRV_DEV_LOWLEVEL, bus, &ops)) < 0) {
		snd_azalia_codec_bus_free(bus);
		return err;
	}
	*rbus = bus;
	return 0;
}

int snd_azalia_codec_mixer(azalia_codec_bus_t * bus, azalia_codec_t * _azalia_codec, azalia_codec_t ** razalia_codec)
{
//	int err;
	snd_card_t *card;
//	char name[64];
//	unsigned long end_time;
//	unsigned int reg;
	azalia_codec_t * azalia_codec;
//	static snd_device_ops_t ops = {
//		.dev_free =	snd_azalia_codec_dev_free,
//	};

	snd_assert(razalia_codec != NULL, return -EINVAL);
	*razalia_codec = NULL;
	snd_assert(bus != NULL && _azalia_codec != NULL, return -EINVAL);
	snd_assert(_azalia_codec->num < 4 && bus->codec[_azalia_codec->num] == NULL, return -EINVAL);
	card = bus->card;
	azalia_codec = snd_magic_kcalloc(azalia_codec_t, 0, GFP_KERNEL);
	if (azalia_codec == NULL)
		return -ENOMEM;
	*azalia_codec = *_azalia_codec;
	azalia_codec->bus = bus;
	bus->codec[azalia_codec->num] = azalia_codec;
	spin_lock_init(&azalia_codec->reg_lock);

	if (azalia_codec->pci) {
		pci_read_config_word(azalia_codec->pci, PCI_SUBSYSTEM_VENDOR_ID, &azalia_codec->subsystem_vendor);
		pci_read_config_word(azalia_codec->pci, PCI_SUBSYSTEM_ID, &azalia_codec->subsystem_device);
	}

//	printk("readb 0x%8x.\n", azalia_codec->bus->readb);
//azalia_codec->bus->readb(azalia_codec, AC_NODE_ROOT, AC_VERB_PARAMETERS, AC_PRAR_VENDOR_ID);
//	azalia_codec->id = azalia_codec->bus->readb(azalia_codec, AC_NODE_ROOT, AC_VERB_PARAMETERS, AC_PRAR_VENDOR_ID);

	printk("codec id 0x%08x.\n", azalia_codec->id);
	return -ENOMEM;
}
	
/*
 *  INIT part
 */

static int __init alsa_azalia_init(void)
{
	return 0;
}

static void __exit alsa_azalia_exit(void)
{
}

module_init(alsa_azalia_init)
module_exit(alsa_azalia_exit)
