#ifndef __SOUND_AZALIA_CODEC_H
#define __SOUND_AZALIA_CODEC_H

/*
 *  Copyright (c) by Peisen Hou <pshou@realtek.com.tw>
 *  Universal interface for Audio Codec '97
 *
 *  For more details look to Azalia codec component specification 
 *  by Intel Corporation (http://developer.intel.com).
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */

#include <linux/bitops.h>
#include "control.h"
#include "info.h"
#include "adriver.h"

/*
 *  Azalia codec registers
 */
#define	AC_NODE_ROOT		0x00
#define	AC_NODE_AUDIO_FUNCTION	0x01
#define	AC_NODE_MODEM_FUNCTION	0x02
#define	AC_NODE_HDMI_FUNCTION	0x03
#define	AC_NODE_VENDOR_DEF	0x04
#define	AC_NODE_AUDIO_OUT	0x05
#define	AC_NODE_AUDIO_IN	0x06
#define	AC_NODE_PIN_WIDGET	0x07
#define	AC_NODE_MIXER		0x08
#define	AC_NODE_SELECTOR	0x09


// get command
#define AC_VERB_PARAMETERS			0x0f00
#define AC_PRAR_VENDOR_ID		0x00
#define AC_PRAR_SUBSYSTEM_ID		0x01
#define AC_PRAR_REV_ID			0x02
#define AC_PRAR_NODE_COUNT		0x04
#define AC_PRAR_FUNCTION_TYPE		0x05
#define AC_PRAR_AUDIO_FG_CAP		0x08
#define AC_PRAR_AUDIO_WIDGET_CAP	0x09
#define AC_PRAR_PCM			0x0a
#define AC_PRAR_STREAM			0x0b
#define AC_PRAR_PIN_CAP			0x0c
#define AC_PRAR_AMP_CAP			0x0d
#define AC_PRAR_CONLIST_LEN		0x0e
#define AC_PRAR_POWER_STATE		0x0f
#define AC_PRAR_PROC_CAP		0x10
#define AC_PRAR_GPIO_CAP		0x11

#define AC_VERB_GET_CONNECT_SEL			0x0f01
#define AC_VERB_GET_CONNECT_LIST		0x0f02
#define AC_VERB_GET_PROC_STATE			0x0f03

#define AC_VERB_GET_COEF_INDEX			0x0d00
#define AC_VERB_GET_PROC_COEF			0x0c00
#define AC_VERB_GET_AMP_GAIN_MUTE		0x0b00
#define AC_VERB_GET_STREAM_FORMAT		0x0a00

#define AC_VERB_GET_SDI_SELECT			0x0f04
#define AC_VERB_GET_POWER_STATE			0x0f05
#define AC_VERB_GET_CHANNEL_STREAMID		0x0f06
#define AC_VERB_GET_PIN_WIDGET_CONTROL		0x0f07
#define AC_VERB_GET_UNSOLICITED_RESPONSE	0x0f08
#define AC_VERB_GET_PIN_SENSE			0x0f09
#define AC_VERB_GET_BEEP_CONTROL		0x0f0a
#define AC_VERB_GET_PIN_JACK_LOCATION		0x0f0b
#define AC_VERB_GET_PIN_JACK_LABEL		0x0f0c
#define AC_VERB_GET_DIGI_CONVERT		0x0f0d
#define AC_VERB_GET_GPIO_CONTROL		0x0f0f
#define AC_VERB_GET_GPIO_DATA			0x0f15
#define AC_VERB_GET_GPIO_MASK			0x0f16
#define AC_VERB_GET_GPIO_DIRECTION		0x0f17

// SET commands

//	SYMBOL					VALUE
#define AC_VERB_SET_CONNECT_SEL			0x701
#define AC_VERB_SET_PROC_STATE			0x703
#define AC_VERB_SET_COEF_INDEX			0x500
#define AC_VERB_SET_PROC_COEF			0x400
#define AC_VERB_SET_AMP_GAIN_MUTE		0x300
#define AC_VERB_SET_STREAM_FORMAT		0x200
#define AC_VERB_SET_DIGI_CONVERT_1		0x70D
#define AC_VERB_SET_DIGI_CONVERT_2		0x70E
#define AC_VERB_SET_POWER_STATE			0x705
#define AC_VERB_SET_CHANNEL_STREAMID		0x706
#define AC_VERB_SET_SDI_SELECT			0x704
#define AC_VERB_SET_PIN_WIDGET_CONTROL		0x707
#define AC_VERB_SET_UNSOLICITED_ENABLE		0x708
#define AC_VERB_SET_PIN_SENSE			0x709
#define AC_VERB_SET_EAPD_BTLENALBE		0x70C
#define AC_VERB_SET_BEEP_CONTROL		0x70A
#define AC_VERB_SET_VOLUME_KNOB_CONTROL		0x70F
#define AC_VERB_SET_GPIO_DATA			0x715
#define AC_VERB_SET_GPIO_MASK			0x716
#define AC_VERB_SET_GPIO_DIRECTION		0x717
#define AC_VERB_SET_CONFIG_DEFAULT_BYTES_0		0x71C
#define AC_VERB_SET_CONFIG_DEFAULT_BYTES_1		0x71D
#define AC_VERB_SET_CONFIG_DEFAULT_BYTES_2		0x71E
#define AC_VERB_SET_CONFIG_DEFAULT_BYTES_3		0x71F
#define AC_VERB_SET_CODEC_RESET			0x7FF
#define AC_VERB_RESET				0x07ff


/* rates indexes */
#define AZX_RATES_FRONT_DAC	0
#define AZX_RATES_SURR_DAC	1
#define AZX_RATES_LFE_DAC	2
#define AZX_RATES_ADC		3
#define AZX_RATES_MIC_ADC	4
#define AZX_RATES_SPDIF		5

#define ICH6_MAX_CAPTURE_DEV	4
#define ICH6_MAX_PLAYBACK_DEV	4
#define ICH6_MAX_DEV 		8
#define ICH6_MAX_FRAG 256	// can be any number no restriction...it is a matter of memory usage
#define ICH6_CORB_SIZE 1024
#define ICH6_RIRB_SIZE 2048
#define BUFFSIZE 1024*32
#define POS_BUFF_SIZE 8*8
#define AZX_MAX_FRAG		(PAGE_SIZE / (ICH6_MAX_DEV * 16))
/* max buffer size - no h/w limit, you can increase as you like */
#define AZX_MAX_BUF_SIZE	(1024*1024*1024)

#define AZX_STREAM_OFFSET	0x80

/* CORB/RIRB control, read/write pointer */
#define ICH6_RBCTL_DMA_EN	0x02	/* enable DMA */
#define ICH6_RBRWP_CLR		0x8000	/* read/write pointer clear */
/* below are so far hardcoded - should read registers in future */
#define ICH6_MAX_CORB_ENTRIES	256
#define ICH6_MAX_RIRB_ENTRIES	256

/* RIRB int mask: overrun[2], response[0] */
#define RIRB_INT_MASK		0x5
#define STATESTS_INT_MASK	0x07
/* SD_CTL bits */
#define SD_CTL_STREAM_RESET	0x01	/* stream reset bit */
#define SD_CTL_DMA_START	0x02	/* stream DMA start bit */
#define SD_CTL_STREAM_TAG_MASK	(0xf << 20)
#define SD_CTL_STREAM_TAG_SHIFT	20

/* SD_CTL and SD_STS */
#define SD_INT_DESC_ERR		0x10	/* descriptor error interrupt */
#define SD_INT_FIFO_ERR		0x08	/* FIFO error interrupt */
#define SD_INT_COMPLETE		0x04	/* completion interrupt */
#define SD_INT_MASK		(SD_INT_DESC_ERR|SD_INT_FIFO_ERR|SD_INT_COMPLETE)

/* INTCTL and INTSTS */
#define ICH6_INT_ALL_STREAM	0xff		/* all stream interrupts */
#define ICH6_INT_CTRL_EN	0x40000000	/* controller interrupt enable bit */
#define ICH6_INT_GLOBAL_EN	0x80000000	/* global interrupt enable bit */

#define INPUT 0
#define OUTPUT 1
/*
 *
 */
// enum for indexing codec ADC
enum {CAP0, CAP1, CAP2, CAP3};

// enum for indexing codec DAC
enum {FRONT, REAR, CLFE, REAR_SURR};

typedef struct _snd_azx_codec_bus azx_codec_bus_t;
typedef struct _snd_azx_codec azx_codec_t;

typedef struct snd_azx azx_t;
#define chip_t azx_t

/*
 * AZALIA chip
 */
typedef struct _azx_rb azx_rb_t;
typedef struct _azx_dev azx_dev_t;
typedef struct {
	int cap_select_nid[10];
} nid_list_t;

struct _azx_dev {

	u32 *bdl;			/* virtual address of the BDL */
	dma_addr_t bdl_addr;		/* physical address of the BDL */
	volatile u32 *posbuf;			/* position buffer pointer */

	unsigned int bufsize;		/* size of the play buffer in bytes */
	unsigned int fragsize;		/* size of each period in bytes */
	unsigned int frags;		/* number for period in the play buffer */
	unsigned int fifo_size;		/* FIFO size */

	void __iomem *sd_addr;		/* stream descriptor pointer */

	u32 sd_int_sta_mask;		/* stream int status mask */

	/* pcm support */
	snd_pcm_substream_t *substream;	/* assigned substream, set in PCM open */
	unsigned int format_val;	/* format value to be set in the controller and the codec */
//	unsigned char stream_tag;	/* assigned stream */
	unsigned int stream_tag;
	unsigned char index;		/* stream index */

	unsigned int opened: 1;
	unsigned int running: 1;

	u8 device;
};

struct _azx_rb {
	u32 *buf;
	dma_addr_t addr;
};

/*
 * info for buffer allocation
 */
struct snd_azx {
	snd_card_t *card;
	struct pci_dev *pci;

//	struct resource *res;		/* memory i/o */
	unsigned long addr;
	void __iomem *remap_addr;
	int irq;
	
	azx_codec_bus_t *azx_codec_bus;
	azx_codec_t *azx_codec;		

	spinlock_t reg_lock;
	spinlock_t azx_codec_lock;
	struct semaphore open_mutex;

	azx_rb_t	corb;
	azx_rb_t	rirb;

	struct snd_dma_buffer bdl;
	struct snd_dma_buffer rb;
	struct snd_dma_buffer posbuf;

	azx_dev_t azx_dev[ICH6_MAX_DEV];

	u32 int_sta_mask;	// interrupt status mask for int status register - offset 0x24h

	u16 codec_mask;
	u8 num_codecs;

	// for using ac97 code
	unsigned short num;

	// jack retasking support
	u8 current_channel_setting;	

	int max_channels;		/* max. channels for PCM out */

	u16	output_streams;
	u16	input_streams;
	u16	biput_streams;
	u32	playback_offset;
	
	unsigned char	caindex;	/* azalia codec address */

	u8	operation;
	u32 board_config;

	unsigned short subsystem_vendor;
	unsigned short subsystem_device;
};


typedef struct {
	u32 nid;
	u32 direct;
	u32 command;
	u32 parameter;
} verb_t;

/* PCM allocation */
struct azx_codec_pcm {
	azx_codec_bus_t *bus;
	unsigned int stream: 1,	   	   /* stream type: 1 = capture */
		     exclusive: 1,	   /* exclusive mode, don't override with other pcms */
		     copy_flag: 1,	   /* lowlevel driver must fill all entries */
		     spdif: 1;		   /* spdif pcm */
	unsigned short aslots;		   /* active slots */
	unsigned int rates;		   /* available rates */
	struct {
		unsigned short slots;	   /* driver input: requested AC97 slot numbers */
		unsigned short rslots[4];  /* allocated slots per codecs */
		unsigned char rate_table[4];
		azx_codec_t *codec[4];	   /* allocated codecs */
	} r[2];				   /* 0 = standard rates, 1 = double rates */
	unsigned long private_value;	   /* used by the hardware driver */
};

struct snd_azx_codec_build_ops {
	int (*build_3d) (azx_codec_t *azx_codec);
	int (*build_specific) (azx_codec_t *azx_codec);
	int (*build_spdif) (azx_codec_t *azx_codec);
	int (*build_post_spdif) (azx_codec_t *azx_codec);
};

struct _snd_azx_codec_bus {
	/* -- lowlevel (hardware) driver specific -- */
	void (*reset) (azx_codec_t *azx_codec);
	int (*write) (azx_codec_t *azx_codec, u16 nid, u16 direct, u16 verb, u16 para);
	int (*read) (azx_codec_t *azx_codec, u16 nodeid, u16 direct, u16 verb, u16 para);
	void (*wait) (azx_codec_t *azx_codec);
	void (*init) (azx_codec_t *azx_codec);
	void *private_data;
	void (*private_free) (azx_codec_bus_t *bus);
	/* --- */
	snd_card_t *card;
	unsigned short num;	/* bus number */
	unsigned short vra: 1,	/* bridge supports VRA */
		       isdin: 1;/* independent SDIN */
	unsigned int clock;	/* AC'97 base clock (usually 48000Hz) */
	spinlock_t bus_lock;	/* used mainly for slot allocation */
	unsigned short used_slots[2][4]; /* actually used PCM slots */
	unsigned short pcms_count; /* count of PCMs */
	struct azx_codec_pcm *pcms;
	azx_codec_t *codec[4];
	snd_info_entry_t *proc;
};

struct _snd_azx_codec {
	/* -- lowlevel (hardware) driver specific -- */
	struct snd_azx_codec_build_ops * build_ops;
	void *private_data;
	void (*private_free) (azx_codec_t *azx_codec);
	/* --- */
	snd_card_t *card;
	azx_codec_bus_t *bus;
	struct pci_dev *pci;	/* assigned PCI device - used for quirks */
	snd_info_entry_t *proc;
	snd_info_entry_t *proc_regs;
	unsigned short subsystem_vendor;
	unsigned short subsystem_device;
	spinlock_t reg_lock;

	unsigned int clock;	/* AC'97 base clock (usually 48000Hz) */
	unsigned short num;	/* number of codec: 0 = primary, 1 = secondary */
	unsigned short addr;	/* physical address of codec [0-3] */

	unsigned char caindex;	/* codec address */
	unsigned int id;	/* identification of codec */
	unsigned int revision; 
	unsigned char node_start;
	unsigned char node_total;
	unsigned int functiontype;

	u8 current_mux_select_val;
	u32 board_config;

	nid_list_t* cap_select_table;

//	unsigned short ext_mid;	/* extended modem ID (register 3C) */
//	unsigned int scaps;	/* driver capabilities */
//	unsigned int flags;	/* specific code */
	unsigned int rates[6];	/* see AC97_RATES_* defines */
//	unsigned int spdif_status;
//	unsigned short regs[0x80]; /* register cache */
//	unsigned int limited_regs; /* allow limited registers only */
//	DECLARE_BITMAP(reg_accessed, 0x80); /* bit flags */
//	union {			/* vendor specific code */
//		struct {
//			unsigned short unchained[3];	// 0 = C34, 1 = C79, 2 = C69
//			unsigned short chained[3];	// 0 = C34, 1 = C79, 2 = C69
//			unsigned short id[3];		// codec IDs (lower 16-bit word)
//			unsigned short pcmreg[3];	// PCM registers
//			unsigned short codec_cfg[3];	// CODEC_CFG bits
//			struct semaphore mutex;
//		} ad18xx;
//		unsigned int dev_flags;		/* device specific */
//	} spec;
};

typedef struct {
	int num_adc;
	int num_dac;
	int adc[10];
	int dac[10];
} nid_converter_t;

// define a structure to hold pcm setup information
typedef struct {
	azx_t* chip;
	u8 table_index;		// index to ADC/DAC config table
	u32 format;		// format of the pcm stream
	u32 stream_tag;		// stream tag associated with stream
	u16 converter_index;	// index to NID of ADC/DAC
	u8 operation;		// playback or capture to determine ADC or DAC table lookup
	u8 front_panel_support;	// 1 = front panel support, 0 = no front panel support
	u8 stream_channels;	// number of channels per sample in the stream
	u8 cad;			// codec address
} pcm_setup_info_t;

// define a structure to hold callback functions
struct codec_driver {
	int (*pcm_codec_setup)(azx_t *chip, azx_dev_t *azx_dev, u32 num_channels, u32 board_config);
	int (*mixer_codec_setup)(azx_codec_t* azx_codec, snd_card_t* card, u8 table_index);
	int (*codec_driver_free)(void);
	int (*codec_driver_create)(u32 board_config);
	pcm_setup_info_t* pcm_setup_info;
	u8 model_num;
};

// for mixer support
typedef struct {
	char* mixer_setup_string;
	u32 num_controls;
	snd_kcontrol_new_t* mixer_ctrls;
	u32 num_default;
	verb_t* mixer_default_vol;
} codec_mixer_t;

struct azx_codec_quirk {
	unsigned short vendor;	/* PCI vendor id */
	unsigned short device;	/* PCI device id */
	unsigned short mask;	/* device id bit mask, 0 = accept all */
	const char *name;	/* name shown as info */
	int type;		/* quirk type above */
};

// to hold codec specific mixer info
typedef struct _mixer {
	u8 current_mux_select_val;
	u8 current_mux_digital_select_val;
	u8 channel_setting;
} mixer_t;

typedef struct {
	u8 num_items;
	char* labels[4];
} enum_list_t;

typedef struct {
	char* list_string;
	enum_list_t* enum_list;
} enum_table_t;

#define VOLUME 1
#define MUTE 0

#define AZX_CODEC_VOLUME(xname, nid, index, direction, max_val, type) \
{ .iface = SNDRV_CTL_ELEM_IFACE_MIXER, .name = xname, \
  .info = snd_azx_codec_info_volume, \
  .get = snd_azx_codec_get_volume, .put = snd_azx_codec_put_volume, \
  .private_value = (nid) | ((index) << 8) | ((direction) << 12) | ((max_val) << 13) | ((type) << 21) }

#define AZX_CODEC_MUTE(xname, nid, index, direction, max_val, type) \
{ .iface = SNDRV_CTL_ELEM_IFACE_MIXER, .name = xname, .info = snd_azx_codec_info_mute, \
  .get = snd_azx_codec_mute_get, .put = snd_azx_codec_mute_put, \
  .private_value = (nid) | ((index) << 8) | ((direction) << 12) | ((max_val) << 13) | ((type) << 21) }

#define AZX_CODEC_CUSTOM(xname, info_func, get_func, put_func, private_val) \
{ .iface = SNDRV_CTL_ELEM_IFACE_MIXER, .name = xname, .info = info_func, \
  .get = get_func, .put = put_func, \
  .private_value = private_val }

#define AZX_CODEC_ENUM(xname, nid, table_index) \
{ .iface = SNDRV_CTL_ELEM_IFACE_MIXER, .name = xname, .info = snd_azx_info_enum, \
  .get = snd_azx_enum_get, .put = snd_azx_enum_put, \
  .private_value = (nid) | ((table_index) << 8)}

/* functions */
//int snd_azx_codec_bus(snd_card_t * card, azx_codec_bus_t * _bus, azx_codec_bus_t ** rbus); /* create new AZALIA CODEC bus */
int snd_azx_codec_mixer(azx_codec_t * _azx_codec, azx_codec_t ** razx_codec, int board_config);	/* create mixer controls */

int snd_azx_codec_amp_put(azx_codec_t* azx_codec, u8 nid, u8 left_val, u8 right_val, u8 direction, u32 index);

int snd_azx_info_enum(snd_kcontrol_t* kcontrol, snd_ctl_elem_info_t* uinfo);
int snd_azx_enum_get(snd_kcontrol_t* kcontrol, snd_ctl_elem_value_t* ucontrol);
int snd_azx_enum_put(snd_kcontrol_t* kcontrol, snd_ctl_elem_value_t* ucontrol);


#endif /* __SOUND_AZALIA_CODEC_H */
