% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.filename-functions.R
\name{rk.eval.as.preview}
\alias{rk.eval.as.preview}
\title{Evaluate the given input file, recording a transcript to an HTML output file (including on-screen plots)}
\usage{
rk.eval.as.preview(
  infile,
  outfile,
  echo = TRUE,
  env = new.env(parent = globalenv()),
  stop.on.error = FALSE
)
}
\arguments{
\item{infile}{The input R file, specified as a character string, or a connection (passed to \link{parse}).}

\item{outfile}{The output HTML file, specified as a character string. If this file exists, it will be overwritting, without further notice!}

\item{echo}{Include the source expressions in the output? (boolean)}

\item{env}{Environment of the evaluation. See details, below.}

\item{stop.on.error}{Whether to stop (TRUE) or continue (FALSE) on errors}
}
\description{
Evaluate the given input file, recording a transcript to an HTML output file (including on-screen plots)
}
\details{
Contrary to \link{source}, some effort is made to avoid lasting side-effects to the workspace, however these cannot be ruled out,
         in all cases. Among other things, the following may lead to lasting effects:

         \itemize{
             \item{Installing / updating / removing / loading packages}
             \item{Writing to the filesystem in any form}
             \item{Targetting pre-existing graphics devices with \code{dev.set()}, \code{dev.off()}, etc.}
             \item{Opening / closing windows in the RKWard workplace}
             \item{Exclusively assuming the R engine (e.g. shiny apps)}
             \item{Assignments outside the current scope (see also below)}
         }

         The default argument value for \code{env} allows the evaluated script to access objects inside the \code{globalenv()}, but
         limits regular assignments (i.e. using \code{<-} rather than \code{<<-} or \code{assign()}) to a temporary local scope. Depending on the
         desired semantics, \code{new.env()} or \code{globalenv()} may be useful alternatives.

         The idea of \code{rk.eval.as.preview} is to visualize what would happen when running the given code in the R console,
         interactively. Importantly, however, due to the evaluation inside a function, any error messages and backtraces will differ,
         and taskCallbacks will not run.
}
