/*
 * Copyright 1999-2008  University of Chicago
 * Copyright 2008-2010  Members of the EGEE Collaboration
 * Copyright 2008-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef XACML_SERVER_H
#define XACML_SERVER_H

#include "xacml_datatypes.h"
#include "xacml.h"

#ifndef DONT_DOCUMENT_INTERNAL
EXTERN_C_BEGIN
#endif

/* Server Authz Processing */

typedef struct xacml_server_s * xacml_server_t;

xacml_result_t
xacml_server_init(
    xacml_server_t *                    server,
    xacml_authorization_handler_t       handler,
    void *                              arg);

xacml_result_t
xacml_server_set_port(
    xacml_server_t                      server,
    unsigned short                      port);

xacml_result_t
xacml_server_get_port(
    const xacml_server_t                server,
    unsigned short *                    port);

xacml_result_t
xacml_server_start(
    xacml_server_t                      server);

void
xacml_server_destroy(
    xacml_server_t                      server);

xacml_result_t
xacml_server_set_io_module(
    xacml_server_t                      server,
    const char *                        module);

xacml_result_t
xacml_server_set_fd(
    xacml_server_t                      server,
    int                                 fd);

xacml_result_t
xacml_server_set_io_descriptor(
    xacml_server_t                      server,
    const xacml_io_descriptor_t        *descriptor);

void
xacml_server_set_timeouts(
    int send_timeout,
    int recv_timeout,
    int accept_timeout);

void
xacml_server_get_timeouts(
    int *send_timeout,
    int *recv_timeout,
    int *accept_timeout);

#ifndef DONT_DOCUMENT_INTERNAL
EXTERN_C_END
#endif

#endif /* XACML_SERVER_H */
