dnl
dnl Copyright 1999-2008  University of Chicago
dnl Copyright 2008-2010  Members of the EGEE Collaboration
dnl Copyright 2008-  Stichting Fundamenteel Onderzoek der Materie (FOM-Nikhef)
dnl
dnl Licensed under the Apache License, Version 2.0 (the "License");
dnl you may not use this file except in compliance with the License.
dnl You may obtain a copy of the License at
dnl 
dnl     http://www.apache.org/licenses/LICENSE-2.0
dnl 
dnl Unless required by applicable law or agreed to in writing, software
dnl distributed under the License is distributed on an "AS IS" BASIS,
dnl WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
dnl See the License for the specific language governing permissions and
dnl limitations under the License.

dnl This module tests the presence of the gSOAP library and tools, see
dnl http://www.cs.fsu.edu/~engelen/soapmain.html

dnl AC_GSOAP([MINIMUM-VERSION])
dnl This macro test for gSOAP, and defines the following output variables:
dnl GSOAP_DIR - the base directory of the gSOAP installation
dnl GSOAP_CFLAGS - additional flags for compilation against gSOAP
dnl GSOAP_LIBS - additional flags for linking against gSOAP
dnl gsoap_version - the version of gSOAP
dnl have_gsoap - yes/no
AC_DEFUN_ONCE([AC_GSOAP],
[
    dnl Make sure autoconf (bootstrap) fails when macro is undefined
    ifdef([PKG_CHECK_MODULES],
          [],
          [m4_fatal([macro PKG_CHECK_MODULES is not defined])])

    dnl Set an alternative directory to search for the gSOAP installation
    AC_ARG_WITH(gsoap,
	    [AC_HELP_STRING([--with-gsoap=DIR],
		[Search for gsoap in DIR])],
	    [GSOAP_DIR=$withval])

    dnl Check whether a location is specified
    if test "x$with_gsoap" != "x" ; then
	_AC_GSOAP_DIRECT([$GSOAP_DIR], have_gsoap=yes, have_gsoap=no)
    else
	have_gsoap=no
    fi

    dnl If we don't have it yet, try from pkg-config
    if test "$have_gsoap" = "no" ; then
	_AC_GSOAP_PKGCONFIG($1, have_gsoap=yes, have_gsoap=no)
    fi

    dnl If we don't have it yet, try at system default
    if test "$have_gsoap" = "no" ; then
	GSOAP_DIR=/usr
	_AC_GSOAP_DIRECT([$GSOAP_DIR], have_gsoap=yes, have_gsoap=no)
    fi

    dnl Test binaries
    if test "$have_gsoap" = "yes" ; then
	_AC_GSOAP_BINTOOLS([$GSOAP_DIR/bin:$PATH], [$1], have_gsoap=yes, have_gsoap=no)
    fi

    dnl Test import dir: sets GSOAP_IMPORTDIR
    if test "$have_gsoap" = "yes" ; then
	_AC_GSOAP_IMPORT([$GSOAP_DIR], have_gsoap=yes, have_gsoap=no)
    fi

    dnl If failed: unset variables
    if test "$have_gsoap" = "no" ; then
	GSOAP_DIR=""
	GSOAP_IMPORTDIR=""
	GSOAP_CFLAGS=""
	GSOAP_LIBS=""
	gsoap_version=""
    fi
])dnl AC_GSOAP


dnl Internal macro, doing a check at directory PATH
dnl _AC_GSOAP_DIRECT([path],[action if found],[action if not found])
dnl When found, sets
dnl	GSOAP_CFLAGS
dnl	GSOAP_LIBS
AC_DEFUN([_AC_GSOAP_DIRECT],
[
    AC_MSG_CHECKING([for gSOAP at $1])
    dnl Default is no
    ac_gsoap_direct="no"
	
    dnl First check existence for header file
    if test -f "$1/include/stdsoap2.h" ; then
	GSOAP_CFLAGS="-I$1/include"
	dnl check libdir lib64
	if ls $1/lib64/libgsoap++.* > /dev/null 2> /dev/null ; then
	    ac_gsoap_direct="yes"
	    GSOAP_LIBS="-L$1/lib64 -lgsoap++"
	dnl check libdir lib
	elif ls $1/lib/libgsoap++.* > /dev/null 2> /dev/null ; then
	    ac_gsoap_direct="yes"
	    GSOAP_LIBS="-L$1/lib -lgsoap++"
	fi
    fi

    dnl Check the outcome
    if test "$ac_gsoap_direct" = "yes" ; then
	AC_MSG_RESULT([yes])
	[$2]
    else
	AC_MSG_RESULT([no])
	[$3]
    fi
])


dnl Internal macro, doing a check using pkg-config for optionally given version
dnl _AC_GSOAP_PKGCONFIG([minimum-version],[action if found],[action if not found])
dnl When found, sets
dnl	GSOAP_CFLAGS
dnl	GSOAP_LIBS
dnl	GSOAP_DIR to exec_prefix
AC_DEFUN([_AC_GSOAP_PKGCONFIG],
[
    ac_gsoap_pkgconfig=no
    dnl Not yet found: use pkg-config, $1 is optional version
    m4_if([$1],[],
    [PKG_CHECK_MODULES([GSOAP],[gsoap++],
	ac_gsoap_pkgconfig="yes", ac_gsoap_pkgconfig="no")],
    [PKG_CHECK_MODULES([GSOAP],[gsoap++ >= $1],
	ac_gsoap_pkgconfig="yes", ac_gsoap_pkgconfig="no")])

    if test "$ac_gsoap_pkgconfig" = "yes" ; then
	GSOAP_DIR=`$PKG_CONFIG --variable=exec_prefix gsoap++`
	[$2]
    else
	[$3]
    fi
])

dnl Internal macro, doing check for binary tools in given PATH and optionally
dnl given version
dnl _AC_GSOAP_BINTOOLS([path],[minimum-version],[action if found],[action if not found])
dnl When found, sets
dnl	gsoap_version	to version of gSOAP
dnl	WSDL2H
dnl	SOAPCPP2
AC_DEFUN([_AC_GSOAP_BINTOOLS],
[
    ac_gsoap_progs="yes"
    dnl wsl2h
    AC_PATH_PROG([WSDL2H], [wsdl2h], no, [$1/bin])
    if test "x$WSDL2H" = "xno"; then
	ac_gsoap_progs="no"
	AC_MSG_ERROR([Unable to locate wsdl2h at $1/bin])
    fi
    dnl soapcpp2
    AC_PATH_PROG([SOAPCPP2], [soapcpp2], no, [$1/bin])
    if test "x$SOAPCPP2" = "xno"; then
	ac_gsoap_progs="no"
	AC_MSG_ERROR([Unable to locate soapcpp2 at $1/bin])
    fi
    dnl check if a minimum version is requested
    gsoap_version=[`$SOAPCPP2 -v 2>&1 | sed -n 's/.*\([0-9][0-9]*\.[0-9][0-9]*\.[0-9][0-9]*\).*/\1/p'`]
    m4_if([$2],[],,
    [AS_VERSION_COMPARE([$gsoap_version],[$2],
	[ac_gsoap_progs="no"
	 AC_MSG_ERROR([Version $2 of gSOAP is required, but $gsoap_version was found.])],
	[], [])])

    if test "$ac_gsoap_progs" = "yes" ; then
	[$3]
    else
	WSDL2H=""
	SOAPCPP2=""
	[$4]
    fi
])

dnl Internal macro, checks location of import files such as stlvector.h
dnl Sets GSOAP_IMPORTDIR
dnl _AC_GSOAP_IMPORT([path], [action if found],[action if not found])
dnl When found, sets
dnl	GSOAP_IMPORTDIR
AC_DEFUN([_AC_GSOAP_IMPORT],
[
    GSOAP_IMPORTDIR=""
    AC_MSG_CHECKING([for gSOAP import dir])
    AS_IF([test -f "$GSOAP_DIR/share/gsoap/import/stlvector.h"],
	  [GSOAP_IMPORTDIR=$GSOAP_DIR/share/gsoap/import
	   AC_MSG_RESULT([$GSOAP_IMPORTDIR])
	   [$2]],
	  [test -f "$GSOAP_DIR/include/gsoap/stlvector.h"],
	  [GSOAP_IMPORTDIR=$GSOAP_DIR/include/gsoap
	   AC_MSG_RESULT([$GSOAP_IMPORTDIR])
	   [$2]],
	  [AC_MSG_RESULT([no])
	   AC_MSG_ERROR([Unable to find location for import dir])
	   [$3]])
])
