#------------------------------------------------------------------------------
# Copyright 2008-2012 Istituto Nazionale di Fisica Nucleare (INFN)
# 
# Licensed under the EUPL, Version 1.1 only (the "License").
# You may not use this work except in compliance with the License. 
# You may obtain a copy of the License at:
# 
# http://joinup.ec.europa.eu/system/files/EN/EUPL%20v.1.1%20-%20Licence.pdf
# 
# Unless required by applicable law or agreed to in 
# writing, software distributed under the License is 
# distributed on an "AS IS" basis, 
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. 
# See the License for the specific language governing 
# permissions and limitations under the License.
#------------------------------------------------------------------------------
'''
Created on Feb 24, 2011

@author: aleita
'''
#import commands
from wnodes.utils import utils as utils

def mount(SSH_KEY_FILE, VM_CLIENT, SRC, LOCAL_MOUNT):
    
    CMD_MOUNT_LVM = ('ssh -i %s -o ' % SSH_KEY_FILE +
                     'UserKnownHostsFile=/dev/null ' +
                     '-o StrictHostKeyChecking=no -q %s ' % VM_CLIENT +
                     '"mount %s %s; chmod ugo+w %s"' %
                     (SRC, LOCAL_MOUNT, LOCAL_MOUNT))
                    
    CMD_MOUNT_LVM_OUTPUT = utils.runCommand(CMD_MOUNT_LVM, 12)
    return CMD_MOUNT_LVM_OUTPUT

def link(SSH_KEY_FILE, VM_CLIENT, TARGET, LINK_NAME):
    
    CMD_LINK_TO_LVM = ('ssh -i %s -o ' % SSH_KEY_FILE +
                       'UserKnownHostsFile=/dev/null '
                       '-o StrictHostKeyChecking=no -q %s ' % VM_CLIENT +
                       '"rm -rf %s; ln -s %s %s; cp /etc/skel/.b* '
                       % (LINK_NAME, TARGET, LINK_NAME) +
                       '/etc/skel/.emacs /etc/skel/.zshrc  %s"' % LINK_NAME)

    CMD_LINK_TO_LVM_OUTPUT = utils.runCommand(CMD_LINK_TO_LVM, 12)
    return CMD_LINK_TO_LVM_OUTPUT

def handlePlugin(SSH_KEY_FILE, VM_CLIENT, CONFIG):

    SRC, LOCAL_MOUNT = CONFIG['MOUNT'].split()
    output = mount(SSH_KEY_FILE, VM_CLIENT, SRC, LOCAL_MOUNT)
        
    TARGET, LINK_NAME = CONFIG['LINK'].split()
    output = link(SSH_KEY_FILE, VM_CLIENT, TARGET, LINK_NAME)
        
    return output
