#------------------------------------------------------------------------------
# Copyright 2008-2012 Istituto Nazionale di Fisica Nucleare (INFN)
#
# Licensed under the EUPL, Version 1.1 only (the "Licence").
# You may not use this work except in compliance with the Licence.
# You may obtain a copy of the Licence at:
#
# http://joinup.ec.europa.eu/system/files/EN/EUPL%20v.1.1%20-%20Licence.pdf
#
# Unless required by applicable law or agreed to in
# writing, software distributed under the Licence is
# distributed on an "AS IS" basis,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied.
# See the Licence for the specific language governing
# permissions and limitations under the Licence.
#------------------------------------------------------------------------------
'''
Created on Feb 24, 2011

@author: aleita
'''
from wnodes.utils import utils


def copy_pubkey(SSH_KEY_FILE, LSF_CLIENT, PUBKEY):

    CMD_COPY_USER_PUBKEY = ('ssh -i %s -o ' % SSH_KEY_FILE +
                            'UserKnownHostsFile=/dev/null -o ' +
                            'StrictHostKeyChecking=no -q %s ' % LSF_CLIENT +
                            '"echo %s >> /root/.ssh/authorized_keys"' % PUBKEY)
    CMD_COPY_USER_PUBKEY_OUTPUT = utils.runCommand(CMD_COPY_USER_PUBKEY, 1200)
    return CMD_COPY_USER_PUBKEY_OUTPUT


def handlePlugin(SSH_KEY_FILE, LSF_CLIENT, CONFIG):

    for CONFIG_TASK in CONFIG.keys():

        if CONFIG_TASK.upper() == 'PUBKEY':
            output = copy_pubkey(SSH_KEY_FILE, LSF_CLIENT,
                                 CONFIG['PUBKEY'])

    return output
