#-------------------------------------------------------------------------------
# Copyright 2008-2012 Istituto Nazionale di Fisica Nucleare (INFN)
# 
# Licensed under the EUPL, Version 1.1 only (the "Licence").
# You may not use this work except in compliance with the Licence. 
# You may obtain a copy of the Licence at:
# 
# http://joinup.ec.europa.eu/system/files/EN/EUPL%20v.1.1%20-%20Licence.pdf
# 
# Unless required by applicable law or agreed to in 
# writing, software distributed under the Licence is 
# distributed on an "AS IS" basis, 
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. 
# See the Licence for the specific language governing 
# permissions and limitations under the Licence.
#-------------------------------------------------------------------------------
'''
Created on Feb 24, 2011

@author: aleita
'''
import commands
import os
from wnodes.utils import utils as utils

def mount(SSH_KEY_FILE, LSF_CLIENT, SRC, LOCAL_MOUNT):
    
        
    CMD_MOUNT = 'ssh -i %s -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no -q %s "mkdir -p %s; mount %s %s"' % (SSH_KEY_FILE, LSF_CLIENT, LOCAL_MOUNT, SRC, LOCAL_MOUNT)
    CMD_MOUNT_OUTPUT = utils.runCommand(CMD_MOUNT, 12)
    return CMD_MOUNT_OUTPUT

def unmount(SSH_KEY_FILE, LSF_CLIENT, LOCAL_MOUNT):
    
    CMD_UNMOUNT = 'ssh -i %s -o UserKnownHostsFile=/dev/null -o StrictHostKeyChecking=no -q %s "umount %s"' % (SSH_KEY_FILE, LSF_CLIENT, LOCAL_MOUNT)
    CMD_UNMOUNT_OUTPUT = utils.runCommand(CMD_UNMOUNT, 12)
    return CMD_UNMOUNT_OUTPUT

def handlePlugin(SSH_KEY_FILE, LSF_CLIENT, CONFIG):
    
    for MOUNT_POINT in CONFIG.keys():
        
        MOUNT_POINT_ID, MOUNT_POINT_OP = MOUNT_POINT.split('-')
        
        if MOUNT_POINT_OP.upper() == 'MOUNT':
            SRC, LOCAL_MOUNT = CONFIG[MOUNT_POINT].split()
            output = mount(SSH_KEY_FILE, LSF_CLIENT, SRC, LOCAL_MOUNT)
        
        if MOUNT_POINT_OP.upper() == 'UNMOUNT':
            output = unmount(SSH_KEY_FILE, LSF_CLIENT, CONFIG[MOUNT_POINT])
        
    return output
