#------------------------------------------------------------------------------
# Copyright 2008-2012 Istituto Nazionale di Fisica Nucleare (INFN)
# 
# Licensed under the EUPL, Version 1.1 only (the "Licence").
# You may not use this work except in compliance with the Licence. 
# You may obtain a copy of the Licence at:
# 
# http://joinup.ec.europa.eu/system/files/EN/EUPL%20v.1.1%20-%20Licence.pdf
# 
# Unless required by applicable law or agreed to in 
# writing, software distributed under the Licence is 
# distributed on an "AS IS" basis, 
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. 
# See the Licence for the specific language governing 
# permissions and limitations under the Licence.
#------------------------------------------------------------------------------
'''
Created on Feb 21, 2011

@author: aleita
'''

#import commands
from wnodes.utils import utils as utils

def start(SSH_KEY_FILE, LSF_CLIENT):
    
    CMD_START = ('ssh -i %s -o UserKnownHostsFile=/dev/null -o '
                 % SSH_KEY_FILE +
                 'StrictHostKeyChecking=no -q %s "service lsf start"'
                 % LSF_CLIENT)
    CMD_START_OUTPUT = utils.runCommand(CMD_START, 12)
    return CMD_START_OUTPUT

def stop(SSH_KEY_FILE, LSF_CLIENT):
    
    CMD_STOP = ('ssh -i %s -o UserKnownHostsFile=/dev/null -o '
                % SSH_KEY_FILE +
                'StrictHostKeyChecking=no -q %s "service lsf stop"'
                % LSF_CLIENT)
    CMD_STOP_OUTPUT = utils.runCommand(CMD_STOP, 12)
    return CMD_STOP_OUTPUT

def handlePlugin(SSH_KEY_FILE, LSF_CLIENT, CONFIG):
    
    if 'STATUS' in CONFIG:
        if CONFIG['STATUS'] == 'ON':
            output = start(SSH_KEY_FILE, LSF_CLIENT)
        if CONFIG['STATUS'] == 'OFF':
            output = stop(SSH_KEY_FILE, LSF_CLIENT)
        
    return output
