#------------------------------------------------------------------------------
# Copyright 2008-2012 Istituto Nazionale di Fisica Nucleare (INFN)
#
# Licensed under the EUPL, Version 1.1 only (the "Licence").
# You may not use this work except in compliance with the Licence.
# You may obtain a copy of the Licence at:
#
# http://joinup.ec.europa.eu/system/files/EN/EUPL%20v.1.1%20-%20Licence.pdf
#
# Unless required by applicable law or agreed to in
# writing, software distributed under the Licence is
# distributed on an "AS IS" basis,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied.
# See the Licence for the specific language governing
# permissions and limitations under the Licence.
#------------------------------------------------------------------------------
"""
Part of WNoDeS framework.
Interface of the batch systems commands.
"""

__author__ = 'Elisabetta Ronchieri'

import commands


class Command:
    """
    Define a class to create abstract methods for the classes of the batch
    system commands
    """

    def _get_command(self):
        pass

    def _run_command(self):
        a = commands.getstatusoutput(self._get_command())
        return a

    def get_output(self):
        a = self._run_command()
        return a

    def get_command(self):
        a = self._get_command()
        return a
