#------------------------------------------------------------------------------
# Copyright 2008-2012 Istituto Nazionale di Fisica Nucleare (INFN)
#
# Licensed under the EUPL, Version 1.1 only (the "Licence").
# You may not use this work except in compliance with the Licence.
# You may obtain a copy of the Licence at:
#
# http://joinup.ec.europa.eu/system/files/EN/EUPL%20v.1.1%20-%20Licence.pdf
#
# Unless required by applicable law or agreed to in
# writing, software distributed under the Licence is
# distributed on an "AS IS" basis,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied.
# See the Licence for the specific language governing
# permissions and limitations under the Licence.
#------------------------------------------------------------------------------
"""
Part of WNoDeS framework.
Interface between WNoDeS processes an the batch systems
such as LSF and PBS
"""

__author__ = 'Elisabetta Ronchieri'


class BatchSystem:
    """
    Define a class to create abstract methods for the classes of the batch
    system
    """

    """
    Define bjobs
    """
    def bjobs(self, jobid, user):
        pass

    """
    Define breserve
    """
    def breserve(self, action, ID):
        pass

    """
    Define bmod
    """
    def bmod(self, option, jobid):
        pass

    """
    Define badmin
    """
    def badmin(self, option, hostname):
        pass

    """
    Define brun
    """
    def brun(self, hostname, jobid):
        pass

    """
    Define bhost
    """
    def bhost(self, hostname):
        pass

    """
    Define bsub
    """
    def bsub(self, option, user):
        pass

    """
    Define bkill
    """
    def bkill(self, jobid):
        pass

