#------------------------------------------------------------------------------
# Copyright 2008-2012 Istituto Nazionale di Fisica Nucleare (INFN)
# 
# Licensed under the EUPL, Version 1.1 only (the "Licence").
# You may not use this work except in compliance with the Licence. 
# You may obtain a copy of the Licence at:
# 
# http://joinup.ec.europa.eu/system/files/EN/EUPL%20v.1.1%20-%20Licence.pdf
# 
# Unless required by applicable law or agreed to in 
# writing, software distributed under the Licence is 
# distributed on an "AS IS" basis, 
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. 
# See the Licence for the specific language governing 
# permissions and limitations under the Licence.
#------------------------------------------------------------------------------

import sys
import exceptions

class LocationFormatError(exceptions.Exception):
    pass

class LocationFormat:

    def __init__(self, user_data, location):
        url = ('https://' + 
           user_data['server']['endpoint'] + ':' +
           user_data['server']['port'] + '/' +
           'compute/')

        if url in location:
            a = len(location) - len(url)
            if a != 36:
                msg = 'uid bad format. A good one is shown below:\n'
                msg += 'f36d6438-d960-40eb-bcb0-853dac3e878a'
                raise LocationFormatError(msg)
        else:
            msg = 'location bad format. It must be composed of:\n'
            msg += url
            msg += '<uid>'
            raise LocationFormatError(msg)
