#------------------------------------------------------------------------------
# Copyright 2008-2012 Istituto Nazionale di Fisica Nucleare (INFN)
# 
# Licensed under the EUPL, Version 1.1 only (the "Licence").
# You may not use this work except in compliance with the Licence. 
# You may obtain a copy of the Licence at:
# 
# http://joinup.ec.europa.eu/system/files/EN/EUPL%20v.1.1%20-%20Licence.pdf
# 
# Unless required by applicable law or agreed to in 
# writing, software distributed under the Licence is 
# distributed on an "AS IS" basis, 
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. 
# See the Licence for the specific language governing 
# permissions and limitations under the Licence.
#------------------------------------------------------------------------------

import sys
import os
from os import path
import exceptions

class NoPathFound(exceptions.Exception):
    pass

class NoFileFound(exceptions.Exception):
    pass

class ConfigurationFileLocation:
    def __init__(self, file_name=''):

        self.file_name = file_name
        self.default_path = 'etc/wnodes/cli/'

        dir_name = os.path.dirname(sys.argv[0])

        self.paths = [os.path.join(dir_name, "../", self.default_path),
            os.path.join(dir_name, "../", "../", self.default_path),
            os.path.join(dir_name, "../../", "../", self.default_path),
            os.path.join(dir_name, "../../../", "../", self.default_path)]

    def __is_path_valid(self):
        '''Checks the existence of a given configuration path'''

        result = False
        #print self.paths
        for x in self.paths:
            if os.path.isdir(x):
                #print 'path %s exist ' % x
                result = True
                break

        return result

    def get_configuration_path(self):
        '''Returns the configuration path'''

        for x in self.paths:
            if os.path.isdir(x):
                path = x
                break

        return path

    def __is_file_valid(self):
        '''Checks the existence of a given configuration file'''

        if not self.__is_path_valid():
            raise NoPathFound("Not set the configuration path")

        result = False

        for x in self.paths:
            if os.path.isfile(os.path.join(x, self.file_name)):
                #print 'file %s exist ' % (x + self.file_name)
                result = True
                break

        return result

    def get_configuration_file(self):
        '''Returns the configuration file'''

        if not self.__is_file_valid():
            raise NoFileFound("Not set the correct configuration file")

        file_name = ''

        for x in self.paths:
            if os.path.isfile(os.path.join(x, self.file_name)):
                file_name = (x + self.file_name)
                #print 'file %s ' % configuration_file
                break

        return file_name

    def get_custom_configuration_file(self):
        '''Returns the configuration file'''

        if '/' not in self.file_name:
            full_file_name = os.getcwd()+'/'+self.file_name
        else:
            full_file_name = self.file_name

        if os.path.isfile(full_file_name):
            return full_file_name
        else:
            raise NoFileFound("File does not exist")
