#!/usr/bin/env python
#------------------------------------------------------------------------------
# Copyright 2008-2012 Istituto Nazionale di Fisica Nucleare (INFN)
#
# Licensed under the EUPL, Version 1.1 only (the "Licence").
# You may not use this work except in compliance with the Licence.
# You may obtain a copy of the Licence at:
#
# http://joinup.ec.europa.eu/system/files/EN/EUPL%20v.1.1%20-%20Licence.pdf
#
# Unless required by applicable law or agreed to in
# writing, software distributed under the Licence is
# distributed on an "AS IS" basis,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied.
# See the Licence for the specific language governing
# permissions and limitations under the Licence.
#------------------------------------------------------------------------------
"""
WNoDeS CacheManager database Interface
"""
import sys
sys.path.append('/usr/lib64/python2.6/site-packages/SQLAlchemy-0.7.3-py2.6-linux-x86_64.egg')
from sqlalchemy.ext.declarative import declarative_base  # @UnresolvedImport
from sqlalchemy import create_engine, Column, String, Text  # @UnresolvedImport

from sqlalchemy import Boolean # @UnresolvedImport

import BigInteger # @UnresolvedImport
#from sqlalchemy.databases.mysql  import MSBigInteger  # @UnresolvedImport
#from sqlalchemy import ForeignKey, Integer
from sqlalchemy.orm import sessionmaker  # relationship #@UnresolvedImport

database = sys.modules['__main__'].database

#engine=create_engine('sqlite:///mysqlitedb.db', echo=True)
#engine = create_engine("mysql://root:trullallero@localhost/myclouddb",
#                       echo=True)
engine = create_engine(database, echo=False)
Base = declarative_base(engine)


def get_next_id(table):
    nextid = 0
    try:
        nextid = int(sess.query(table).all()[-1].ID) + 1
    except IndexError:
        nextid = 1
    return nextid


class Category(Base):
    __tablename__ = 'CATEGORY'
    ID = Column(BigInteger, primary_key=True, nullable=False)
    LABEL = Column(String(150))
    SCHEME = Column(String(250))
    TERM = Column(String(100), nullable=False)


class Compute(Base):
    __tablename__ = 'COMPUTE'
    ID = Column(BigInteger, primary_key=True, nullable=False)
    ARCH = Column(String(6), nullable=False)
    THROUGHPUT = Column(String(10), nullable=False)
    IMG_TAG = Column(String(50), nullable=False)
    #BASENAME = Column(String(15), nullable=False)  # added
    CORES = Column(String(3), nullable=False)
    DATE = Column(String(25), nullable=False)  # added
    HOSTNAME = Column(String(50))
    IS_TOKEN_VERIFIED = Column(Boolean)
    JOBID = Column(String(300))
    MEMORY = Column(String(4), nullable=False)
    NAME = Column(String(15), nullable=False)
    OS = Column(String(50), nullable=False)  # added
    OWNER = Column(String(255))
    PUBLICKEY = Column(Text(), nullable=False)  # added
    PUID = Column(String(255))  # added
    QUANT = Column(BigInteger)  # added
    SSH = Column(String(10), nullable=False)  # added
    STATUS = Column(String(8), nullable=False)  # mod (only 8 char)
    STORAGE = Column(String(10), nullable=False)  # added
    TIMESTAMP = Column(String(20), nullable=False)  # added
    TOKEN = Column(String(100))
    UUID = Column(String(50), nullable=False)

    #The following columns can be useful
    #TYPE = Column(String(50), nullable = False)
    #SESSION_START_TIME = Column(String(100), nullable = False)
    #SESSION_END_TIME = Column(String(100))


class Network(Base):
    __tablename__ = 'NETWORK'
    ID = Column(BigInteger, primary_key=True, nullable=False)
    ADDRESS = Column(String(30), nullable=False)
    ALLOCATION = Column(String(10), nullable=False)
    GATEWAY = Column(String(30), nullable=False)
    LABEL = Column(String(150), nullable=False)
    UUID = Column(String(50), nullable=False)
    VLAN = Column(String(10), nullable=False)
    compute_ID = Column(BigInteger)


class Storage(Base):
    __tablename__ = 'STORAGE'
    ID = Column(BigInteger, primary_key=True, nullable=False)
    NAME = Column(String(150), nullable=False)
    RELIABILITY = Column(String(15), nullable=False)
    SIZE = Column(String(30), nullable=False)
    UUID = Column(String(50), nullable=False)
    compute_ID = Column(BigInteger)


class User(Base):
    __tablename__ = 'USER'
    ID = Column(BigInteger, primary_key=True, nullable=False)
    DN = Column(Text(), nullable=False)
    PUID = Column(String(50))
    VO = Column(String(50))
    EMAIL = Column(String(50))
    NAME = Column(String(100))
    SSHPUBLIC = Column(Text())


class Virtuals(Base):
    __tablename__ = 'VIRTUALS'
    ID = Column(BigInteger, primary_key=True, nullable=False)
    BAITNAME = Column(String(50), nullable=False)
    CORES = Column(String(50), nullable=False)
    CPU = Column(String(120), nullable=False)
    CPUTEST = Column(String(50), nullable=False)  # TINYBLOB????
    MEMLOAD = Column(String(120), nullable=False)
    MEMORY = Column(String(50), nullable=False)
    OWNER = Column(String(50), nullable=False)
    STATE = Column(String(50), nullable=False)
    UPTIME = Column(String(50), nullable=False)
    VMNAME = Column(String(50), nullable=False)
    VO = Column(String(50), nullable=False)

Base.metadata.create_all()

sess = sessionmaker()()
