'''
Created on 28/feb/2012

@author: giannidallatorre
'''
import ConfigParser


class WNoDeSParserOption(object):
    '''
    merged option
    '''

    def __init__(self, rule):
        '''
        Constructor
        '''
        for section in rule:
            for option in rule[section]:
                # create an attribute which name is defined as:
                # _'section name'__'option name'
                attrib_name = ('_' + section + '__' + option).lower()
                setattr(self, attrib_name, rule[section][option])

    def use_config_file(self, config_file):
        # override previous option values
        # which ones defined in the rule dictionary
        config = ConfigParser.SafeConfigParser()
        config.read(config_file)

        for section in config.sections():
            for option in config.options(section):
                val = config.get(section, option)
                if val:
                    attrib_name = ('_' + section + '__' + option).lower()
                    setattr(self, attrib_name, val)
