#------------------------------------------------------------------------------
# Copyright 2008-2012 Istituto Nazionale di Fisica Nucleare (INFN)
#
# Licensed under the EUPL, Version 1.1 only (the "Licence").
# You may not use this work except in compliance with the Licence.
# You may obtain a copy of the Licence at:
#
# http://joinup.ec.europa.eu/system/files/EN/EUPL%20v.1.1%20-%20Licence.pdf
#
# Unless required by applicable law or agreed to in
# writing, software distributed under the Licence is
# distributed on an "AS IS" basis,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied.
# See the Licence for the specific language governing
# permissions and limitations under the Licence.
#------------------------------------------------------------------------------

import unittest
import inspect
from wnodes.accounting import requests

class RequestsTestCase(unittest.TestCase):

    vm1 = ('vm1', 'Pending','cloud','cloud',0,0)
    vm2 = ('vm2', 'Pending','cloud','cloud',0,0)
    vm3 = ('', 'Pending','cloud','cloud',0,0)

    def test_add_request(self):
       stack_value = inspect.stack()[0]
       path = stack_value[1]
       method = stack_value[3]

       try:
           build_requests = requests.Requests()
           build_requests.add_request(RequestsTestCase.vm1)
           print build_requests.get_images()
       except AssertionError, err:
            print err

    def test_add_requests(self):
       stack_value = inspect.stack()[0]
       path = stack_value[1]
       method = stack_value[3]

       try:
           build_requests = requests.Requests()
           build_requests.add_request(RequestsTestCase.vm1)
           build_requests.add_request(RequestsTestCase.vm2)
           print build_requests.get_images()
       except AssertionError, err:
            print err

    def test_add_request_with_empy_machine_name(self):
       stack_value = inspect.stack()[0]
       path = stack_value[1]
       method = stack_value[3]

       try:
           build_requests = requests.Requests()
           build_requests.add_request(RequestsTestCase.vm3)
           print build_requests.get_images()
       except AssertionError, err:
           print err
       except requests.RequestsError, err:
           print err

def main():
    suite = unittest.TestLoader().loadTestsFromTestCase(RequestsTestCase)
    unittest.TextTestRunner(verbosity=2).run(suite)

if __name__ == '__main__':
    main()
