#------------------------------------------------------------------------------
# Copyright 2008-2012 Istituto Nazionale di Fisica Nucleare (INFN)
#
# Licensed under the EUPL, Version 1.1 only (the "Licence").
# You may not use this work except in compliance with the Licence.
# You may obtain a copy of the Licence at:
#
# http://joinup.ec.europa.eu/system/files/EN/EUPL%20v.1.1%20-%20Licence.pdf
#
# Unless required by applicable law or agreed to in
# writing, software distributed under the Licence is
# distributed on an "AS IS" basis,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied.
# See the Licence for the specific language governing
# permissions and limitations under the Licence.
#------------------------------------------------------------------------------

import unittest
import inspect
from wnodes.accounting import requests
from wnodes.accounting import message_format
from wnodes.accounting import record_format

class MessageTestCase(unittest.TestCase):

    parameters={'SiteName':'INFN CNAF',
        'ZoneName':'EU',
        'TimeZone':'UTC',
        'output_location':'.'}
    vm1 = ('vm1', 'Pending','cloud','cloud',0,0)
    vm2 = ('vm2', 'Active','cloud','cloud',0,0)

    def test_store_a_request_in_file(self):
       stack_value = inspect.stack()[0]
       path = stack_value[1]
       method = stack_value[3]

       try:
           build_requests = requests.Requests()
           build_requests.add_request(request=MessageTestCase.vm1)

           images = build_requests.get_images()

           records = []

           for image in images:
               record = record_format.RecordFormat(SiteName=MessageTestCase.parameters['SiteName'],
                   ZoneName=MessageTestCase.parameters['ZoneName'],
                   TimeZone=MessageTestCase.parameters['TimeZone'],
                   MachineName=image['MachineName'],
                   Status=image['Status'],
                   LocalUserId=image['LocalGroupId'],
                   LocalGroupId=image['LocalGroupId'],
                   StartTime=image['StartTime'],
                   EndTime=image['EndTime'])
               records.append(record.get_information())

           build_message = message_format.MessageFormat(records_list=records)
           build_message.store_in_file(MessageTestCase.parameters['output_location'])
       except AssertionError, err:
            print err

    def test_store_two_requests_in_file(self):
       stack_value = inspect.stack()[0]
       path = stack_value[1]
       method = stack_value[3]

       try:
           build_requests = requests.Requests()
           build_requests.add_request(request=MessageTestCase.vm1)
           build_requests.add_request(request=MessageTestCase.vm2)

           images = build_requests.get_images()

           records = []
           for image in images:
               record = record_format.RecordFormat(SiteName=MessageTestCase.parameters['SiteName'],
                   ZoneName=MessageTestCase.parameters['ZoneName'],
                   TimeZone=MessageTestCase.parameters['TimeZone'],
                   MachineName=image['MachineName'],
                   Status=image['Status'],
                   LocalUserId=image['LocalGroupId'],
                   LocalGroupId=image['LocalGroupId'],
                   StartTime=image['StartTime'],
                   EndTime=image['EndTime'])
               records.append(record.get_information())

           build_message = message_format.MessageFormat(records_list=records)
           build_message.store_in_file(MessageTestCase.parameters['output_location'])
       except AssertionError, err:
            print err

def main():
    suite = unittest.TestLoader().loadTestsFromTestCase(MessageTestCase)
    unittest.TextTestRunner(verbosity=2).run(suite)

if __name__ == '__main__':
    main()
