import exceptions

class RequestsError(exceptions.Exception):
    pass

class ImageKeys(object):

    mandatory = 'MachineName'
    parameters = {'MachineName':'',
       'Status':'',
       'LocalUserId':'',
       'LocalGroupId':'',
       'StartTime':0,
       'EndTime':0}
    parkeys = parameters.keys()

class Requests(object):

    def __init__(self):
        self.images = []
        self.requests = []

    def add_request(self, request=()):
        if request:
            self.requests.append(request)

    def __set_images__(self):
        for request in self.requests:
            image = dict(zip(ImageKeys.parkeys,request[:5]))

            if image[ImageKeys.mandatory] == '':
                msg = '%s cannot be empty' % ImageKeys.mandatory
                raise RequestsError(msg)

            self.images.append(image)

    def get_images(self):
        """Gets record images"""
        self.__set_images__()
        return self.images
