import exceptions
from datetime import *
from dateutil.tz import *

class RecordFormatError(exceptions.Exception):
    pass

class RecordKeys(object):
    raws = {'RecordId':str(),
        'SiteName':str(),
        'ZoneName':str(),
        'MachineName':str(),
        'LocalUserId':str(),
        'LocalGroupId':str(),
        'GlobalUserName':'NULL',
        'FQAN':'NULL',
        'Status':str(),
        'StartTime':int(),
        'EndTime':int(),
        'SuspendTime':'NULL',
        'TimeZone':str(),
        'WallDuration':'NULL',
        'CpuDuration':'NULL',
        'CpuCount':'NULL',
        'NetworkType':'NULL',
        'NetworkInbound':'NULL',
        'NetworkOutbound':'NULL',
        'Memory':1024,
        'Disk':'NULL',
        'StorageRecordId':'NULL',
        'ImageId':str(),
        'CloudType':'WNoDeS'}

class RecordFormat(object):

    def __init__(self, **keywords):
        self.record = {}

        for key, value in RecordKeys.raws.iteritems():
            if key == 'RecordId':
                self.record['RecordId'] = ('%s %s %s'
                    % (datetime.now(tzoffset(None,3600)).__str__(),
                    keywords['SiteName'], keywords['MachineName']))
            elif key == 'SiteName':
                self.record[key]=keywords['SiteName']
            elif key == 'MachineName':
                self.record[key]=keywords['MachineName']
            elif key == 'ZoneName':
                self.record[key]=keywords['ZoneName']
            elif key == 'TimeZone':
                self.record[key]=keywords['TimeZone']
            elif key == 'LocalUserId':
                self.record[key]=keywords['LocalUserId']
            elif key == 'LocalGroupId':
                self.record[key]=keywords['LocalGroupId']
            elif key == 'Status':
                self.record[key]=keywords['Status']
            elif key == 'StartTime':
                self.record[key]=keywords['StartTime']
            elif key == 'EndTime':
                self.record[key]=keywords['EndTime']
            else:
                self.record[key]=value

    def get_information(self):
        """Gets record information"""
        tmp = ''
        for key, value in self.record.iteritems():
            tmp += '\n' + key + ': ' + str(value)
        tmp += '\n%%'
        return tmp
